/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.stubs.KotlinConstructorStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtPrimaryConstructorElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0017\b\u0016\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006\u00a2\u0006\u0004\b\u0004\u0010\bJ;\u0010\u000e\u001a\u0006*\u00028\u00008\u0000\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0017\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0017\u00a2\u0006\u0004\b \u0010!"}, d2={"Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "Lcom/intellij/lang/ASTNode;", "node", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "Lorg/jetbrains/kotlin/psi/stubs/KotlinConstructorStub;", "stub", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinConstructorStub;)V", "R", "D", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "visitor", "data", "accept", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getContainingClassOrObject", "()Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lcom/intellij/psi/PsiElement;", "getOrCreateConstructorKeyword", "()Lcom/intellij/psi/PsiElement;", "", "removeRedundantConstructorKeywordAndSpace", "()V", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "modifier", "addModifier", "(Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "removeModifier", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "addAnnotationEntry", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;)Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;"})
public final class KtPrimaryConstructor
extends KtConstructor<KtPrimaryConstructor> {
    public KtPrimaryConstructor(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        super(node);
    }

    public KtPrimaryConstructor(@NotNull KotlinConstructorStub<KtPrimaryConstructor> stub2) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        KtPrimaryConstructorElementType ktPrimaryConstructorElementType = KtStubElementTypes.PRIMARY_CONSTRUCTOR;
        Intrinsics.checkNotNullExpressionValue(ktPrimaryConstructorElementType, "PRIMARY_CONSTRUCTOR");
        super(stub2, ktPrimaryConstructorElementType);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitPrimaryConstructor(this, data2);
    }

    @Override
    @NotNull
    public KtClassOrObject getContainingClassOrObject() {
        PsiElement psiElement = this.getParent();
        Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
        return (KtClassOrObject)psiElement;
    }

    private final PsiElement getOrCreateConstructorKeyword() {
        PsiElement psiElement = this.getConstructorKeyword();
        if (psiElement == null) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
            PsiElement psiElement2 = new KtPsiFactory(project, false, 2, null).createConstructorKeyword();
            KtParameterList ktParameterList = this.getValueParameterList();
            Intrinsics.checkNotNull(ktParameterList);
            PsiElement psiElement3 = this.addBefore(psiElement2, ktParameterList);
            psiElement = psiElement3;
            Intrinsics.checkNotNullExpressionValue(psiElement3, "addBefore(...)");
        }
        return psiElement;
    }

    public final void removeRedundantConstructorKeywordAndSpace() {
        PsiElement psiElement = this.getConstructorKeyword();
        if (psiElement != null) {
            psiElement.delete();
        }
        if (this.getPrevSibling() instanceof PsiWhiteSpace) {
            this.getPrevSibling().delete();
        }
    }

    @Override
    public void addModifier(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkNotNullParameter(modifier, "modifier");
        KtModifierList modifierList2 = this.getModifierList();
        if (modifierList2 != null) {
            AddRemoveModifierKt.addModifier(modifierList2, modifier);
            if (this.getModifierList() == null) {
                PsiElement psiElement = this.getConstructorKeyword();
                if (psiElement != null) {
                    psiElement.delete();
                }
            }
        } else {
            if (Intrinsics.areEqual(modifier, KtTokens.PUBLIC_KEYWORD)) {
                return;
            }
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
            KtModifierList newModifierList = new KtPsiFactory(project, false, 2, null).createModifierList(modifier);
            this.addBefore(newModifierList, this.getOrCreateConstructorKeyword());
        }
    }

    @Override
    public void removeModifier(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkNotNullParameter(modifier, "modifier");
        super.removeModifier(modifier);
        if (this.getModifierList() == null) {
            this.removeRedundantConstructorKeywordAndSpace();
        }
    }

    @Override
    @NotNull
    public KtAnnotationEntry addAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry2) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkNotNullParameter(annotationEntry2, "annotationEntry");
        KtModifierList modifierList2 = this.getModifierList();
        if (modifierList2 != null) {
            PsiElement psiElement = modifierList2.addBefore(annotationEntry2, modifierList2.getFirstChild());
            Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
            ktAnnotationEntry = (KtAnnotationEntry)psiElement;
        } else {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
            KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
            String string2 = annotationEntry2.getText();
            Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
            KtModifierList newModifierList = ktPsiFactory.createModifierList(string2);
            PsiElement psiElement = this.addBefore(newModifierList, this.getOrCreateConstructorKeyword());
            Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtModifierList");
            List<KtAnnotationEntry> list = ((KtModifierList)psiElement).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list, "getAnnotationEntries(...)");
            KtAnnotationEntry ktAnnotationEntry2 = CollectionsKt.first(list);
            Intrinsics.checkNotNull(ktAnnotationEntry2);
            ktAnnotationEntry = ktAnnotationEntry2;
        }
        return ktAnnotationEntry;
    }
}

