/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinConstructorStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtSecondaryConstructorElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0017\b\u0016\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006\u00a2\u0006\u0004\b\u0004\u0010\bJ;\u0010\u000e\u001a\u0006*\u00028\u00008\u0000\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0011\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0014\u0010\u0018\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0011\u0010\u001d\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\r\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b\"\u0010#"}, d2={"Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "Lcom/intellij/lang/ASTNode;", "node", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "Lorg/jetbrains/kotlin/psi/stubs/KotlinConstructorStub;", "stub", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinConstructorStub;)V", "R", "D", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "visitor", "data", "accept", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getContainingClassOrObject", "()Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "getBodyExpression", "()Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/annotations/NotNull;", "getConstructorKeyword", "()Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "getDelegationCall", "()Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "getDelegationCallOrNull", "", "hasImplicitDelegationCall", "()Z", "isThis", "replaceImplicitDelegationCallWithExplicit", "(Z)Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;"})
public final class KtSecondaryConstructor
extends KtConstructor<KtSecondaryConstructor> {
    public KtSecondaryConstructor(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        super(node);
    }

    public KtSecondaryConstructor(@NotNull KotlinConstructorStub<KtSecondaryConstructor> stub2) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        KtSecondaryConstructorElementType ktSecondaryConstructorElementType = KtStubElementTypes.SECONDARY_CONSTRUCTOR;
        Intrinsics.checkNotNullExpressionValue(ktSecondaryConstructorElementType, "SECONDARY_CONSTRUCTOR");
        super(stub2, ktSecondaryConstructorElementType);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitSecondaryConstructor(this, data2);
    }

    @Override
    @NotNull
    public KtClassOrObject getContainingClassOrObject() {
        PsiElement psiElement = this.getParent().getParent();
        Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
        return (KtClassOrObject)psiElement;
    }

    @Override
    @Nullable
    public KtBlockExpression getBodyExpression() {
        KotlinConstructorStub stub2 = (KotlinConstructorStub)this.getStub();
        if (stub2 != null) {
            if (!stub2.hasBody()) {
                return null;
            }
            if (this.getContainingKtFile().isCompiled()) {
                return null;
            }
        }
        return this.findChildByClass(KtBlockExpression.class);
    }

    @Override
    @NotNull
    public PsiElement getConstructorKeyword() {
        PsiElement psiElement = this.notNullChild(super.getConstructorKeyword());
        Intrinsics.checkNotNullExpressionValue(psiElement, "notNullChild(...)");
        return psiElement;
    }

    @NotNull
    public final KtConstructorDelegationCall getDelegationCall() {
        KtConstructorDelegationCall ktConstructorDelegationCall = this.findNotNullChildByClass(KtConstructorDelegationCall.class);
        Intrinsics.checkNotNullExpressionValue(ktConstructorDelegationCall, "findNotNullChildByClass(...)");
        return ktConstructorDelegationCall;
    }

    @Nullable
    public final KtConstructorDelegationCall getDelegationCallOrNull() {
        return this.findChildByClass(KtConstructorDelegationCall.class);
    }

    public final boolean hasImplicitDelegationCall() {
        return this.getDelegationCall().isImplicit();
    }

    @NotNull
    public final KtConstructorDelegationCall replaceImplicitDelegationCallWithExplicit(boolean isThis) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtConstructorDelegationCall current = this.getDelegationCall();
        boolean bl = current.isImplicit();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-KtSecondaryConstructor$replaceImplicitDelegationCallWithExplicit$22 = false;
            String $i$a$-assert-KtSecondaryConstructor$replaceImplicitDelegationCallWithExplicit$22 = "Method should not be called with explicit delegation call: " + this.getText();
            throw new AssertionError((Object)$i$a$-assert-KtSecondaryConstructor$replaceImplicitDelegationCallWithExplicit$22);
        }
        current.delete();
        PsiElement colon = this.addAfter(psiFactory.createColon(), this.getValueParameterList());
        String delegationName = isThis ? "this" : "super";
        PsiElement psiElement = this.addAfter(psiFactory.creareDelegatedSuperTypeEntry(delegationName + "()"), colon);
        Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtConstructorDelegationCall");
        return (KtConstructorDelegationCall)psiElement;
    }
}

