/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.debugText;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.stubs.StubElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeConstraintList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ#\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012J#\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ#\u0010\u001d\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b\u001d\u0010\u001eJ#\u0010!\u001a\u0004\u0018\u00010\u00022\u0006\u0010 \u001a\u00020\u001f2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b!\u0010\"J#\u0010%\u001a\u0004\u0018\u00010\u00022\u0006\u0010$\u001a\u00020#2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b%\u0010&J#\u0010)\u001a\u0004\u0018\u00010\u00022\u0006\u0010(\u001a\u00020'2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b)\u0010*J#\u0010-\u001a\u0004\u0018\u00010\u00022\u0006\u0010,\u001a\u00020+2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b-\u0010.J#\u00101\u001a\u0004\u0018\u00010\u00022\u0006\u00100\u001a\u00020/2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b1\u00102J#\u00105\u001a\u0004\u0018\u00010\u00022\u0006\u00104\u001a\u0002032\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b5\u00106J#\u00109\u001a\u0004\u0018\u00010\u00022\u0006\u00108\u001a\u0002072\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b9\u0010:J#\u0010<\u001a\u0004\u0018\u00010\u00022\u0006\u0010$\u001a\u00020;2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b<\u0010=J#\u0010?\u001a\u0004\u0018\u00010\u00022\u0006\u0010$\u001a\u00020>2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b?\u0010@J#\u0010C\u001a\u0004\u0018\u00010\u00022\u0006\u0010B\u001a\u00020A2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bC\u0010DJ#\u0010F\u001a\u0004\u0018\u00010\u00022\u0006\u0010$\u001a\u00020E2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bF\u0010GJ#\u0010I\u001a\u0004\u0018\u00010\u00022\u0006\u0010$\u001a\u00020H2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bI\u0010JJ#\u0010M\u001a\u0004\u0018\u00010\u00022\u0006\u0010L\u001a\u00020K2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bM\u0010NJ#\u0010Q\u001a\u0004\u0018\u00010\u00022\u0006\u0010P\u001a\u00020O2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bQ\u0010RJ#\u0010U\u001a\u0004\u0018\u00010\u00022\u0006\u0010T\u001a\u00020S2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bU\u0010VJ#\u0010Y\u001a\u0004\u0018\u00010\u00022\u0006\u0010X\u001a\u00020W2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bY\u0010ZJ#\u0010\\\u001a\u0004\u0018\u00010\u00022\u0006\u0010$\u001a\u00020[2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b\\\u0010]J#\u0010_\u001a\u0004\u0018\u00010\u00022\u0006\u0010B\u001a\u00020^2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b_\u0010`J#\u0010c\u001a\u0004\u0018\u00010\u00022\u0006\u0010b\u001a\u00020a2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bc\u0010dJ#\u0010g\u001a\u0004\u0018\u00010\u00022\u0006\u0010f\u001a\u00020e2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bg\u0010hJ#\u0010k\u001a\u0004\u0018\u00010\u00022\u0006\u0010j\u001a\u00020i2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bk\u0010lJ#\u0010o\u001a\u0004\u0018\u00010\u00022\u0006\u0010n\u001a\u00020m2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bo\u0010pJ#\u0010s\u001a\u0004\u0018\u00010\u00022\u0006\u0010r\u001a\u00020q2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bs\u0010tJ#\u0010w\u001a\u0004\u0018\u00010\u00022\u0006\u0010v\u001a\u00020u2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bw\u0010xJ#\u0010{\u001a\u0004\u0018\u00010\u00022\u0006\u0010z\u001a\u00020y2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b{\u0010|J#\u0010~\u001a\u0004\u0018\u00010\u00022\u0006\u0010T\u001a\u00020}2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b~\u0010\u007fJ(\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u00022\b\u0010\u0081\u0001\u001a\u00030\u0080\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0006\b\u0082\u0001\u0010\u0083\u0001J(\u0010\u0086\u0001\u001a\u0004\u0018\u00010\u00022\b\u0010\u0085\u0001\u001a\u00030\u0084\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0006\b\u0086\u0001\u0010\u0087\u0001J0\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u00022\u001a\u0010\u008b\u0001\u001a\u0015\u0012\n\u0012\b0\u0089\u0001j\u0003`\u008a\u0001\u0012\u0004\u0012\u00020\u00030\u0088\u0001H\u0007\u00a2\u0006\u0006\b\u008c\u0001\u0010\u008d\u0001J@\u0010\u0092\u0001\u001a\u0004\u0018\u00010\u00022\u000b\u0010\f\u001a\u0007\u0012\u0002\b\u00030\u008e\u00012\u0007\u0010\u008f\u0001\u001a\u00020\u00022\t\b\u0002\u0010\u0090\u0001\u001a\u00020\u00022\t\b\u0002\u0010\u0091\u0001\u001a\u00020\u0002H\u0007\u00a2\u0006\u0006\b\u0092\u0001\u0010\u0093\u0001J;\u0010\u0096\u0001\u001a\u0004\u0018\u00010\u00022\u000b\u0010\f\u001a\u0007\u0012\u0002\b\u00030\u008e\u00012\u0018\u0010\u0095\u0001\u001a\r\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0\u0094\u0001\"\u0004\u0018\u00010\u000bH\u0007\u00a2\u0006\u0006\b\u0096\u0001\u0010\u0097\u0001R\u001e\u0010\u009a\u0001\u001a\t0\u0098\u0001\u00a2\u0006\u0003\b\u0099\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0006\b\u009a\u0001\u0010\u009b\u0001"}, d2={"Lorg/jetbrains/kotlin/psi/debugText/DebugTextBuildingVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "", "", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "data", "visitKtFile", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "visitKtElement", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "importDirective", "visitImportDirective", "(Lorg/jetbrains/kotlin/psi/KtImportDirective;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtImportList;", "importList", "visitImportList", "(Lorg/jetbrains/kotlin/psi/KtImportList;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "visitAnnotationEntry", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "typeReference", "visitTypeReference", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "typeArgumentList", "visitTypeArgumentList", "(Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtTypeConstraintList;", "list", "visitTypeConstraintList", "(Lorg/jetbrains/kotlin/psi/KtTypeConstraintList;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtUserType;", "userType", "visitUserType", "(Lorg/jetbrains/kotlin/psi/KtUserType;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtDynamicType;", "type", "visitDynamicType", "(Lorg/jetbrains/kotlin/psi/KtDynamicType;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtAnnotation;", "annotation", "visitAnnotation", "(Lorg/jetbrains/kotlin/psi/KtAnnotation;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtConstructorCalleeExpression;", "constructorCalleeExpression", "visitConstructorCalleeExpression", "(Lorg/jetbrains/kotlin/psi/KtConstructorCalleeExpression;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;", "specifier", "visitSuperTypeListEntry", "(Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtSuperTypeList;", "visitSuperTypeList", "(Lorg/jetbrains/kotlin/psi/KtSuperTypeList;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtTypeParameterList;", "visitTypeParameterList", "(Lorg/jetbrains/kotlin/psi/KtTypeParameterList;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "expression", "visitDotQualifiedExpression", "(Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtInitializerList;", "visitInitializerList", "(Lorg/jetbrains/kotlin/psi/KtInitializerList;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "visitParameterList", "(Lorg/jetbrains/kotlin/psi/KtParameterList;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "enumEntry", "visitEnumEntry", "(Lorg/jetbrains/kotlin/psi/KtEnumEntry;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtFunctionType;", "functionType", "visitFunctionType", "(Lorg/jetbrains/kotlin/psi/KtFunctionType;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "parameter", "visitTypeParameter", "(Lorg/jetbrains/kotlin/psi/KtTypeParameter;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "typeProjection", "visitTypeProjection", "(Lorg/jetbrains/kotlin/psi/KtTypeProjection;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "visitModifierList", "(Lorg/jetbrains/kotlin/psi/KtModifierList;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitSimpleNameExpression", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "nullableType", "visitNullableType", "(Lorg/jetbrains/kotlin/psi/KtNullableType;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "initializer", "visitAnonymousInitializer", "(Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "classBody", "visitClassBody", "(Lorg/jetbrains/kotlin/psi/KtClassBody;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "accessor", "visitPropertyAccessor", "(Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtClass;", "klass", "visitClass", "(Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "function", "visitNamedFunction", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "declaration", "visitObjectDeclaration", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitParameter", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "visitProperty", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtTypeConstraint;", "constraint", "visitTypeConstraint", "(Lorg/jetbrains/kotlin/psi/KtTypeConstraint;Lkotlin/Unit;)Ljava/lang/String;", "Lkotlin/Function1;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "body", "buildText", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtElementImplStub;", "separator", "prefix", "postfix", "renderChildren", "(Lorg/jetbrains/kotlin/psi/KtElementImplStub;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "", "relevantChildren", "render", "(Lorg/jetbrains/kotlin/psi/KtElementImplStub;[Lorg/jetbrains/kotlin/psi/KtElement;)Ljava/lang/String;", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;"})
final class DebugTextBuildingVisitor
extends KtVisitor<String, Unit> {
    @NotNull
    public static final DebugTextBuildingVisitor INSTANCE = new DebugTextBuildingVisitor();
    @NotNull
    private static final Logger LOG;

    private DebugTextBuildingVisitor() {
    }

    @Override
    @Nullable
    public String visitKtFile(@NotNull KtFile file2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return "STUB file: " + file2.getName();
    }

    @Override
    @Nullable
    public String visitKtElement(@NotNull KtElement element, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        if (element instanceof KtElementImplStub) {
            LOG.error("getDebugText() is not defined for " + element.getClass());
        }
        return element.getText();
    }

    @Override
    @Nullable
    public String visitImportDirective(@NotNull KtImportDirective importDirective, @Nullable Unit data2) {
        String string2;
        Intrinsics.checkNotNullParameter(importDirective, "importDirective");
        ImportPath importPath = importDirective.getImportPath();
        if (importPath == null) {
            return "import <invalid>";
        }
        ImportPath importPath2 = importPath;
        if (importPath2.hasAlias()) {
            StringBuilder stringBuilder = new StringBuilder().append(" as ");
            Name name = importPath2.getAlias();
            Intrinsics.checkNotNull(name);
            string2 = stringBuilder.append(name.asString()).toString();
        } else {
            string2 = "";
        }
        String aliasStr = string2;
        return "import " + importPath2.getPathStr() + aliasStr;
    }

    @Override
    @Nullable
    public String visitImportList(@NotNull KtImportList importList, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(importList, "importList");
        return DebugTextBuildingVisitor.renderChildren$default(this, importList, "\n", null, null, 12, null);
    }

    @Override
    @Nullable
    public String visitAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(annotationEntry2, "annotationEntry");
        KtElement[] ktElementArray = new KtElement[]{annotationEntry2.getCalleeExpression(), annotationEntry2.getTypeArgumentList()};
        return this.render(annotationEntry2, ktElementArray);
    }

    @Override
    @Nullable
    public String visitTypeReference(@NotNull KtTypeReference typeReference, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(typeReference, "typeReference");
        return DebugTextBuildingVisitor.renderChildren$default(this, typeReference, " ", null, null, 12, null);
    }

    @Override
    @Nullable
    public String visitTypeArgumentList(@NotNull KtTypeArgumentList typeArgumentList, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(typeArgumentList, "typeArgumentList");
        return this.renderChildren(typeArgumentList, ", ", "<", ">");
    }

    @Override
    @Nullable
    public String visitTypeConstraintList(@NotNull KtTypeConstraintList list, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(list, "list");
        return this.renderChildren(list, ", ", "where ", "");
    }

    @Override
    @Nullable
    public String visitUserType(@NotNull KtUserType userType, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(userType, "userType");
        KtElement[] ktElementArray = new KtElement[]{userType.getQualifier(), userType.getReferenceExpression(), userType.getTypeArgumentList()};
        return this.render(userType, ktElementArray);
    }

    @Override
    @Nullable
    public String visitDynamicType(@NotNull KtDynamicType type2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return "dynamic";
    }

    @Override
    @Nullable
    public String visitAnnotation(@NotNull KtAnnotation annotation, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(annotation, "annotation");
        return this.renderChildren(annotation, " ", "[", "]");
    }

    @Override
    @Nullable
    public String visitConstructorCalleeExpression(@NotNull KtConstructorCalleeExpression constructorCalleeExpression, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(constructorCalleeExpression, "constructorCalleeExpression");
        KtElement[] ktElementArray = new KtElement[]{constructorCalleeExpression.getConstructorReferenceExpression()};
        return this.render(constructorCalleeExpression, ktElementArray);
    }

    @Override
    @Nullable
    public String visitSuperTypeListEntry(@NotNull KtSuperTypeListEntry specifier, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(specifier, "specifier");
        KtElement[] ktElementArray = new KtElement[]{specifier.getTypeReference()};
        return this.render(specifier, ktElementArray);
    }

    @Override
    @Nullable
    public String visitSuperTypeList(@NotNull KtSuperTypeList list, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(list, "list");
        return DebugTextBuildingVisitor.renderChildren$default(this, list, ", ", null, null, 12, null);
    }

    @Override
    @Nullable
    public String visitTypeParameterList(@NotNull KtTypeParameterList list, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(list, "list");
        return this.renderChildren(list, ", ", "<", ">");
    }

    @Override
    @Nullable
    public String visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        return DebugTextBuildingVisitor.renderChildren$default(this, expression, ".", null, null, 12, null);
    }

    @Override
    @Nullable
    public String visitInitializerList(@NotNull KtInitializerList list, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(list, "list");
        return DebugTextBuildingVisitor.renderChildren$default(this, list, ", ", null, null, 12, null);
    }

    @Override
    @Nullable
    public String visitParameterList(@NotNull KtParameterList list, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(list, "list");
        return this.renderChildren(list, ", ", "(", ")");
    }

    @Override
    @Nullable
    public String visitEnumEntry(@NotNull KtEnumEntry enumEntry, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
        return this.buildText(arg_0 -> DebugTextBuildingVisitor.visitEnumEntry$lambda$0(enumEntry, arg_0));
    }

    @Override
    @Nullable
    public String visitFunctionType(@NotNull KtFunctionType functionType, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(functionType, "functionType");
        return this.buildText(arg_0 -> DebugTextBuildingVisitor.visitFunctionType$lambda$1(functionType, arg_0));
    }

    @Override
    @Nullable
    public String visitTypeParameter(@NotNull KtTypeParameter parameter, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        return this.buildText(arg_0 -> DebugTextBuildingVisitor.visitTypeParameter$lambda$2(parameter, arg_0));
    }

    @Override
    @Nullable
    public String visitTypeProjection(@NotNull KtTypeProjection typeProjection, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(typeProjection, "typeProjection");
        return this.buildText(arg_0 -> DebugTextBuildingVisitor.visitTypeProjection$lambda$3(typeProjection, arg_0));
    }

    @Override
    @Nullable
    public String visitModifierList(@NotNull KtModifierList list, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(list, "list");
        return this.buildText(arg_0 -> DebugTextBuildingVisitor.visitModifierList$lambda$4(list, arg_0));
    }

    @Override
    @Nullable
    public String visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        return expression.getReferencedName();
    }

    @Override
    @Nullable
    public String visitNullableType(@NotNull KtNullableType nullableType, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(nullableType, "nullableType");
        return this.renderChildren(nullableType, "", "", "?");
    }

    @Override
    @Nullable
    public String visitAnonymousInitializer(@NotNull KtAnonymousInitializer initializer, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(initializer, "initializer");
        KtDeclaration containingDeclaration = KtStubbedPsiUtil.getContainingDeclaration(initializer);
        StringBuilder stringBuilder = new StringBuilder().append("initializer in ");
        Object object = containingDeclaration;
        if (object == null || (object = DebugTextUtilKt.getDebugText((KtElement)object)) == null) {
            object = "...";
        }
        return stringBuilder.append((String)object).toString();
    }

    @Override
    @Nullable
    public String visitClassBody(@NotNull KtClassBody classBody, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(classBody, "classBody");
        KtDeclaration containingDeclaration = KtStubbedPsiUtil.getContainingDeclaration(classBody);
        StringBuilder stringBuilder = new StringBuilder().append("class body for ");
        Object object = containingDeclaration;
        if (object == null || (object = DebugTextUtilKt.getDebugText((KtElement)object)) == null) {
            object = "...";
        }
        return stringBuilder.append((String)object).toString();
    }

    @Override
    @Nullable
    public String visitPropertyAccessor(@NotNull KtPropertyAccessor accessor, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(accessor, "accessor");
        KtProperty containingProperty = KtStubbedPsiUtil.getContainingDeclaration(accessor, KtProperty.class);
        String what = accessor.isGetter() ? "getter" : "setter";
        StringBuilder stringBuilder = new StringBuilder().append(what).append(" for ");
        Object object = containingProperty;
        if (object == null || (object = DebugTextUtilKt.getDebugText((KtElement)object)) == null) {
            object = "...";
        }
        return stringBuilder.append((String)object).toString();
    }

    @Override
    @Nullable
    public String visitClass(@NotNull KtClass klass, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        return this.buildText(arg_0 -> DebugTextBuildingVisitor.visitClass$lambda$5(klass, arg_0));
    }

    @Override
    @Nullable
    public String visitNamedFunction(@NotNull KtNamedFunction function2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return this.buildText(arg_0 -> DebugTextBuildingVisitor.visitNamedFunction$lambda$6(function2, arg_0));
    }

    @Override
    @Nullable
    public String visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        return this.buildText(arg_0 -> DebugTextBuildingVisitor.visitObjectDeclaration$lambda$7(declaration, arg_0));
    }

    @Override
    @Nullable
    public String visitParameter(@NotNull KtParameter parameter, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        return this.buildText(arg_0 -> DebugTextBuildingVisitor.visitParameter$lambda$8(parameter, arg_0));
    }

    @Override
    @Nullable
    public String visitProperty(@NotNull KtProperty property, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(property, "property");
        return this.buildText(arg_0 -> DebugTextBuildingVisitor.visitProperty$lambda$9(property, arg_0));
    }

    @Override
    @Nullable
    public String visitTypeConstraint(@NotNull KtTypeConstraint constraint, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(constraint, "constraint");
        return this.buildText(arg_0 -> DebugTextBuildingVisitor.visitTypeConstraint$lambda$10(constraint, arg_0));
    }

    @Nullable
    public final String buildText(@NotNull Function1<? super StringBuilder, Unit> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        StringBuilder sb = new StringBuilder();
        body2.invoke(sb);
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String renderChildren(@NotNull KtElementImplStub<?> element, @NotNull String separator, @NotNull String prefix, @NotNull String postfix) {
        String childrenTexts;
        String string2;
        Object object;
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(separator, "separator");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(postfix, "postfix");
        Object t = element.getStub();
        if (t != null && (t = t.getChildrenStubs()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)t;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                StubElement it = (StubElement)element$iv$iv;
                boolean bl2 = false;
                StubElement stubElement = it;
                Object t2 = stubElement != null ? stubElement.getPsi() : null;
                KtElement ktElement = t2 instanceof KtElement ? (KtElement)t2 : null;
                if ((ktElement != null ? DebugTextUtilKt.getDebugText(ktElement) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            object = (List)destination$iv$iv;
        } else {
            object = null;
        }
        if ((string2 = (childrenTexts = object)) == null || (string2 = CollectionsKt.joinToString$default((Iterable)((Object)string2), separator, prefix, postfix, 0, null, null, 56, null)) == null) {
            string2 = element.getText();
        }
        return string2;
    }

    public static /* synthetic */ String renderChildren$default(DebugTextBuildingVisitor debugTextBuildingVisitor, KtElementImplStub ktElementImplStub, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            string4 = "";
        }
        return debugTextBuildingVisitor.renderChildren(ktElementImplStub, string2, string3, string4);
    }

    @Nullable
    public final String render(@NotNull KtElementImplStub<?> element, KtElement ... relevantChildren) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(relevantChildren, "relevantChildren");
        if (element.getStub() == null) {
            return element.getText();
        }
        return CollectionsKt.joinToString$default(ArraysKt.filterNotNull(relevantChildren), "", "", "", 0, null, DebugTextBuildingVisitor::render$lambda$12, 24, null);
    }

    private static final Unit visitEnumEntry$lambda$0(KtEnumEntry $enumEntry, StringBuilder $this$buildText) {
        Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
        $this$buildText.append("STUB: ");
        DebugTextUtilKt.appendInn$default($this$buildText, $enumEntry.getModifierList(), null, " ", 2, null);
        $this$buildText.append("enum entry ");
        DebugTextUtilKt.appendInn$default($this$buildText, $enumEntry.getNameAsName(), null, null, 6, null);
        DebugTextUtilKt.appendInn$default($this$buildText, $enumEntry.getInitializerList(), " : ", null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit visitFunctionType$lambda$1(KtFunctionType $functionType, StringBuilder $this$buildText) {
        Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
        DebugTextUtilKt.appendInn$default($this$buildText, $functionType.getReceiverTypeReference(), null, ".", 2, null);
        DebugTextUtilKt.appendInn$default($this$buildText, $functionType.getParameterList(), null, null, 6, null);
        DebugTextUtilKt.appendInn$default($this$buildText, $functionType.getReturnTypeReference(), " -> ", null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit visitTypeParameter$lambda$2(KtTypeParameter $parameter, StringBuilder $this$buildText) {
        Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
        DebugTextUtilKt.appendInn$default($this$buildText, $parameter.getModifierList(), null, " ", 2, null);
        DebugTextUtilKt.appendInn$default($this$buildText, $parameter.getNameAsName(), null, null, 6, null);
        DebugTextUtilKt.appendInn$default($this$buildText, $parameter.getExtendsBound(), " : ", null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit visitTypeProjection$lambda$3(KtTypeProjection $typeProjection, StringBuilder $this$buildText) {
        KtSingleValueToken token;
        Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
        KtSingleValueToken ktSingleValueToken = token = $typeProjection.getProjectionKind().getToken();
        DebugTextUtilKt.appendInn$default($this$buildText, ktSingleValueToken != null ? ktSingleValueToken.getValue() : null, null, null, 6, null);
        KtTypeReference typeReference = $typeProjection.getTypeReference();
        if (token != null && typeReference != null) {
            $this$buildText.append(" ");
        }
        DebugTextUtilKt.appendInn$default($this$buildText, typeReference, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit visitModifierList$lambda$4(KtModifierList $list, StringBuilder $this$buildText) {
        Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
        boolean first2 = true;
        Iterator<KtModifierKeywordToken> iterator2 = ArrayIteratorKt.iterator(KtTokens.MODIFIER_KEYWORDS_ARRAY);
        while (iterator2.hasNext()) {
            KtModifierKeywordToken modifierKeywordToken = iterator2.next();
            if (!$list.hasModifier(modifierKeywordToken)) continue;
            if (!first2) {
                $this$buildText.append(" ");
            }
            $this$buildText.append(modifierKeywordToken.getValue());
            first2 = false;
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitClass$lambda$5(KtClass $klass, StringBuilder $this$buildText) {
        Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
        $this$buildText.append("STUB: ");
        DebugTextUtilKt.appendInn$default($this$buildText, $klass.getModifierList(), null, " ", 2, null);
        $this$buildText.append("class ");
        DebugTextUtilKt.appendInn$default($this$buildText, $klass.getNameAsName(), null, null, 6, null);
        DebugTextUtilKt.appendInn$default($this$buildText, $klass.getTypeParameterList(), null, null, 6, null);
        DebugTextUtilKt.access$appendInn($this$buildText, $klass.getPrimaryConstructorModifierList(), " ", " ");
        DebugTextUtilKt.appendInn$default($this$buildText, $klass.getPrimaryConstructorParameterList(), null, null, 6, null);
        DebugTextUtilKt.appendInn$default($this$buildText, $klass.getSuperTypeList(), " : ", null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit visitNamedFunction$lambda$6(KtNamedFunction $function, StringBuilder $this$buildText) {
        Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
        $this$buildText.append("STUB: ");
        DebugTextUtilKt.appendInn$default($this$buildText, $function.getModifierList(), null, " ", 2, null);
        $this$buildText.append("fun ");
        KtTypeParameterList typeParameterList = $function.getTypeParameterList();
        if ($function.hasTypeParameterListBeforeFunctionName()) {
            DebugTextUtilKt.appendInn$default($this$buildText, typeParameterList, null, " ", 2, null);
        }
        DebugTextUtilKt.appendInn$default($this$buildText, $function.getReceiverTypeReference(), null, ".", 2, null);
        DebugTextUtilKt.appendInn$default($this$buildText, $function.getNameAsName(), null, null, 6, null);
        if (!$function.hasTypeParameterListBeforeFunctionName()) {
            DebugTextUtilKt.appendInn$default($this$buildText, typeParameterList, null, null, 6, null);
        }
        DebugTextUtilKt.appendInn$default($this$buildText, $function.getValueParameterList(), null, null, 6, null);
        DebugTextUtilKt.appendInn$default($this$buildText, $function.getTypeReference(), ": ", null, 4, null);
        DebugTextUtilKt.appendInn$default($this$buildText, $function.getTypeConstraintList(), " ", null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit visitObjectDeclaration$lambda$7(KtObjectDeclaration $declaration, StringBuilder $this$buildText) {
        Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
        $this$buildText.append("STUB: ");
        DebugTextUtilKt.appendInn$default($this$buildText, $declaration.getModifierList(), null, " ", 2, null);
        $this$buildText.append("object ");
        DebugTextUtilKt.appendInn$default($this$buildText, $declaration.getNameAsName(), null, null, 6, null);
        DebugTextUtilKt.appendInn$default($this$buildText, $declaration.getSuperTypeList(), " : ", null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit visitParameter$lambda$8(KtParameter $parameter, StringBuilder $this$buildText) {
        Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
        if ($parameter.hasValOrVar()) {
            StringBuilder stringBuilder = $parameter.isMutable() ? $this$buildText.append("var ") : $this$buildText.append("val ");
        }
        Name name = $parameter.getNameAsName();
        DebugTextUtilKt.appendInn$default($this$buildText, name, null, null, 6, null);
        KtTypeReference typeReference = $parameter.getTypeReference();
        if (typeReference != null && name != null) {
            $this$buildText.append(": ");
        }
        DebugTextUtilKt.appendInn$default($this$buildText, typeReference, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit visitProperty$lambda$9(KtProperty $property, StringBuilder $this$buildText) {
        Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
        $this$buildText.append("STUB: ");
        DebugTextUtilKt.appendInn$default($this$buildText, $property.getModifierList(), null, " ", 2, null);
        $this$buildText.append($property.isVar() ? "var " : "val ");
        DebugTextUtilKt.appendInn$default($this$buildText, $property.getNameAsName(), null, null, 6, null);
        DebugTextUtilKt.appendInn$default($this$buildText, $property.getTypeReference(), ": ", null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit visitTypeConstraint$lambda$10(KtTypeConstraint $constraint, StringBuilder $this$buildText) {
        Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
        DebugTextUtilKt.appendInn$default($this$buildText, $constraint.getSubjectTypeParameterName(), null, null, 6, null);
        DebugTextUtilKt.appendInn$default($this$buildText, $constraint.getBoundTypeReference(), " : ", null, 4, null);
        return Unit.INSTANCE;
    }

    private static final CharSequence render$lambda$12(KtElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return DebugTextUtilKt.getDebugText(it);
    }

    static {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
    }
}

