/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.stubs.ConstantValueKind;
import org.jetbrains.kotlin.psi.stubs.KotlinConstantExpressionStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinConstantExpressionStubImpl;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001bB\u0011\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u0010\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J%\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00182\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType;", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinConstantExpressionStub;", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "", "debugName", "<init>", "(Ljava/lang/String;)V", "Lcom/intellij/lang/ASTNode;", "node", "", "shouldCreateStub", "(Lcom/intellij/lang/ASTNode;)Z", "psi", "Lcom/intellij/psi/stubs/StubElement;", "parentStub", "createStub", "(Lorg/jetbrains/kotlin/psi/KtConstantExpression;Lcom/intellij/psi/stubs/StubElement;)Lorg/jetbrains/kotlin/psi/stubs/KotlinConstantExpressionStub;", "stub", "Lcom/intellij/psi/stubs/StubOutputStream;", "dataStream", "", "serialize", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinConstantExpressionStub;Lcom/intellij/psi/stubs/StubOutputStream;)V", "Lcom/intellij/psi/stubs/StubInputStream;", "deserialize", "(Lcom/intellij/psi/stubs/StubInputStream;Lcom/intellij/psi/stubs/StubElement;)Lorg/jetbrains/kotlin/psi/stubs/KotlinConstantExpressionStub;", "Companion"})
public final class KtConstantExpressionElementType
extends KtStubElementType<KotlinConstantExpressionStub, KtConstantExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public KtConstantExpressionElementType(@NotNull String debugName) {
        Intrinsics.checkNotNullParameter(debugName, "debugName");
        super(debugName, KtConstantExpression.class, KotlinConstantExpressionStub.class);
    }

    @Override
    public boolean shouldCreateStub(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        ASTNode aSTNode = node.getTreeParent();
        if (aSTNode == null) {
            return false;
        }
        ASTNode parent2 = aSTNode;
        if (!Intrinsics.areEqual(parent2.getElementType(), KtStubElementTypes.VALUE_ARGUMENT)) {
            return false;
        }
        return super.shouldCreateStub(node);
    }

    @Override
    @NotNull
    public KotlinConstantExpressionStub createStub(@NotNull KtConstantExpression psi, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter(psi, "psi");
        IElementType iElementType = psi.getNode().getElementType();
        KtConstantExpressionElementType ktConstantExpressionElementType = iElementType instanceof KtConstantExpressionElementType ? (KtConstantExpressionElementType)iElementType : null;
        if (ktConstantExpressionElementType == null) {
            throw new IllegalStateException("Stub element type is expected for constant");
        }
        KtConstantExpressionElementType elementType = ktConstantExpressionElementType;
        String string2 = psi.getText();
        if (string2 == null) {
            string2 = "";
        }
        String value2 = string2;
        ConstantValueKind constantValueKind = KtConstantExpressionElementType.Companion.constantElementTypeToKind(elementType);
        StringRef stringRef = StringRef.fromString(value2);
        Intrinsics.checkNotNullExpressionValue(stringRef, "fromString(...)");
        return new KotlinConstantExpressionStubImpl(parentStub, elementType, constantValueKind, stringRef);
    }

    public void serialize(@NotNull KotlinConstantExpressionStub stub2, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        dataStream.writeInt(stub2.kind().ordinal());
        dataStream.writeName(stub2.value());
    }

    @NotNull
    public KotlinConstantExpressionStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        int kindOrdinal = dataStream.readInt();
        StringRef stringRef = dataStream.readName();
        if (stringRef == null) {
            stringRef = StringRef.fromString("");
        }
        StringRef value2 = stringRef;
        ConstantValueKind valueKind = (ConstantValueKind)((Object)ConstantValueKind.getEntries().get(kindOrdinal));
        KtConstantExpressionElementType ktConstantExpressionElementType = Companion.kindToConstantElementType(valueKind);
        Intrinsics.checkNotNull(value2);
        return new KotlinConstantExpressionStubImpl(parentStub, ktConstantExpressionElementType, valueKind, value2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/stubs/ConstantValueKind;", "kind", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType;", "kindToConstantElementType", "(Lorg/jetbrains/kotlin/psi/stubs/ConstantValueKind;)Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType;", "elementType", "constantElementTypeToKind", "(Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType;)Lorg/jetbrains/kotlin/psi/stubs/ConstantValueKind;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KtConstantExpressionElementType kindToConstantElementType(@NotNull ConstantValueKind kind) {
            KtConstantExpressionElementType ktConstantExpressionElementType;
            Intrinsics.checkNotNullParameter((Object)kind, "kind");
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    KtConstantExpressionElementType ktConstantExpressionElementType2 = KtStubElementTypes.NULL;
                    ktConstantExpressionElementType = ktConstantExpressionElementType2;
                    Intrinsics.checkNotNullExpressionValue(ktConstantExpressionElementType2, "NULL");
                    break;
                }
                case 2: {
                    KtConstantExpressionElementType ktConstantExpressionElementType3 = KtStubElementTypes.BOOLEAN_CONSTANT;
                    ktConstantExpressionElementType = ktConstantExpressionElementType3;
                    Intrinsics.checkNotNullExpressionValue(ktConstantExpressionElementType3, "BOOLEAN_CONSTANT");
                    break;
                }
                case 3: {
                    KtConstantExpressionElementType ktConstantExpressionElementType4 = KtStubElementTypes.FLOAT_CONSTANT;
                    ktConstantExpressionElementType = ktConstantExpressionElementType4;
                    Intrinsics.checkNotNullExpressionValue(ktConstantExpressionElementType4, "FLOAT_CONSTANT");
                    break;
                }
                case 4: {
                    KtConstantExpressionElementType ktConstantExpressionElementType5 = KtStubElementTypes.CHARACTER_CONSTANT;
                    ktConstantExpressionElementType = ktConstantExpressionElementType5;
                    Intrinsics.checkNotNullExpressionValue(ktConstantExpressionElementType5, "CHARACTER_CONSTANT");
                    break;
                }
                case 5: {
                    KtConstantExpressionElementType ktConstantExpressionElementType6 = KtStubElementTypes.INTEGER_CONSTANT;
                    ktConstantExpressionElementType = ktConstantExpressionElementType6;
                    Intrinsics.checkNotNullExpressionValue(ktConstantExpressionElementType6, "INTEGER_CONSTANT");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return ktConstantExpressionElementType;
        }

        private final ConstantValueKind constantElementTypeToKind(KtConstantExpressionElementType elementType) {
            ConstantValueKind constantValueKind;
            KtConstantExpressionElementType ktConstantExpressionElementType = elementType;
            if (Intrinsics.areEqual(ktConstantExpressionElementType, KtStubElementTypes.NULL)) {
                constantValueKind = ConstantValueKind.NULL;
            } else if (Intrinsics.areEqual(ktConstantExpressionElementType, KtStubElementTypes.BOOLEAN_CONSTANT)) {
                constantValueKind = ConstantValueKind.BOOLEAN_CONSTANT;
            } else if (Intrinsics.areEqual(ktConstantExpressionElementType, KtStubElementTypes.INTEGER_CONSTANT)) {
                constantValueKind = ConstantValueKind.INTEGER_CONSTANT;
            } else if (Intrinsics.areEqual(ktConstantExpressionElementType, KtStubElementTypes.FLOAT_CONSTANT)) {
                constantValueKind = ConstantValueKind.FLOAT_CONSTANT;
            } else if (Intrinsics.areEqual(ktConstantExpressionElementType, KtStubElementTypes.CHARACTER_CONSTANT)) {
                constantValueKind = ConstantValueKind.CHARACTER_CONSTANT;
            } else {
                throw new IllegalStateException("Unknown constant node type: " + elementType);
            }
            return constantValueKind;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ConstantValueKind.values().length];
                try {
                    nArray[ConstantValueKind.NULL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConstantValueKind.BOOLEAN_CONSTANT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConstantValueKind.FLOAT_CONSTANT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConstantValueKind.CHARACTER_CONSTANT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConstantValueKind.INTEGER_CONSTANT.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

