/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.stubs.KotlinConstructorStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u00028\u00000\u00012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0004\u0012\u00028\u00000\u0003B1\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJC\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H%\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\u0012\u0010\u0017J\u0017\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\u0013\u0010\u0017J)\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u0018\u001a\u00028\u00002\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\fH\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ%\u0010\u001f\u001a\u00020\u001e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J)\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u001d\u001a\u00020!2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\fH\u0017\u00a2\u0006\u0004\b\"\u0010#J%\u0010&\u001a\u00020\u001e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b&\u0010'"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstructorElementType;", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "T", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinConstructorStub;", "", "debugName", "Ljava/lang/Class;", "tClass", "stubClass", "<init>", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Class;)V", "Lcom/intellij/psi/stubs/StubElement;", "parentStub", "Lcom/intellij/util/io/StringRef;", "nameRef", "", "hasBody", "isDelegatedCallToThis", "isExplicitDelegationCall", "newStub", "(Lcom/intellij/psi/stubs/StubElement;Lcom/intellij/util/io/StringRef;ZZZ)Lorg/jetbrains/kotlin/psi/stubs/KotlinConstructorStub;", "constructor", "(Lorg/jetbrains/kotlin/psi/KtConstructor;)Z", "psi", "createStub", "(Lorg/jetbrains/kotlin/psi/KtConstructor;Lcom/intellij/psi/stubs/StubElement;)Lorg/jetbrains/kotlin/psi/stubs/KotlinConstructorStub;", "stub", "Lcom/intellij/psi/stubs/StubOutputStream;", "dataStream", "", "serialize", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinConstructorStub;Lcom/intellij/psi/stubs/StubOutputStream;)V", "Lcom/intellij/psi/stubs/StubInputStream;", "deserialize", "(Lcom/intellij/psi/stubs/StubInputStream;Lcom/intellij/psi/stubs/StubElement;)Lorg/jetbrains/kotlin/psi/stubs/KotlinConstructorStub;", "Lcom/intellij/psi/stubs/IndexSink;", "sink", "indexStub", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinConstructorStub;Lcom/intellij/psi/stubs/IndexSink;)V"})
public abstract class KtConstructorElementType<T extends KtConstructor<T>>
extends KtStubElementType<KotlinConstructorStub<T>, T> {
    public KtConstructorElementType(@NotNull String debugName, @NotNull Class<T> tClass, @NotNull Class<KotlinConstructorStub<?>> stubClass) {
        Intrinsics.checkNotNullParameter(debugName, "debugName");
        Intrinsics.checkNotNullParameter(tClass, "tClass");
        Intrinsics.checkNotNullParameter(stubClass, "stubClass");
        super(debugName, tClass, stubClass);
    }

    @NotNull
    protected abstract KotlinConstructorStub<T> newStub(@NotNull StubElement<?> var1, @Nullable StringRef var2, boolean var3, boolean var4, boolean var5);

    protected abstract boolean isDelegatedCallToThis(@NotNull T var1);

    protected abstract boolean isExplicitDelegationCall(@NotNull T var1);

    @Override
    @NotNull
    public KotlinConstructorStub<T> createStub(@NotNull T psi, @NotNull StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter(psi, "psi");
        Intrinsics.checkNotNullParameter(parentStub, "parentStub");
        boolean hasBody = ((KtConstructor)psi).hasBody();
        boolean isDelegatedCallToThis = this.isDelegatedCallToThis(psi);
        boolean isExplicitDelegationCall = this.isExplicitDelegationCall(psi);
        return this.newStub(parentStub, StringRef.fromString(((KtConstructor)psi).getName()), hasBody, isDelegatedCallToThis, isExplicitDelegationCall);
    }

    public void serialize(@NotNull KotlinConstructorStub<T> stub2, @NotNull StubOutputStream dataStream) throws IOException {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        dataStream.writeName(stub2.getName());
        dataStream.writeBoolean(stub2.hasBody());
        dataStream.writeBoolean(stub2.isDelegatedCallToThis());
        dataStream.writeBoolean(stub2.isExplicitDelegationCall());
    }

    @NotNull
    public KotlinConstructorStub<T> deserialize(@NotNull StubInputStream dataStream, @NotNull StubElement<?> parentStub) throws IOException {
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        Intrinsics.checkNotNullParameter(parentStub, "parentStub");
        StringRef name = dataStream.readName();
        boolean hasBody = dataStream.readBoolean();
        boolean isDelegatedCallToThis = dataStream.readBoolean();
        boolean isExplicitDelegationCall = dataStream.readBoolean();
        return this.newStub(parentStub, name, hasBody, isDelegatedCallToThis, isExplicitDelegationCall);
    }

    @Override
    public void indexStub(@NotNull KotlinConstructorStub<T> stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(sink, "sink");
    }
}

