/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFunctionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinStubOrigin;

public class KtFunctionElementType
extends KtStubElementType<KotlinFunctionStub, KtNamedFunction> {
    public KtFunctionElementType(@NotNull String debugName) {
        if (debugName == null) {
            KtFunctionElementType.$$$reportNull$$$0(0);
        }
        super(debugName, KtNamedFunction.class, KotlinFunctionStub.class);
    }

    @Override
    @NotNull
    public KotlinFunctionStub createStub(@NotNull KtNamedFunction psi, @NotNull StubElement parentStub) {
        if (psi == null) {
            KtFunctionElementType.$$$reportNull$$$0(1);
        }
        if (parentStub == null) {
            KtFunctionElementType.$$$reportNull$$$0(2);
        }
        boolean isTopLevel = psi.getParent() instanceof KtFile;
        boolean isExtension = psi.getReceiverTypeReference() != null;
        FqName fqName2 = KtPsiUtilKt.safeFqNameForLazyResolve(psi);
        boolean hasBlockBody = psi.hasBlockBody();
        boolean hasBody = psi.hasBody();
        return new KotlinFunctionStubImpl(parentStub, StringRef.fromString(psi.getName()), isTopLevel, fqName2, isExtension, hasBlockBody, hasBody, psi.hasTypeParameterListBeforeFunctionName(), psi.mayHaveContract(), null, null);
    }

    public void serialize(@NotNull KotlinFunctionStub stub2, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub2 == null) {
            KtFunctionElementType.$$$reportNull$$$0(3);
        }
        if (dataStream == null) {
            KtFunctionElementType.$$$reportNull$$$0(4);
        }
        dataStream.writeName(stub2.getName());
        dataStream.writeBoolean(stub2.isTopLevel());
        FqName fqName2 = stub2.getFqName();
        dataStream.writeName(fqName2 != null ? fqName2.asString() : null);
        dataStream.writeBoolean(stub2.isExtension());
        dataStream.writeBoolean(stub2.hasBlockBody());
        dataStream.writeBoolean(stub2.hasBody());
        dataStream.writeBoolean(stub2.hasTypeParameterListBeforeFunctionName());
        boolean haveContract = stub2.mayHaveContract();
        dataStream.writeBoolean(haveContract);
        if (stub2 instanceof KotlinFunctionStubImpl) {
            KotlinFunctionStubImpl stubImpl = (KotlinFunctionStubImpl)stub2;
            if (haveContract) {
                stubImpl.serializeContract(dataStream);
            }
            KotlinStubOrigin.serialize(stubImpl.getOrigin(), dataStream);
        }
    }

    @NotNull
    public KotlinFunctionStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            KtFunctionElementType.$$$reportNull$$$0(5);
        }
        StringRef name = dataStream.readName();
        boolean isTopLevel = dataStream.readBoolean();
        StringRef fqNameAsString = dataStream.readName();
        FqName fqName2 = fqNameAsString != null ? new FqName(fqNameAsString.toString()) : null;
        boolean isExtension = dataStream.readBoolean();
        boolean hasBlockBody = dataStream.readBoolean();
        boolean hasBody = dataStream.readBoolean();
        boolean hasTypeParameterListBeforeFunctionName = dataStream.readBoolean();
        boolean mayHaveContract = dataStream.readBoolean();
        return new KotlinFunctionStubImpl(parentStub, name, isTopLevel, fqName2, isExtension, hasBlockBody, hasBody, hasTypeParameterListBeforeFunctionName, mayHaveContract, mayHaveContract ? KotlinFunctionStubImpl.Companion.deserializeContract(dataStream) : null, KotlinStubOrigin.deserialize(dataStream));
    }

    @Override
    public void indexStub(@NotNull KotlinFunctionStub stub2, @NotNull IndexSink sink) {
        if (stub2 == null) {
            KtFunctionElementType.$$$reportNull$$$0(6);
        }
        if (sink == null) {
            KtFunctionElementType.$$$reportNull$$$0(7);
        }
        StubIndexService.getInstance().indexFunction(stub2, sink);
    }

    @Override
    @NotNull
    public String getExternalId() {
        return "kotlin.FUNCTION";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/psi/stubs/elements/KtFunctionElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

