/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinScriptStubImpl;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0017\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00142\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtScriptElementType;", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinScriptStub;", "Lorg/jetbrains/kotlin/psi/KtScript;", "", "debugName", "<init>", "(Ljava/lang/String;)V", "psi", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "parentStub", "createStub", "(Lorg/jetbrains/kotlin/psi/KtScript;Lcom/intellij/psi/stubs/StubElement;)Lorg/jetbrains/kotlin/psi/stubs/KotlinScriptStub;", "stub", "Lcom/intellij/psi/stubs/StubOutputStream;", "dataStream", "", "serialize", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinScriptStub;Lcom/intellij/psi/stubs/StubOutputStream;)V", "Lcom/intellij/psi/stubs/StubInputStream;", "deserialize", "(Lcom/intellij/psi/stubs/StubInputStream;Lcom/intellij/psi/stubs/StubElement;)Lorg/jetbrains/kotlin/psi/stubs/KotlinScriptStub;", "Lcom/intellij/psi/stubs/IndexSink;", "sink", "indexStub", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinScriptStub;Lcom/intellij/psi/stubs/IndexSink;)V"})
public final class KtScriptElementType
extends KtStubElementType<KotlinScriptStub, KtScript> {
    public KtScriptElementType(@NotNull String debugName) {
        Intrinsics.checkNotNullParameter(debugName, "debugName");
        super(debugName, KtScript.class, KotlinScriptStub.class);
    }

    @Override
    @NotNull
    public KotlinScriptStub createStub(@NotNull KtScript psi, @NotNull StubElement<? extends PsiElement> parentStub) {
        Intrinsics.checkNotNullParameter(psi, "psi");
        Intrinsics.checkNotNullParameter(parentStub, "parentStub");
        return new KotlinScriptStubImpl(parentStub, StringRef.fromString(psi.getFqName().asString()));
    }

    public void serialize(@NotNull KotlinScriptStub stub2, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        dataStream.writeName(stub2.getFqName().asString());
    }

    @NotNull
    public KotlinScriptStub deserialize(@NotNull StubInputStream dataStream, @NotNull StubElement<PsiElement> parentStub) {
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        Intrinsics.checkNotNullParameter(parentStub, "parentStub");
        StringRef fqName2 = dataStream.readName();
        return new KotlinScriptStubImpl(parentStub, fqName2);
    }

    @Override
    public void indexStub(@NotNull KotlinScriptStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(sink, "sink");
        StubIndexService.Companion.getInstance().indexScript(stub2, sink);
    }
}

