/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinParameterStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import org.jetbrains.kotlin.psi.stubs.KotlinTypeAliasStub;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 .2\u00020\u0001:\u0001.B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010!\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020\u00042\u0006\u0010$\u001a\u00020#H\u0017\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010)\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010(\u001a\u00020'H\u0016\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010,\u001a\u00020\u00042\u0006\u0010(\u001a\u00020+H\u0017\u00a2\u0006\u0004\b,\u0010-"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/StubIndexService;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/stubs/KotlinFileStub;", "stub", "Lcom/intellij/psi/stubs/IndexSink;", "sink", "", "indexFile", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinFileStub;Lcom/intellij/psi/stubs/IndexSink;)V", "Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "indexClass", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;Lcom/intellij/psi/stubs/IndexSink;)V", "Lorg/jetbrains/kotlin/psi/stubs/KotlinFunctionStub;", "indexFunction", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinFunctionStub;Lcom/intellij/psi/stubs/IndexSink;)V", "Lorg/jetbrains/kotlin/psi/stubs/KotlinTypeAliasStub;", "indexTypeAlias", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinTypeAliasStub;Lcom/intellij/psi/stubs/IndexSink;)V", "Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "indexObject", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;Lcom/intellij/psi/stubs/IndexSink;)V", "Lorg/jetbrains/kotlin/psi/stubs/KotlinPropertyStub;", "indexProperty", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinPropertyStub;Lcom/intellij/psi/stubs/IndexSink;)V", "Lorg/jetbrains/kotlin/psi/stubs/KotlinParameterStub;", "indexParameter", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinParameterStub;Lcom/intellij/psi/stubs/IndexSink;)V", "Lorg/jetbrains/kotlin/psi/stubs/KotlinAnnotationEntryStub;", "indexAnnotation", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinAnnotationEntryStub;Lcom/intellij/psi/stubs/IndexSink;)V", "Lorg/jetbrains/kotlin/psi/stubs/KotlinScriptStub;", "indexScript", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinScriptStub;Lcom/intellij/psi/stubs/IndexSink;)V", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "createFileStub", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/psi/stubs/KotlinFileStub;", "Lcom/intellij/psi/stubs/StubOutputStream;", "dataStream", "serializeFileStub", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinFileStub;Lcom/intellij/psi/stubs/StubOutputStream;)V", "Lcom/intellij/psi/stubs/StubInputStream;", "deserializeFileStub", "(Lcom/intellij/psi/stubs/StubInputStream;)Lorg/jetbrains/kotlin/psi/stubs/KotlinFileStub;", "Companion"})
public class StubIndexService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final StubIndexService NO_INDEX = new StubIndexService();

    protected StubIndexService() {
    }

    public void indexFile(@NotNull KotlinFileStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(sink, "sink");
    }

    public void indexClass(@NotNull KotlinClassStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(sink, "sink");
    }

    public void indexFunction(@NotNull KotlinFunctionStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(sink, "sink");
    }

    public void indexTypeAlias(@NotNull KotlinTypeAliasStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(sink, "sink");
    }

    public void indexObject(@NotNull KotlinObjectStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(sink, "sink");
    }

    public void indexProperty(@NotNull KotlinPropertyStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(sink, "sink");
    }

    public void indexParameter(@NotNull KotlinParameterStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(sink, "sink");
    }

    public void indexAnnotation(@NotNull KotlinAnnotationEntryStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(sink, "sink");
    }

    public void indexScript(@NotNull KotlinScriptStub stub2, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(sink, "sink");
    }

    @NotNull
    public KotlinFileStub createFileStub(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return new KotlinFileStubImpl(file2, file2.getPackageFqName().asString(), file2.isScript());
    }

    public void serializeFileStub(@NotNull KotlinFileStub stub2, @NotNull StubOutputStream dataStream) throws IOException {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        dataStream.writeName(stub2.getPackageFqName().asString());
        dataStream.writeBoolean(stub2.isScript());
    }

    @NotNull
    public KotlinFileStub deserializeFileStub(@NotNull StubInputStream dataStream) throws IOException {
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        StringRef packageFqNameAsString = dataStream.readName();
        boolean isScript = dataStream.readBoolean();
        StringRef stringRef = packageFqNameAsString;
        Intrinsics.checkNotNull(stringRef);
        String string2 = stringRef.getString();
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        return new KotlinFileStubImpl(null, string2, isScript);
    }

    @NotNull
    public static final StubIndexService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/StubIndexService$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/stubs/elements/StubIndexService;", "getInstance", "()Lorg/jetbrains/kotlin/psi/stubs/elements/StubIndexService;", "NO_INDEX", "Lorg/jetbrains/kotlin/psi/stubs/elements/StubIndexService;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StubIndexService getInstance() {
            StubIndexService stubIndexService = ApplicationManager.getApplication().getService(StubIndexService.class);
            if (stubIndexService == null) {
                stubIndexService = NO_INDEX;
            }
            return stubIndexService;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

