/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IStubFileElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinImportAliasStub;
import org.jetbrains.kotlin.psi.stubs.KotlinImportDirectiveStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtFileElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001)BE\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eB#\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000fJ\u0013\u0010\u0011\u001a\u00020\u0010*\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0010H\u0017\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\u0015J\u0015\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0017\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0005H\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000b2\u0006\u0010\u001b\u001a\u00020\u0005H\u0017\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001fR\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010 R\u0016\u0010\t\u001a\u0004\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001fR\u001c\u0010\n\u001a\u0004\u0018\u00010\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u001f\u001a\u0004\b!\u0010\u001aR\"\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\"\u001a\u0004\b#\u0010$R\u0013\u0010&\u001a\u0004\u0018\u00010\u00108G\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0014R\u0013\u0010(\u001a\u0004\u0018\u00010\u00108G\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "Lcom/intellij/psi/stubs/PsiFileStubImpl;", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinFileStub;", "ktFile", "", "packageName", "", "isScript", "facadeFqNameString", "partSimpleName", "", "facadePartSimpleNames", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/lang/String;Z)V", "Lorg/jetbrains/kotlin/name/FqName;", "relativeToPackage", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/name/FqName;", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "()Z", "Lcom/intellij/psi/tree/IStubFileElementType;", "getType", "()Lcom/intellij/psi/tree/IStubFileElementType;", "toString", "()Ljava/lang/String;", "alias", "Lorg/jetbrains/kotlin/psi/stubs/KotlinImportDirectiveStub;", "findImportsByAlias", "(Ljava/lang/String;)Ljava/util/List;", "Ljava/lang/String;", "Z", "getPartSimpleName", "Ljava/util/List;", "getFacadePartSimpleNames", "()Ljava/util/List;", "getPartFqName", "partFqName", "getFacadeFqName", "facadeFqName", "Companion"})
public final class KotlinFileStubImpl
extends PsiFileStubImpl<KtFile>
implements KotlinFileStub {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String packageName;
    private final boolean isScript;
    @Nullable
    private final String facadeFqNameString;
    @Nullable
    private final String partSimpleName;
    @Nullable
    private final List<String> facadePartSimpleNames;

    public KotlinFileStubImpl(@Nullable KtFile ktFile, @NotNull String packageName, boolean isScript, @Nullable String facadeFqNameString, @Nullable String partSimpleName, @Nullable List<String> facadePartSimpleNames) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        super((PsiFile)ktFile);
        this.packageName = packageName;
        this.isScript = isScript;
        this.facadeFqNameString = facadeFqNameString;
        this.partSimpleName = partSimpleName;
        this.facadePartSimpleNames = facadePartSimpleNames;
    }

    @Nullable
    public final String getPartSimpleName() {
        return this.partSimpleName;
    }

    @Nullable
    public final List<String> getFacadePartSimpleNames() {
        return this.facadePartSimpleNames;
    }

    public KotlinFileStubImpl(@Nullable KtFile ktFile, @NotNull String packageName, boolean isScript) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        this(ktFile, packageName, isScript, null, null, null);
    }

    private final FqName relativeToPackage(String $this$relativeToPackage) {
        FqName fqName2 = this.getPackageFqName();
        Name name = Name.identifier($this$relativeToPackage);
        Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
        return fqName2.child(name);
    }

    @Nullable
    public final FqName getPartFqName() {
        String string2 = this.partSimpleName;
        return string2 != null ? this.relativeToPackage(string2) : null;
    }

    @Nullable
    public final FqName getFacadeFqName() {
        FqName fqName2;
        String string2 = this.facadeFqNameString;
        if (string2 != null) {
            String p0 = string2;
            boolean bl = false;
            fqName2 = new FqName(p0);
        } else {
            fqName2 = null;
        }
        return fqName2;
    }

    @Override
    @NotNull
    public FqName getPackageFqName() {
        return new FqName(this.packageName);
    }

    @Override
    public boolean isScript() {
        return this.isScript;
    }

    @Override
    @NotNull
    public IStubFileElementType<KotlinFileStub> getType() {
        KtFileElementType ktFileElementType = KtFileElementType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue(ktFileElementType, "INSTANCE");
        return ktFileElementType;
    }

    @Override
    @NotNull
    public String toString() {
        return "PsiJetFileStubImpl[package=" + this.getPackageFqName().asString() + ']';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<KotlinImportDirectiveStub> findImportsByAlias(@NotNull String alias) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Object v1;
        block5: {
            Intrinsics.checkNotNullParameter(alias, "alias");
            List<StubElement> list = this.getChildrenStubs();
            Intrinsics.checkNotNullExpressionValue(list, "getChildrenStubs(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                StubElement it = (StubElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getStubType(), KtStubElementTypes.IMPORT_LIST)) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        StubElement stubElement = v1;
        if (stubElement == null) {
            return CollectionsKt.emptyList();
        }
        StubElement importList = stubElement;
        List<StubElement> list = importList.getChildrenStubs();
        Intrinsics.checkNotNullExpressionValue(list, "getChildrenStubs(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$firstOrNull = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KotlinImportDirectiveStub)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Object v5;
            block6: {
                KotlinImportDirectiveStub it = (KotlinImportDirectiveStub)element$iv$iv;
                boolean bl = false;
                List<StubElement> list2 = it.getChildrenStubs();
                Intrinsics.checkNotNullExpressionValue(list2, "getChildrenStubs(...)");
                Iterable $this$firstIsInstanceOrNull$iv = list2;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof KotlinImportAliasStub)) continue;
                    v5 = element$iv;
                    break block6;
                }
                v5 = null;
            }
            KotlinImportAliasStub kotlinImportAliasStub = v5;
            if (!Intrinsics.areEqual(kotlinImportAliasStub != null ? kotlinImportAliasStub.getName() : null, alias)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\f\u0010\rJ/\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "", "isScript", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "forFile", "(Lorg/jetbrains/kotlin/name/FqName;Z)Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "facadeFqName", "forFileFacadeStub", "(Lorg/jetbrains/kotlin/name/FqName;)Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "", "", "partNames", "forMultifileClassStub", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Ljava/util/List;)Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinFileStubImpl forFile(@NotNull FqName packageFqName, boolean isScript) {
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            String string2 = packageFqName.asString();
            return new KotlinFileStubImpl(null, string2, isScript, null, null, null);
        }

        @NotNull
        public final KotlinFileStubImpl forFileFacadeStub(@NotNull FqName facadeFqName) {
            Intrinsics.checkNotNullParameter(facadeFqName, "facadeFqName");
            String string2 = facadeFqName.parent().asString();
            String string3 = facadeFqName.asString();
            String string4 = facadeFqName.shortName().asString();
            return new KotlinFileStubImpl(null, string2, false, string3, string4, null);
        }

        @NotNull
        public final KotlinFileStubImpl forMultifileClassStub(@NotNull FqName packageFqName, @NotNull FqName facadeFqName, @Nullable List<String> partNames) {
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            Intrinsics.checkNotNullParameter(facadeFqName, "facadeFqName");
            String string2 = packageFqName.asString();
            String string3 = facadeFqName.asString();
            return new KotlinFileStubImpl(null, string2, false, string3, null, partNames);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

