/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceFilter;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J7\u0010\u000e\u001a\u00020\r\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\f\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\u000e\u0010\u000fJ?\u0010\u0012\u001a\u00020\u0011\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/AbstractFilteringTrace;", "Lorg/jetbrains/kotlin/resolve/DelegatingBindingTrace;", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "parentTrace", "", "name", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Ljava/lang/String;)V", "K", "V", "Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;", "slice", "key", "", "shouldBeHiddenFromParent", "(Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;Ljava/lang/Object;)Z", "value", "", "record", "(Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;Ljava/lang/Object;Ljava/lang/Object;)V", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "diagnostic", "report", "(Lorg/jetbrains/kotlin/diagnostics/Diagnostic;)V", "wantsDiagnostics", "()Z", "Lorg/jetbrains/kotlin/resolve/BindingTrace;"})
public abstract class AbstractFilteringTrace
extends DelegatingBindingTrace {
    @NotNull
    private final BindingTrace parentTrace;

    public AbstractFilteringTrace(@NotNull BindingTrace parentTrace, @NotNull String name) {
        Intrinsics.checkNotNullParameter(parentTrace, "parentTrace");
        Intrinsics.checkNotNullParameter(name, "name");
        BindingContext bindingContext = parentTrace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        super(bindingContext, name, true, BindingTraceFilter.Companion.getACCEPT_ALL(), false, null, 32, null);
        this.parentTrace = parentTrace;
    }

    protected abstract <K, V> boolean shouldBeHiddenFromParent(@NotNull WritableSlice<K, V> var1, K var2);

    @Override
    public <K, V> void record(@NotNull WritableSlice<K, V> slice, K key, V value2) {
        Intrinsics.checkNotNullParameter(slice, "slice");
        if (this.shouldBeHiddenFromParent(slice, key)) {
            super.record(slice, key, value2);
        } else {
            this.parentTrace.record(slice, key, value2);
        }
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        DiagnosticSink.DiagnosticsCallback diagnosticsCallback = this.getDiagnosticsCallback();
        if (diagnosticsCallback != null) {
            diagnosticsCallback.callback(diagnostic);
        }
        this.parentTrace.report(diagnostic);
    }

    @Override
    public boolean wantsDiagnostics() {
        return this.parentTrace.wantsDiagnostics();
    }
}

