/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.resolve.ArrayFqNames;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\u00010B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J3\u0010\u0016\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0010J%\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b%\u0010&R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010'\u001a\u0004\b(\u0010)R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010*\u001a\u0004\b+\u0010,R\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010-\u001a\u0004\b.\u0010/"}, d2={"Lorg/jetbrains/kotlin/resolve/CollectionLiteralResolver;", "", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "module", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "callResolver", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/calls/CallResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "collectionLiteralExpression", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "context", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "resolveCollectionLiteral", "(Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lcom/intellij/psi/PsiElement;", "", "diagnosticFactory", "", "reportUnsupportedLiteral", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;)V", "expression", "resolveCollectionLiteralSpecialMethod", "Lorg/jetbrains/kotlin/name/Name;", "callName", "", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "getFunctionDescriptorForCollectionLiteral", "(Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;Lorg/jetbrains/kotlin/name/Name;)Ljava/util/Collection;", "Lorg/jetbrains/kotlin/resolve/CollectionLiteralResolver$ContainerKind;", "computeKindOfContainer", "(Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;)Lorg/jetbrains/kotlin/resolve/CollectionLiteralResolver$ContainerKind;", "Lorg/jetbrains/kotlin/types/KotlinType;", "expectedType", "getArrayFunctionCallName", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getModule", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "getCallResolver", "()Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "ContainerKind"})
public final class CollectionLiteralResolver {
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public CollectionLiteralResolver(@NotNull ModuleDescriptor module2, @NotNull CallResolver callResolver, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(callResolver, "callResolver");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.module = module2;
        this.callResolver = callResolver;
        this.languageVersionSettings = languageVersionSettings;
    }

    @NotNull
    public final ModuleDescriptor getModule() {
        return this.module;
    }

    @NotNull
    public final CallResolver getCallResolver() {
        return this.callResolver;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final KotlinTypeInfo resolveCollectionLiteral(@NotNull KtCollectionLiteralExpression collectionLiteralExpression, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkNotNullParameter(collectionLiteralExpression, "collectionLiteralExpression");
        Intrinsics.checkNotNullParameter(context, "context");
        switch (WhenMappings.$EnumSwitchMapping$0[this.computeKindOfContainer(collectionLiteralExpression).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                DiagnosticFactory1<PsiElement, String> diagnosticFactory1;
                boolean bl = context.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitArrayLiteralsInCompanionOfAnnotation);
                if (bl) {
                    diagnosticFactory1 = Errors.UNSUPPORTED;
                } else if (!bl) {
                    diagnosticFactory1 = Errors.UNSUPPORTED_WARNING;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                DiagnosticFactory1<PsiElement, String> factory2 = diagnosticFactory1;
                Intrinsics.checkNotNull(factory2);
                this.reportUnsupportedLiteral(context, factory2, collectionLiteralExpression);
                break;
            }
            case 3: {
                DiagnosticFactory1<PsiElement, String> diagnosticFactory1 = Errors.UNSUPPORTED;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory1, "UNSUPPORTED");
                this.reportUnsupportedLiteral(context, diagnosticFactory1, collectionLiteralExpression);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return this.resolveCollectionLiteralSpecialMethod(collectionLiteralExpression, context);
    }

    private final void reportUnsupportedLiteral(ExpressionTypingContext context, DiagnosticFactory1<PsiElement, String> diagnosticFactory, KtCollectionLiteralExpression collectionLiteralExpression) {
        context.trace.report(diagnosticFactory.on(collectionLiteralExpression, "Collection literals outside of annotations"));
    }

    private final KotlinTypeInfo resolveCollectionLiteralSpecialMethod(KtCollectionLiteralExpression expression, ExpressionTypingContext context) {
        Call call2 = CallMaker.makeCallForCollectionLiteral(expression);
        KotlinType kotlinType = context.expectedType;
        Intrinsics.checkNotNullExpressionValue(kotlinType, "expectedType");
        Name callName = this.getArrayFunctionCallName(kotlinType);
        Collection<FunctionDescriptor> functionDescriptors = this.getFunctionDescriptorForCollectionLiteral(expression, callName);
        if (functionDescriptors.isEmpty()) {
            context.trace.report(Errors.MISSING_STDLIB.on(expression, "Collection literal call '" + callName + "()' is unresolved"));
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.callResolver.resolveCollectionLiteralCallWithGivenDescriptor(context, expression, call2, functionDescriptors);
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, "resolveCollectionLiteral\u2026lWithGivenDescriptor(...)");
        OverloadResolutionResults<FunctionDescriptor> resolutionResults = overloadResolutionResults;
        if (!resolutionResults.isSingleResult()) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        context.trace.record(BindingContext.COLLECTION_LITERAL_CALL, expression, resolutionResults.getResultingCall());
        return TypeInfoFactoryKt.createTypeInfo(resolutionResults.getResultingDescriptor().getReturnType(), context);
    }

    private final Collection<SimpleFunctionDescriptor> getFunctionDescriptorForCollectionLiteral(KtCollectionLiteralExpression expression, Name callName) {
        MemberScope memberScopeOfKotlinPackage = this.module.getPackage(StandardNames.BUILT_INS_PACKAGE_FQ_NAME).getMemberScope();
        return memberScopeOfKotlinPackage.getContributedFunctions(callName, new KotlinLookupLocation(expression));
    }

    private final ContainerKind computeKindOfContainer(KtCollectionLiteralExpression expression) {
        KtClass containingAnnotation;
        Class[] classArray = new Class[]{KtAnnotationEntry.class, KtClass.class, KtObjectDeclaration.class};
        KtElementImplStub parent2 = (KtElementImplStub)PsiTreeUtil.getParentOfType((PsiElement)expression, classArray);
        if (parent2 instanceof KtObjectDeclaration && (containingAnnotation = PsiTreeUtil.getParentOfType((PsiElement)parent2, KtClass.class)) != null && containingAnnotation.isAnnotation()) {
            return ContainerKind.CompanionOfAnnotation;
        }
        return parent2 instanceof KtAnnotationEntry || parent2 instanceof KtClass && ((KtClass)parent2).isAnnotation() ? ContainerKind.AnnotationOrAnnotationClass : ContainerKind.Other;
    }

    private final Name getArrayFunctionCallName(KotlinType expectedType) {
        if (TypeUtils.noExpectedType(expectedType) || !KotlinBuiltIns.isPrimitiveArray(expectedType) && !KotlinBuiltIns.isUnsignedArrayType(expectedType)) {
            return ArrayFqNames.INSTANCE.getARRAY_OF_FUNCTION();
        }
        ClassifierDescriptor classifierDescriptor = expectedType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return ArrayFqNames.INSTANCE.getARRAY_OF_FUNCTION();
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        Name name = ArrayFqNames.INSTANCE.getPRIMITIVE_TYPE_TO_ARRAY().get((Object)KotlinBuiltIns.getPrimitiveArrayType(descriptor2));
        if (name == null && (name = (Name)((Map)UnsignedTypes.INSTANCE.getUnsignedArrayTypeToArrayCall()).get((Object)UnsignedTypes.toUnsignedArrayType(descriptor2))) == null) {
            name = ArrayFqNames.INSTANCE.getARRAY_OF_FUNCTION();
        }
        return name;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/CollectionLiteralResolver$ContainerKind;", "", "<init>", "(Ljava/lang/String;I)V", "AnnotationOrAnnotationClass", "CompanionOfAnnotation", "Other"})
    private static final class ContainerKind
    extends Enum<ContainerKind> {
        public static final /* enum */ ContainerKind AnnotationOrAnnotationClass = new ContainerKind();
        public static final /* enum */ ContainerKind CompanionOfAnnotation = new ContainerKind();
        public static final /* enum */ ContainerKind Other = new ContainerKind();
        private static final /* synthetic */ ContainerKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ContainerKind[] values() {
            return (ContainerKind[])$VALUES.clone();
        }

        public static ContainerKind valueOf(String value2) {
            return Enum.valueOf(ContainerKind.class, value2);
        }

        @NotNull
        public static EnumEntries<ContainerKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = containerKindArray = new ContainerKind[]{ContainerKind.AnnotationOrAnnotationClass, ContainerKind.CompanionOfAnnotation, ContainerKind.Other};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ContainerKind.values().length];
            try {
                nArray[ContainerKind.AnnotationOrAnnotationClass.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContainerKind.CompanionOfAnnotation.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContainerKind.Other.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

