/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.util.MetadataHelpersKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0003\u001a\u00020\u00028\u0005X\u0085\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u00020\t8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0014\u0010\u0012R\u0017\u0010\u0015\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0016\u0010\u0012R\u0017\u0010\u0017\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0010\u001a\u0004\b\u0018\u0010\u0012R\u0017\u0010\u0019\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0010\u001a\u0004\b\u001a\u0010\u0012R\u0017\u0010\u001b\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0010\u001a\u0004\b\u001b\u0010\u0012R\u0017\u0010\u001c\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0010\u001a\u0004\b\u001d\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/CompilerDeserializationConfiguration;", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "", "skipMetadataVersionCheck", "Z", "getSkipMetadataVersionCheck", "()Z", "skipPrereleaseCheck", "getSkipPrereleaseCheck", "reportErrorsOnPreReleaseDependencies", "getReportErrorsOnPreReleaseDependencies", "allowUnstableDependencies", "getAllowUnstableDependencies", "typeAliasesAllowed", "getTypeAliasesAllowed", "isJvmPackageNameSupported", "readDeserializedContracts", "getReadDeserializedContracts"})
public class CompilerDeserializationConfiguration
implements DeserializationConfiguration {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final MetadataVersion metadataVersion;
    private final boolean skipMetadataVersionCheck;
    private final boolean skipPrereleaseCheck;
    private final boolean reportErrorsOnPreReleaseDependencies;
    private final boolean allowUnstableDependencies;
    private final boolean typeAliasesAllowed;
    private final boolean isJvmPackageNameSupported;
    private final boolean readDeserializedContracts;

    public CompilerDeserializationConfiguration(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
        this.metadataVersion = MetadataHelpersKt.toMetadataVersion(this.languageVersionSettings.getLanguageVersion());
        this.skipMetadataVersionCheck = this.languageVersionSettings.getFlag(AnalysisFlags.getSkipMetadataVersionCheck());
        this.skipPrereleaseCheck = this.languageVersionSettings.getFlag(AnalysisFlags.getSkipPrereleaseCheck());
        this.reportErrorsOnPreReleaseDependencies = !this.skipPrereleaseCheck && !this.languageVersionSettings.isPreRelease() && !KotlinCompilerVersion.isPreRelease();
        this.allowUnstableDependencies = this.languageVersionSettings.getFlag(AnalysisFlags.getAllowUnstableDependencies());
        this.typeAliasesAllowed = this.languageVersionSettings.supportsFeature(LanguageFeature.TypeAliases);
        this.isJvmPackageNameSupported = this.languageVersionSettings.supportsFeature(LanguageFeature.JvmPackageName);
        this.readDeserializedContracts = this.languageVersionSettings.supportsFeature(LanguageFeature.ReadDeserializedContracts);
    }

    @NotNull
    protected final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @Override
    @NotNull
    public MetadataVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @Override
    public final boolean getSkipMetadataVersionCheck() {
        return this.skipMetadataVersionCheck;
    }

    @Override
    public final boolean getSkipPrereleaseCheck() {
        return this.skipPrereleaseCheck;
    }

    @Override
    public final boolean getReportErrorsOnPreReleaseDependencies() {
        return this.reportErrorsOnPreReleaseDependencies;
    }

    @Override
    public final boolean getAllowUnstableDependencies() {
        return this.allowUnstableDependencies;
    }

    @Override
    public final boolean getTypeAliasesAllowed() {
        return this.typeAliasesAllowed;
    }

    @Override
    public final boolean isJvmPackageNameSupported() {
        return this.isJvmPackageNameSupported;
    }

    @Override
    public final boolean getReadDeserializedContracts() {
        return this.readDeserializedContracts;
    }
}

