/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a%\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u001a+\u0010\f\u001a\u00020\u00062\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\f\u0010\r"}, d2={"Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lorg/jetbrains/kotlin/psi/KtContextReceiverList;", "contextReceiverList", "", "checkContextReceiversAreEnabled", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/psi/KtContextReceiverList;)V", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "contextReceiverTypes", "checkSubtypingBetweenContextReceivers", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/psi/KtContextReceiverList;Ljava/util/List;)V"})
public final class ContextReceiversUtilKt {
    public static final void checkContextReceiversAreEnabled(@NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull KtContextReceiverList contextReceiverList) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(contextReceiverList, "contextReceiverList");
        if (!languageVersionSettings.supportsFeature(LanguageFeature.ContextReceivers)) {
            trace.report(Errors.UNSUPPORTED_FEATURE.on(contextReceiverList, TuplesKt.to(LanguageFeature.ContextReceivers, languageVersionSettings)));
        }
    }

    public static final void checkSubtypingBetweenContextReceivers(@NotNull BindingTrace trace, @NotNull KtContextReceiverList contextReceiverList, @NotNull List<? extends KotlinType> contextReceiverTypes) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(contextReceiverList, "contextReceiverList");
        Intrinsics.checkNotNullParameter(contextReceiverTypes, "contextReceiverTypes");
        int n = CollectionsKt.getLastIndex(contextReceiverTypes);
        for (int i = 0; i < n; ++i) {
            KotlinType contextReceiverType = ContextReceiversUtilKt.checkSubtypingBetweenContextReceivers$prepared(contextReceiverTypes.get(i));
            int n2 = contextReceiverTypes.size();
            for (int j = i + 1; j < n2; ++j) {
                KotlinType anotherContextReceiverType = ContextReceiversUtilKt.checkSubtypingBetweenContextReceivers$prepared(contextReceiverTypes.get(j));
                if (!NewKotlinTypeChecker.Companion.getDefault().isSubtypeOf(contextReceiverType, anotherContextReceiverType) && !NewKotlinTypeChecker.Companion.getDefault().isSubtypeOf(anotherContextReceiverType, contextReceiverType)) continue;
                trace.report(Errors.SUBTYPING_BETWEEN_CONTEXT_RECEIVERS.on((KtElement)((PsiElement)contextReceiverList)));
                return;
            }
        }
    }

    private static final KotlinType checkSubtypingBetweenContextReceivers$prepared(KotlinType $this$checkSubtypingBetweenContextReceivers_u24prepared) {
        return TypeUtilsKt.isTypeParameter($this$checkSubtypingBetweenContextReceivers_u24prepared) ? (KotlinType)CollectionsKt.first((Iterable)TypeUtilsKt.supertypes($this$checkSubtypingBetweenContextReceivers_u24prepared)) : (TypeUtilsKt.containsTypeParameter($this$checkSubtypingBetweenContextReceivers_u24prepared) ? TypeUtilsKt.replaceArgumentsWithStarProjections($this$checkSubtypingBetweenContextReceivers_u24prepared) : $this$checkSubtypingBetweenContextReceivers_u24prepared);
    }
}

