/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\t\u00a2\u0006\u0004\b\u000f\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/DataClassResolver;", "", "<init>", "()V", "", "index", "Lorg/jetbrains/kotlin/name/Name;", "createComponentName", "(I)Lorg/jetbrains/kotlin/name/Name;", "", "componentName", "getComponentIndex", "(Ljava/lang/String;)I", "name", "", "isComponentLike", "(Lorg/jetbrains/kotlin/name/Name;)Z", "(Ljava/lang/String;)Z", "isCopy"})
public final class DataClassResolver {
    @NotNull
    public static final DataClassResolver INSTANCE = new DataClassResolver();

    private DataClassResolver() {
    }

    @NotNull
    public final Name createComponentName(int index2) {
        Name name = Name.identifier(StandardNames.DATA_CLASS_COMPONENT_PREFIX + index2);
        Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
        return name;
    }

    public final int getComponentIndex(@NotNull String componentName) {
        Intrinsics.checkNotNullParameter(componentName, "componentName");
        String string2 = componentName.substring(StandardNames.DATA_CLASS_COMPONENT_PREFIX.length());
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        return Integer.parseInt(string2);
    }

    public final boolean isComponentLike(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string2 = name.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        return this.isComponentLike(string2);
    }

    public final boolean isComponentLike(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (!StringsKt.startsWith$default(name, StandardNames.DATA_CLASS_COMPONENT_PREFIX, false, 2, null)) {
            return false;
        }
        try {
            this.getComponentIndex(name);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public final boolean isCopy(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return Intrinsics.areEqual(name, StandardNames.DATA_CLASS_COPY);
    }
}

