/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000f\u0010\u0010J#\u0010\u0015\u001a\u00020\f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J)\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00172\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0011\u00a2\u0006\u0004\b\u001c\u0010\u001dJ-\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130!2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b\"\u0010#R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010$R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010%"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationResolver;", "", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "<init>", "(Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "c", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;", "scopeProvider", "", "resolveAnnotationsOnFiles", "(Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;)V", "checkRedeclarations", "(Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;)V", "Lcom/google/common/collect/Multimap;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptorMap", "reportRedeclarationsWithClassifiers", "(Lcom/google/common/collect/Multimap;)V", "Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;", "topLevelDescriptorProvider", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/psi/KtElement;", "topLevelFqNames", "checkRedeclarationsInPackages", "(Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;Lcom/google/common/collect/Multimap;)V", "fqName", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "location", "", "getTopLevelDescriptorsByFqName", "(Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)Ljava/util/Set;", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "Lorg/jetbrains/kotlin/resolve/BindingTrace;"})
public final class DeclarationResolver {
    @NotNull
    private final AnnotationResolver annotationResolver;
    @NotNull
    private final BindingTrace trace;

    public DeclarationResolver(@NotNull AnnotationResolver annotationResolver, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(annotationResolver, "annotationResolver");
        Intrinsics.checkNotNullParameter(trace, "trace");
        this.annotationResolver = annotationResolver;
        this.trace = trace;
    }

    public final void resolveAnnotationsOnFiles(@NotNull TopDownAnalysisContext c, @NotNull FileScopeProvider scopeProvider2) {
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(scopeProvider2, "scopeProvider");
        Collection<KtFile> collection = c.getFiles();
        Intrinsics.checkNotNullExpressionValue(collection, "getFiles(...)");
        Map<KtFile, LexicalScope> filesToScope = CollectionsKt.keysToMap((Iterable)collection, arg_0 -> DeclarationResolver.resolveAnnotationsOnFiles$lambda$0(scopeProvider2, arg_0));
        for (Map.Entry<KtFile, LexicalScope> entry : filesToScope.entrySet()) {
            KtFile file2 = entry.getKey();
            LexicalScope fileScope = entry.getValue();
            this.annotationResolver.resolveAnnotationsWithArguments(fileScope, file2.getAnnotationEntries(), this.trace);
            this.annotationResolver.resolveAnnotationsWithArguments(fileScope, file2.getDanglingAnnotations(), this.trace);
        }
    }

    public final void checkRedeclarations(@NotNull TopDownAnalysisContext c) {
        Intrinsics.checkNotNullParameter(c, "c");
        for (ClassDescriptorWithResolutionScopes classDescriptor : c.getDeclaredClasses().values()) {
            HashMultimap descriptorMap = HashMultimap.create();
            for (DeclarationDescriptor desc : ResolutionScope.DefaultImpls.getContributedDescriptors$default(classDescriptor.getUnsubstitutedMemberScope(), null, null, 3, null)) {
                if (!(desc instanceof ClassifierDescriptor) && !(desc instanceof PropertyDescriptor)) continue;
                descriptorMap.put(((DeclarationDescriptorNonRoot)desc).getName(), desc);
            }
            Intrinsics.checkNotNull(descriptorMap);
            this.reportRedeclarationsWithClassifiers(descriptorMap);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportRedeclarationsWithClassifiers(Multimap<Name, DeclarationDescriptor> descriptorMap) {
        for (Name name : descriptorMap.keySet()) {
            boolean bl;
            Collection<DeclarationDescriptor> descriptors;
            block5: {
                descriptors = descriptorMap.get(name);
                if (descriptors.size() <= 1) continue;
                Intrinsics.checkNotNull(descriptors);
                Iterable $this$any$iv = descriptors;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof ClassifierDescriptor)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            for (DeclarationDescriptor descriptor2 : descriptors) {
                void it;
                void trace$iv;
                PsiElement psiElement$iv;
                BindingTrace bindingTrace = this.trace;
                Intrinsics.checkNotNull(descriptor2);
                DeclarationDescriptor descriptor$iv = descriptor2;
                boolean $i$f$reportOnDeclaration = false;
                if (DescriptorToSourceUtils.descriptorToDeclaration(descriptor$iv) == null) continue;
                boolean bl3 = false;
                PsiElement psiElement = psiElement$iv;
                void var14_17 = trace$iv;
                boolean bl4 = false;
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.REDECLARATION.on((PsiElement)it, descriptors);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
                var14_17.report(parametrizedDiagnostic);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void checkRedeclarationsInPackages(@NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @NotNull Multimap<FqName, KtElement> topLevelFqNames) {
        Intrinsics.checkNotNullParameter(topLevelDescriptorProvider, "topLevelDescriptorProvider");
        Intrinsics.checkNotNullParameter(topLevelFqNames, "topLevelFqNames");
        Map<FqName, Collection<KtElement>> map2 = topLevelFqNames.asMap();
        Intrinsics.checkNotNullExpressionValue(map2, "asMap(...)");
        for (Map.Entry<FqName, Collection<KtElement>> entry : map2.entrySet()) {
            void $this$partition$iv;
            FqName fqName2 = entry.getKey();
            Collection<KtElement> declarationsOrPackageDirectives = entry.getValue();
            if (fqName2.isRoot()) continue;
            Intrinsics.checkNotNull(fqName2);
            Iterable iterable = this.getTopLevelDescriptorsByFqName(topLevelDescriptorProvider, fqName2, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            List[] second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                boolean bl = false;
                boolean bl2 = it instanceof MemberDescriptor && ((MemberDescriptor)it).isExpect() ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List expected = pair.component1();
            List actual = pair.component2();
            second$iv = new List[]{expected, actual};
            for (List descriptors : kotlin.collections.CollectionsKt.listOf(second$iv)) {
                if (descriptors.size() <= 1) continue;
                for (KtElement directive : declarationsOrPackageDirectives) {
                    PsiElement psiElement = directive instanceof KtPackageDirective ? (KtPackageDirective)directive : null;
                    if (psiElement == null || (psiElement = psiElement.getNameIdentifier()) == null) {
                        psiElement = directive;
                    }
                    PsiElement reportAt = psiElement;
                    this.trace.report(Errors.PACKAGE_OR_CLASSIFIER_REDECLARATION.on(reportAt, fqName2.shortName().asString()));
                }
            }
        }
    }

    private final Set<DeclarationDescriptor> getTopLevelDescriptorsByFqName(TopLevelDescriptorProvider topLevelDescriptorProvider, FqName fqName2, LookupLocation location) {
        HashSet<ClassifierDescriptor> descriptors = new HashSet<ClassifierDescriptor>();
        CollectionsKt.addIfNotNull((Collection)descriptors, topLevelDescriptorProvider.getPackageFragment(fqName2));
        descriptors.addAll(topLevelDescriptorProvider.getTopLevelClassifierDescriptors(fqName2, location));
        return descriptors;
    }

    private static final LexicalScope resolveAnnotationsOnFiles$lambda$0(FileScopeProvider $scopeProvider, KtFile it) {
        Intrinsics.checkNotNull(it);
        return $scopeProvider.getFileResolutionScope(it);
    }
}

