/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegateInferenceSession;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.InferenceSessionForExistingCandidates;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallChecker;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.components.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.EmptySubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.components.KotlinConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutorByConstructorMap;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionAtomsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.tower.KotlinResolutionCallbacksImpl;
import org.jetbrains.kotlin.resolve.calls.tower.PSICallResolver;
import org.jetbrains.kotlin.resolve.calls.tower.ResolutionResultCallInfo;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.StubTypeForProvideDelegateReceiver;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.NewTypeVariableConstructor;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u001c\u0018\u00002\u00020\u0001:\u0002\u008d\u0001BO\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015JE\u0010%\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b%\u0010&J/\u0010)\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020'2\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b)\u0010*JI\u0010-\u001a\u0004\u0018\u00010'2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020'2\u0006\u0010#\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u00162\u0006\u0010!\u001a\u00020 H\u0007\u00a2\u0006\u0004\b-\u0010.JG\u00100\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020'2\u0006\u0010#\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u00162\u0006\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\b0\u00101J?\u00102\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020'2\u0006\u0010#\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b2\u00103J\u0013\u00105\u001a\u00020\u001c*\u000204H\u0002\u00a2\u0006\u0004\b5\u00106JG\u0010:\u001a\u00020$2\u0006\u00107\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020'2\u0006\u0010#\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u00162\u0006\u00109\u001a\u000208H\u0002\u00a2\u0006\u0004\b:\u0010;J5\u0010A\u001a\u00020$2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020=0<2\u0006\u00107\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020?2\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\bA\u0010BJE\u0010C\u001a\u00020$2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020=0<2\u0006\u0010@\u001a\u00020?2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020'2\u0006\u0010#\u001a\u00020\"2\u0006\u00109\u001a\u000208H\u0002\u00a2\u0006\u0004\bC\u0010DJ7\u0010G\u001a\u00020$2\u0006\u0010F\u001a\u00020E2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020'2\u0006\u0010#\u001a\u00020\"2\u0006\u00109\u001a\u000208H\u0002\u00a2\u0006\u0004\bG\u0010HJ5\u0010J\u001a\u0002082\u0006\u0010#\u001a\u00020\"2\u0006\u0010F\u001a\u00020E2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020=0<2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\bJ\u0010KJG\u0010M\u001a\u00020$2\u0006\u00107\u001a\u00020\u001a2\u0006\u0010L\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020'2\u0006\u0010#\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u00162\u0006\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\bM\u00101Jm\u0010T\u001a\b\u0012\u0004\u0012\u00020=0<2\u0006\u00107\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020'2\u0006\u0010#\u001a\u00020\"2\u0006\u0010N\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u00162\u0006\u00109\u001a\u0002082\u0006\u0010O\u001a\u0002082\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010P2\n\b\u0002\u0010S\u001a\u0004\u0018\u00010RH\u0002\u00a2\u0006\u0004\bT\u0010UJ'\u0010V\u001a\u00020P2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020'2\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\bV\u0010WJ7\u0010Y\u001a\u00020R2\u0006\u00107\u001a\u00020\u001a2\u0006\u0010N\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\"2\u0006\u0010X\u001a\u00020 H\u0002\u00a2\u0006\u0004\bY\u0010ZJ/\u0010[\u001a\u00020R2\u0006\u0010N\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\"2\u0006\u0010X\u001a\u00020 H\u0002\u00a2\u0006\u0004\b[\u0010\\JO\u0010^\u001a\b\u0012\u0004\u0012\u00020=0<2\u0006\u00107\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010]\u001a\u00020'2\u0006\u0010#\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u00162\b\u0010!\u001a\u0004\u0018\u00010 H\u0002\u00a2\u0006\u0004\b^\u0010_J5\u0010^\u001a\b\u0012\u0004\u0012\u00020=0<2\u0006\u00107\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010]\u001a\u00020'2\u0006\u0010`\u001a\u00020RH\u0002\u00a2\u0006\u0004\b^\u0010aJ\u001f\u0010e\u001a\u00020d2\u0006\u0010b\u001a\u00020E2\u0006\u0010`\u001a\u00020cH\u0002\u00a2\u0006\u0004\be\u0010fJG\u0010g\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010N\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u00162\u0006\u0010!\u001a\u00020 H\u0007\u00a2\u0006\u0004\bg\u0010hJ\u001f\u0010k\u001a\u00020$2\u0006\u0010#\u001a\u00020\"2\u0006\u0010j\u001a\u00020iH\u0002\u00a2\u0006\u0004\bk\u0010lJA\u0010m\u001a\u0004\u0018\u00010'2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010N\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u00162\u0006\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\bm\u0010nJ1\u0010s\u001a\u0004\u0018\u00010q2\b\u0010o\u001a\u0004\u0018\u00010'2\u0014\u0010r\u001a\u0010\u0012\u0004\u0012\u00020q\u0012\u0004\u0012\u00020q\u0018\u00010pH\u0002\u00a2\u0006\u0004\bs\u0010tJ%\u0010u\u001a\u0010\u0012\u0004\u0012\u00020q\u0012\u0004\u0012\u00020q\u0018\u00010p2\u0006\u0010o\u001a\u00020'H\u0002\u00a2\u0006\u0004\bu\u0010vJQ\u0010y\u001a\u00020q2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010N\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020i2\u0006\u0010/\u001a\u00020'2\b\u0010w\u001a\u0004\u0018\u00010'2\u0006\u0010x\u001a\u00020\u00162\u0006\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\by\u0010zJ'\u0010{\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\"2\u0006\u0010/\u001a\u00020'H\u0002\u00a2\u0006\u0004\b{\u0010|J\u0013\u0010}\u001a\u000208*\u00020'H\u0002\u00a2\u0006\u0004\b}\u0010~J \u0010\u0080\u0001\u001a\u0002082\f\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020=0<H\u0002\u00a2\u0006\u0006\b\u0080\u0001\u0010\u0081\u0001R\u0015\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u0003\u0010\u0082\u0001R\u0015\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u0005\u0010\u0083\u0001R\u0015\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u0007\u0010\u0084\u0001R\u0015\u0010\t\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\t\u0010\u0085\u0001R\u0015\u0010\u000b\u001a\u00020\n8\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u000b\u0010\u0086\u0001R\u0015\u0010\r\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\r\u0010\u0087\u0001R\u0015\u0010\u000f\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u000f\u0010\u0088\u0001R\u0015\u0010\u0011\u001a\u00020\u00108\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u0011\u0010\u0089\u0001R\u0015\u0010\u0013\u001a\u00020\u00128\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u0013\u0010\u008a\u0001R\u0017\u0010\u008b\u0001\u001a\u0002088BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u008b\u0001\u0010\u008c\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;", "", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "builtIns", "Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;", "fakeCallResolver", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "expressionTypingServices", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/tower/PSICallResolver;", "psiCallResolver", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "postponedArgumentsAnalyzer", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;", "kotlinConstraintSystemCompleter", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "callComponents", "<init>", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;Lorg/jetbrains/kotlin/resolve/calls/tower/PSICallResolver;Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;)V", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "outerDataFlowInfo", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "variableDescriptor", "Lorg/jetbrains/kotlin/psi/KtExpression;", "delegateExpression", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "propertyHeaderScope", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "inferenceSession", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "", "resolvePropertyDelegate", "(Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/types/KotlinType;", "byExpressionType", "getResolvedDelegateType", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingTrace;)Lorg/jetbrains/kotlin/types/KotlinType;", "initializerScope", "dataFlowInfo", "getGetValueMethodReturnType", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;)Lorg/jetbrains/kotlin/types/KotlinType;", "delegateType", "resolveGetValueMethod", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;)V", "resolveSetValueMethod", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;)V", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "createExpressionForProperty", "(Lorg/jetbrains/kotlin/psi/KtPsiFactory;)Lorg/jetbrains/kotlin/psi/KtExpression;", "propertyDescriptor", "", "isGet", "resolveGetSetValueMethod", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Z)V", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "result", "Lorg/jetbrains/kotlin/descriptors/VariableAccessorDescriptor;", "accessor", "recordDelegateOperatorResults", "(Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/descriptors/VariableAccessorDescriptor;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "reportGetSetValueResolutionError", "(Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;Lorg/jetbrains/kotlin/descriptors/VariableAccessorDescriptor;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingTrace;Z)V", "Lorg/jetbrains/kotlin/psi/Call;", "delegateOperatorCall", "reportDelegateFunctionMissing", "(Lorg/jetbrains/kotlin/psi/Call;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingTrace;Z)V", "delegateOperatorResults", "reportDelegateErrorIfCandidateExists", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/psi/Call;Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;Lorg/jetbrains/kotlin/psi/KtExpression;)Z", "byExpression", "resolveProvideDelegateMethod", "scopeForDelegate", "isComplete", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "knownReceiver", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "knownContext", "getGetSetValueMethod", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;ZZLorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "createReceiverForGetSetValueMethods", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingTrace;)Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "inferenceExtension", "createContextForGetSetValueMethods", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;)Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "createContextForProvideDelegateMethod", "(Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;)Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "delegateExpressionType", "getProvideDelegateMethod", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;)Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "context", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "call", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "", "renderCall", "(Lorg/jetbrains/kotlin/psi/Call;Lorg/jetbrains/kotlin/resolve/BindingContext;)Ljava/lang/String;", "resolveDelegateExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;)Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/resolve/TemporaryBindingTrace;", "traceToResolveDelegatedProperty", "completeNotComputedDelegateType", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/TemporaryBindingTrace;)V", "resolveWithNewInference", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;)Lorg/jetbrains/kotlin/types/KotlinType;", "type", "", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "substitutionMap", "inverseSubstitution", "(Lorg/jetbrains/kotlin/types/KotlinType;Ljava/util/Map;)Lorg/jetbrains/kotlin/types/UnwrappedType;", "buildSubstitutionMapOfNonFixedVariables", "(Lorg/jetbrains/kotlin/types/KotlinType;)Ljava/util/Map;", "delegateTypeForProperType", "delegateDataFlow", "inferDelegateTypeFromGetSetValueMethods", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/TemporaryBindingTrace;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;)Lorg/jetbrains/kotlin/types/UnwrappedType;", "extractResolvedDelegateType", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/types/KotlinType;", "isProperType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "results", "conventionMethodFound", "(Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;)Z", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "Lorg/jetbrains/kotlin/resolve/calls/tower/PSICallResolver;", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "isOperatorProvideDelegateSupported", "()Z", "ConstraintSystemCompleterImpl"})
public final class DelegatedPropertyResolver {
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final FakeCallResolver fakeCallResolver;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    private final PSICallResolver psiCallResolver;
    @NotNull
    private final PostponedArgumentsAnalyzer postponedArgumentsAnalyzer;
    @NotNull
    private final KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter;
    @NotNull
    private final KotlinCallComponents callComponents;

    public DelegatedPropertyResolver(@NotNull KotlinBuiltIns builtIns, @NotNull FakeCallResolver fakeCallResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull PSICallResolver psiCallResolver, @NotNull PostponedArgumentsAnalyzer postponedArgumentsAnalyzer, @NotNull KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter, @NotNull KotlinCallComponents callComponents) {
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(fakeCallResolver, "fakeCallResolver");
        Intrinsics.checkNotNullParameter(expressionTypingServices, "expressionTypingServices");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(dataFlowValueFactory, "dataFlowValueFactory");
        Intrinsics.checkNotNullParameter(psiCallResolver, "psiCallResolver");
        Intrinsics.checkNotNullParameter(postponedArgumentsAnalyzer, "postponedArgumentsAnalyzer");
        Intrinsics.checkNotNullParameter(kotlinConstraintSystemCompleter, "kotlinConstraintSystemCompleter");
        Intrinsics.checkNotNullParameter(callComponents, "callComponents");
        this.builtIns = builtIns;
        this.fakeCallResolver = fakeCallResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.psiCallResolver = psiCallResolver;
        this.postponedArgumentsAnalyzer = postponedArgumentsAnalyzer;
        this.kotlinConstraintSystemCompleter = kotlinConstraintSystemCompleter;
        this.callComponents = callComponents;
    }

    public final void resolvePropertyDelegate(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtProperty property, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KtExpression delegateExpression, @NotNull LexicalScope propertyHeaderScope, @NotNull InferenceSession inferenceSession, @NotNull BindingTrace trace) {
        LexicalScope lexicalScope;
        Intrinsics.checkNotNullParameter(outerDataFlowInfo, "outerDataFlowInfo");
        Intrinsics.checkNotNullParameter(property, "property");
        Intrinsics.checkNotNullParameter(variableDescriptor, "variableDescriptor");
        Intrinsics.checkNotNullParameter(delegateExpression, "delegateExpression");
        Intrinsics.checkNotNullParameter(propertyHeaderScope, "propertyHeaderScope");
        Intrinsics.checkNotNullParameter(inferenceSession, "inferenceSession");
        Intrinsics.checkNotNullParameter(trace, "trace");
        KtPropertyAccessor ktPropertyAccessor = property.getGetter();
        if (ktPropertyAccessor != null) {
            KtPropertyAccessor getter = ktPropertyAccessor;
            boolean bl = false;
            if (getter.hasBody()) {
                trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on((KtPropertyAccessor)((PsiElement)getter)));
            }
        }
        KtPropertyAccessor ktPropertyAccessor2 = property.getSetter();
        if (ktPropertyAccessor2 != null) {
            KtPropertyAccessor setter = ktPropertyAccessor2;
            boolean bl = false;
            if (setter.hasBody()) {
                trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on((KtPropertyAccessor)((PsiElement)setter)));
            }
        }
        if (variableDescriptor instanceof PropertyDescriptor) {
            LexicalScope lexicalScope2 = ScopeUtils.makeScopeForPropertyInitializer(propertyHeaderScope, (PropertyDescriptor)variableDescriptor);
            lexicalScope = lexicalScope2;
            Intrinsics.checkNotNullExpressionValue(lexicalScope2, "makeScopeForPropertyInitializer(...)");
        } else {
            lexicalScope = propertyHeaderScope;
        }
        LexicalScope initializerScope = lexicalScope;
        KotlinType byExpressionType = this.resolveDelegateExpression(delegateExpression, property, variableDescriptor, initializerScope, trace, outerDataFlowInfo, inferenceSession);
        this.resolveProvideDelegateMethod(variableDescriptor, delegateExpression, byExpressionType, trace, initializerScope, outerDataFlowInfo, inferenceSession);
        KotlinType delegateType = this.getResolvedDelegateType(variableDescriptor, delegateExpression, byExpressionType, trace);
        this.resolveGetValueMethod(variableDescriptor, delegateExpression, delegateType, trace, initializerScope, outerDataFlowInfo, inferenceSession);
        if (property.isVar()) {
            this.resolveSetValueMethod(variableDescriptor, delegateExpression, delegateType, trace, initializerScope, outerDataFlowInfo);
        }
    }

    private final KotlinType getResolvedDelegateType(VariableDescriptorWithAccessors variableDescriptor, KtExpression delegateExpression, KotlinType byExpressionType, BindingTrace trace) {
        ResolvedCall provideDelegateResolvedCall = (ResolvedCall)trace.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, variableDescriptor);
        if (provideDelegateResolvedCall != null) {
            KotlinType kotlinType = ((FunctionDescriptor)provideDelegateResolvedCall.getResultingDescriptor()).getReturnType();
            if (kotlinType == null) {
                throw new AssertionError((Object)("No return type fore 'provideDelegate' of " + delegateExpression.getText()));
            }
            return kotlinType;
        }
        return byExpressionType;
    }

    @Nullable
    public final KotlinType getGetValueMethodReturnType(@NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KtExpression delegateExpression, @NotNull KotlinType byExpressionType, @NotNull BindingTrace trace, @NotNull LexicalScope initializerScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter(variableDescriptor, "variableDescriptor");
        Intrinsics.checkNotNullParameter(delegateExpression, "delegateExpression");
        Intrinsics.checkNotNullParameter(byExpressionType, "byExpressionType");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(initializerScope, "initializerScope");
        Intrinsics.checkNotNullParameter(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkNotNullParameter(inferenceSession, "inferenceSession");
        this.resolveProvideDelegateMethod(variableDescriptor, delegateExpression, byExpressionType, trace, initializerScope, dataFlowInfo, inferenceSession);
        KotlinType delegateType = this.getResolvedDelegateType(variableDescriptor, delegateExpression, byExpressionType, trace);
        this.resolveGetSetValueMethod(variableDescriptor, delegateExpression, delegateType, trace, initializerScope, dataFlowInfo, true);
        ResolvedCall resolvedCall2 = (ResolvedCall)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, variableDescriptor.getGetter());
        Object object = resolvedCall2;
        return object != null && (object = (FunctionDescriptor)object.getResultingDescriptor()) != null ? object.getReturnType() : null;
    }

    private final boolean isOperatorProvideDelegateSupported() {
        return this.languageVersionSettings.supportsFeature(LanguageFeature.OperatorProvideDelegate);
    }

    private final void resolveGetValueMethod(VariableDescriptorWithAccessors variableDescriptor, KtExpression delegateExpression, KotlinType delegateType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession) {
        KotlinType returnType = this.getGetValueMethodReturnType(variableDescriptor, delegateExpression, delegateType, trace, initializerScope, dataFlowInfo, inferenceSession);
        KotlinType kotlinType = variableDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        KotlinType propertyType = kotlinType;
        if (!(propertyType instanceof DeferredType) && returnType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(returnType, propertyType)) {
            Call call2 = (Call)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, variableDescriptor.getGetter());
            if (call2 == null) {
                throw new AssertionError((Object)("Call should exists for " + variableDescriptor.getGetter()));
            }
            Call call3 = call2;
            PsiElement psiElement = delegateExpression;
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_RETURN_TYPE_MISMATCH.on((KtExpression)psiElement, this.renderCall(call3, bindingContext), variableDescriptor.getType(), returnType));
        }
    }

    private final void resolveSetValueMethod(VariableDescriptorWithAccessors variableDescriptor, KtExpression delegateExpression, KotlinType delegateType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo) {
        this.resolveGetSetValueMethod(variableDescriptor, delegateExpression, delegateType, trace, initializerScope, dataFlowInfo, false);
    }

    private final KtExpression createExpressionForProperty(KtPsiFactory $this$createExpressionForProperty) {
        return $this$createExpressionForProperty.createExpression("null as " + StandardNames.FqNames.kPropertyFqName.asString() + "<*>");
    }

    private final void resolveGetSetValueMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression, KotlinType delegateType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo, boolean isGet) {
        VariableAccessorDescriptor variableAccessorDescriptor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        if (variableAccessorDescriptor == null) {
            throw new AssertionError((Object)("Delegated property should have getter/setter " + propertyDescriptor + ' ' + delegateExpression.getText()));
        }
        VariableAccessorDescriptor accessor = variableAccessorDescriptor;
        if (trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor) != null) {
            return;
        }
        OverloadResolutionResults functionResults = DelegatedPropertyResolver.getGetSetValueMethod$default(this, propertyDescriptor, delegateExpression, delegateType, trace, initializerScope, dataFlowInfo, isGet, true, null, null, 768, null);
        if (functionResults.isSuccess()) {
            this.recordDelegateOperatorResults(functionResults, propertyDescriptor, accessor, trace);
        } else {
            this.reportGetSetValueResolutionError(functionResults, accessor, delegateExpression, delegateType, trace, isGet);
        }
    }

    private final void recordDelegateOperatorResults(OverloadResolutionResults<FunctionDescriptor> result2, VariableDescriptorWithAccessors propertyDescriptor, VariableAccessorDescriptor accessor, BindingTrace trace) {
        KtPropertyDelegate delegate;
        PsiElement declaration;
        FunctionDescriptor functionDescriptor = result2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(functionDescriptor, "getResultingDescriptor(...)");
        FunctionDescriptor resultingDescriptor = functionDescriptor;
        ResolvedCall<FunctionDescriptor> resolvedCall2 = result2.getResultingCall();
        Intrinsics.checkNotNullExpressionValue(resolvedCall2, "getResultingCall(...)");
        ResolvedCall<FunctionDescriptor> resultingCall = resolvedCall2;
        if (!resultingDescriptor.isOperator() && (declaration = DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor)) instanceof KtProperty && (delegate = ((KtProperty)declaration).getDelegate()) != null) {
            PsiElement byKeyword = delegate.getByKeywordNode().getPsi();
            Intrinsics.checkNotNull(byKeyword);
            OperatorCallChecker.Companion.report(byKeyword, resultingDescriptor, trace);
        }
        trace.record(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, accessor, resultingCall);
    }

    private final void reportGetSetValueResolutionError(OverloadResolutionResults<FunctionDescriptor> result2, VariableAccessorDescriptor accessor, KtExpression delegateExpression, KotlinType delegateType, BindingTrace trace, boolean isGet) {
        Call call2 = (Call)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor);
        if (call2 == null) {
            throw new AssertionError((Object)"'getDelegatedPropertyConventionMethod' didn't record a call");
        }
        Call call3 = call2;
        boolean errorReportedForCandidate = this.reportDelegateErrorIfCandidateExists(trace, call3, result2, delegateExpression);
        if (!errorReportedForCandidate) {
            this.reportDelegateFunctionMissing(call3, delegateExpression, delegateType, trace, isGet);
        }
    }

    private final void reportDelegateFunctionMissing(Call delegateOperatorCall, KtExpression delegateExpression, KotlinType delegateType, BindingTrace trace, boolean isGet) {
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        String expectedFunction = this.renderCall(delegateOperatorCall, bindingContext);
        String delegateKind = isGet ? "delegate" : "delegate for var (read-write property)";
        trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.on((KtExpression)((PsiElement)delegateExpression), expectedFunction, delegateType, delegateKind));
    }

    private final boolean reportDelegateErrorIfCandidateExists(BindingTrace trace, Call delegateOperatorCall, OverloadResolutionResults<FunctionDescriptor> delegateOperatorResults, KtExpression delegateExpression) {
        DiagnosticFactory2<KtExpression, String, Collection<ResolvedCall<?>>> resolutionErrorFactory;
        block0: {
            DiagnosticFactory2<KtExpression, String, Collection<ResolvedCall<?>>> diagnosticFactory2 = resolutionErrorFactory = delegateOperatorResults.isSingleResult() || delegateOperatorResults.isIncomplete() || delegateOperatorResults.getResultCode() == OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES ? Errors.DELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE : (delegateOperatorResults.isAmbiguity() ? Errors.DELEGATE_SPECIAL_FUNCTION_AMBIGUITY : null);
            if (diagnosticFactory2 == null) break block0;
            DiagnosticFactory2<KtExpression, String, Collection<ResolvedCall<?>>> it = diagnosticFactory2;
            boolean bl = false;
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            String expectedFunction = this.renderCall(delegateOperatorCall, bindingContext);
            trace.report(it.on((KtExpression)((PsiElement)delegateExpression), expectedFunction, delegateOperatorResults.getResultingCalls()));
        }
        return resolutionErrorFactory != null;
    }

    private final void resolveProvideDelegateMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression byExpression, KotlinType byExpressionType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession) {
        if (!this.isOperatorProvideDelegateSupported()) {
            return;
        }
        if (trace.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_CALL, propertyDescriptor) != null) {
            return;
        }
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(trace, "trace to resolve provideDelegate method");
        Intrinsics.checkNotNullExpressionValue(temporaryBindingTrace, "create(...)");
        TemporaryBindingTrace traceForProvideDelegate = temporaryBindingTrace;
        OverloadResolutionResults<FunctionDescriptor> provideDelegateResults = this.getProvideDelegateMethod(propertyDescriptor, byExpression, byExpressionType, traceForProvideDelegate, initializerScope, dataFlowInfo, inferenceSession);
        if (!provideDelegateResults.isSuccess()) {
            Call call2 = (Call)traceForProvideDelegate.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_CALL, propertyDescriptor);
            if (call2 == null) {
                throw new AssertionError((Object)"'getDelegatedPropertyConventionMethod' didn't record a call");
            }
            Call call3 = call2;
            boolean shouldCommitTrace = this.reportDelegateErrorIfCandidateExists(traceForProvideDelegate, call3, provideDelegateResults, byExpression);
            if (shouldCommitTrace) {
                traceForProvideDelegate.commit();
            }
            return;
        }
        traceForProvideDelegate.commit();
        FunctionDescriptor functionDescriptor = provideDelegateResults.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(functionDescriptor, "getResultingDescriptor(...)");
        FunctionDescriptor resultingDescriptor = functionDescriptor;
        if (!resultingDescriptor.isOperator()) {
            return;
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = provideDelegateResults.getResultingCall();
        Intrinsics.checkNotNullExpressionValue(resolvedCall2, "getResultingCall(...)");
        ResolvedCall<FunctionDescriptor> resultingCall = resolvedCall2;
        trace.record(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor, resultingCall);
    }

    private final OverloadResolutionResults<FunctionDescriptor> getGetSetValueMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression, KotlinType delegateType, BindingTrace trace, LexicalScope scopeForDelegate, DataFlowInfo dataFlowInfo, boolean isGet, boolean isComplete, ExpressionReceiver knownReceiver, ExpressionTypingContext knownContext) {
        LexicalScope lexicalScope = ScopeUtils.makeScopeForDelegateConventionFunctions(scopeForDelegate, propertyDescriptor);
        Intrinsics.checkNotNullExpressionValue(lexicalScope, "makeScopeForDelegateConventionFunctions(...)");
        LexicalScope delegateFunctionsScope = lexicalScope;
        VariableAccessorDescriptor variableAccessorDescriptor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        if (variableAccessorDescriptor == null) {
            throw new AssertionError((Object)("Delegated property should have getter/setter " + propertyDescriptor + ' ' + delegateExpression.getText()));
        }
        VariableAccessorDescriptor accessor = variableAccessorDescriptor;
        KotlinType kotlinType = isComplete && isGet && !(propertyDescriptor.getType() instanceof DeferredType) ? propertyDescriptor.getType() : (KotlinType)TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNull(kotlinType);
        KotlinType expectedType = kotlinType;
        ExpressionTypingContext expressionTypingContext = knownContext;
        if (expressionTypingContext == null) {
            ExpressionTypingContext expressionTypingContext2 = ExpressionTypingContext.newContext(trace, delegateFunctionsScope, dataFlowInfo, expectedType, this.languageVersionSettings, this.dataFlowValueFactory);
            expressionTypingContext = expressionTypingContext2;
            Intrinsics.checkNotNullExpressionValue(expressionTypingContext2, "newContext(...)");
        }
        ExpressionTypingContext context = expressionTypingContext;
        boolean hasThis = propertyDescriptor.getExtensionReceiverParameter() != null || propertyDescriptor.getDispatchReceiverParameter() != null;
        ArrayList<KtExpression> arguments2 = Lists.newArrayList();
        Project project = delegateExpression.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false);
        arguments2.add(psiFactory.createExpression(hasThis ? "this" : "null"));
        arguments2.add(this.createExpressionForProperty(psiFactory));
        if (!isGet) {
            KtExpression ktExpression = ExpressionTypingUtils.createFakeExpressionOfType(delegateExpression.getProject(), trace, "fakeArgument" + arguments2.size(), propertyDescriptor.getType());
            Intrinsics.checkNotNull(ktExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReferenceExpression");
            KtReferenceExpression fakeArgument = (KtReferenceExpression)ktExpression;
            arguments2.add(fakeArgument);
            List<ValueParameterDescriptor> list = accessor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
            List<ValueParameterDescriptor> valueParameters2 = list;
            trace.record(BindingContext.REFERENCE_TARGET, fakeArgument, valueParameters2.get(0));
        }
        Name functionName = isGet ? OperatorNameConventions.GET_VALUE : OperatorNameConventions.SET_VALUE;
        ExpressionReceiver expressionReceiver = knownReceiver;
        if (expressionReceiver == null) {
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            expressionReceiver = ExpressionReceiver.Companion.create(delegateExpression, delegateType, bindingContext);
        }
        ExpressionReceiver receiver = expressionReceiver;
        ReceiverValue receiverValue = receiver;
        ResolutionContext resolutionContext = context;
        Intrinsics.checkNotNull(arguments2);
        Pair resolutionResult = FakeCallResolver.makeAndResolveFakeCallInContext$default(this.fakeCallResolver, receiverValue, resolutionContext, arguments2, functionName, delegateExpression, null, null, 96, null);
        trace.record(BindingContext.DELEGATED_PROPERTY_CALL, accessor, resolutionResult.getFirst());
        return (OverloadResolutionResults)resolutionResult.getSecond();
    }

    static /* synthetic */ OverloadResolutionResults getGetSetValueMethod$default(DelegatedPropertyResolver delegatedPropertyResolver, VariableDescriptorWithAccessors variableDescriptorWithAccessors, KtExpression ktExpression, KotlinType kotlinType, BindingTrace bindingTrace, LexicalScope lexicalScope, DataFlowInfo dataFlowInfo, boolean bl, boolean bl2, ExpressionReceiver expressionReceiver, ExpressionTypingContext expressionTypingContext, int n, Object object) {
        if ((n & 0x100) != 0) {
            expressionReceiver = null;
        }
        if ((n & 0x200) != 0) {
            expressionTypingContext = null;
        }
        return delegatedPropertyResolver.getGetSetValueMethod(variableDescriptorWithAccessors, ktExpression, kotlinType, bindingTrace, lexicalScope, dataFlowInfo, bl, bl2, expressionReceiver, expressionTypingContext);
    }

    private final ExpressionReceiver createReceiverForGetSetValueMethods(KtExpression delegateExpression, KotlinType delegateType, BindingTrace trace) {
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        return ExpressionReceiver.Companion.create(delegateExpression, delegateType, bindingContext);
    }

    private final ExpressionTypingContext createContextForGetSetValueMethods(VariableDescriptorWithAccessors propertyDescriptor, LexicalScope scopeForDelegate, DataFlowInfo dataFlowInfo, BindingTrace trace, InferenceSession inferenceExtension) {
        LexicalScope lexicalScope = ScopeUtils.makeScopeForDelegateConventionFunctions(scopeForDelegate, propertyDescriptor);
        Intrinsics.checkNotNullExpressionValue(lexicalScope, "makeScopeForDelegateConventionFunctions(...)");
        LexicalScope delegateFunctionsScope = lexicalScope;
        ExpressionTypingContext expressionTypingContext = ExpressionTypingContext.newContext(trace, delegateFunctionsScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory, inferenceExtension);
        Intrinsics.checkNotNullExpressionValue(expressionTypingContext, "newContext(...)");
        return expressionTypingContext;
    }

    private final ExpressionTypingContext createContextForProvideDelegateMethod(LexicalScope scopeForDelegate, DataFlowInfo dataFlowInfo, BindingTrace trace, InferenceSession inferenceExtension) {
        ExpressionTypingContext expressionTypingContext = ExpressionTypingContext.newContext(trace, scopeForDelegate, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, ContextDependency.INDEPENDENT, StatementFilter.NONE, this.languageVersionSettings, this.dataFlowValueFactory, inferenceExtension);
        Intrinsics.checkNotNullExpressionValue(expressionTypingContext, "newContext(...)");
        return expressionTypingContext;
    }

    private final OverloadResolutionResults<FunctionDescriptor> getProvideDelegateMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression, KotlinType delegateExpressionType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession) {
        ExpressionTypingContext expressionTypingContext = ExpressionTypingContext.newContext(trace, initializerScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory, inferenceSession);
        Intrinsics.checkNotNullExpressionValue(expressionTypingContext, "newContext(...)");
        ExpressionTypingContext context = expressionTypingContext;
        return this.getProvideDelegateMethod(propertyDescriptor, delegateExpression, delegateExpressionType, context);
    }

    private final OverloadResolutionResults<FunctionDescriptor> getProvideDelegateMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression, KotlinType delegateExpressionType, ExpressionTypingContext context) {
        boolean propertyHasReceiver = propertyDescriptor.getDispatchReceiverParameter() != null;
        Project project = delegateExpression.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
        KtPsiFactory $this$getProvideDelegateMethod_u24lambda_u243 = new KtPsiFactory(project, false);
        boolean bl = false;
        KtExpression[] ktExpressionArray = new KtExpression[]{$this$getProvideDelegateMethod_u24lambda_u243.createExpression(propertyHasReceiver ? "this" : "null"), this.createExpressionForProperty($this$getProvideDelegateMethod_u24lambda_u243)};
        List<KtExpression> arguments2 = CollectionsKt.listOf(ktExpressionArray);
        Name functionName = OperatorNameConventions.PROVIDE_DELEGATE;
        BindingContext bindingContext = context.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(delegateExpression, delegateExpressionType, bindingContext);
        Pair pair = FakeCallResolver.makeAndResolveFakeCallInContext$default(this.fakeCallResolver, receiver, context, arguments2, functionName, delegateExpression, null, null, 96, null);
        Call provideDelegateCall = (Call)pair.component1();
        OverloadResolutionResults provideDelegateResults = (OverloadResolutionResults)pair.component2();
        if (provideDelegateResults.isSingleResult()) {
            context.trace.record(BindingContext.DELEGATE_EXPRESSION_TO_PROVIDE_DELEGATE_CALL, delegateExpression, provideDelegateCall);
        }
        context.trace.record(BindingContext.PROVIDE_DELEGATE_CALL, propertyDescriptor, provideDelegateCall);
        return provideDelegateResults;
    }

    private final String renderCall(Call call2, BindingContext context) {
        KtExpression ktExpression = call2.getCalleeExpression();
        if (ktExpression == null) {
            throw new AssertionError((Object)"CalleeExpression should exists for fake call of convention method");
        }
        KtExpression calleeExpression = ktExpression;
        List<? extends ValueArgument> list = call2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
        List<? extends ValueArgument> list2 = list;
        String string2 = calleeExpression.getText() + '(';
        return CollectionsKt.joinToString$default(list2, ", ", string2, ")", 0, null, arg_0 -> DelegatedPropertyResolver.renderCall$lambda$4(context, arg_0), 24, null);
    }

    @NotNull
    public final KotlinType resolveDelegateExpression(@NotNull KtExpression delegateExpression, @NotNull KtProperty property, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull LexicalScope scopeForDelegate, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter(delegateExpression, "delegateExpression");
        Intrinsics.checkNotNullParameter(property, "property");
        Intrinsics.checkNotNullParameter(variableDescriptor, "variableDescriptor");
        Intrinsics.checkNotNullParameter(scopeForDelegate, "scopeForDelegate");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkNotNullParameter(inferenceSession, "inferenceSession");
        KotlinType kotlinType = property.getTypeReference() != null ? variableDescriptor.getType() : (KotlinType)TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNull(kotlinType);
        KotlinType propertyExpectedType = kotlinType;
        kotlinType = this.resolveWithNewInference(delegateExpression, variableDescriptor, scopeForDelegate, trace, dataFlowInfo, inferenceSession);
        if (kotlinType != null) {
            KotlinType it = kotlinType;
            boolean bl = false;
            return it;
        }
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(trace, "Trace to resolve delegated property");
        Intrinsics.checkNotNullExpressionValue(temporaryBindingTrace, "create(...)");
        TemporaryBindingTrace traceToResolveDelegatedProperty = temporaryBindingTrace;
        ConstraintSystemCompleterImpl completer = new ConstraintSystemCompleterImpl(property, propertyExpectedType, variableDescriptor, delegateExpression, scopeForDelegate, trace, dataFlowInfo);
        KtExpression ktExpression = PsiUtilsKt.getCalleeExpressionIfAny(delegateExpression);
        if (ktExpression != null) {
            KtExpression it = ktExpression;
            boolean bl = false;
            WritableSlice<KtElement, ConstraintSystemCompleter> writableSlice = BindingContext.CONSTRAINT_SYSTEM_COMPLETER;
            Intrinsics.checkNotNullExpressionValue(writableSlice, "CONSTRAINT_SYSTEM_COMPLETER");
            traceToResolveDelegatedProperty.record(writableSlice, it, completer);
        }
        KotlinType kotlinType2 = this.expressionTypingServices.safeGetType(scopeForDelegate, delegateExpression, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, inferenceSession, traceToResolveDelegatedProperty);
        Intrinsics.checkNotNullExpressionValue(kotlinType2, "safeGetType(...)");
        KotlinType delegateType = kotlinType2;
        traceToResolveDelegatedProperty.commit(DelegatedPropertyResolver::resolveDelegateExpression$lambda$7, true);
        return delegateType;
    }

    private final void completeNotComputedDelegateType(BindingTrace trace, TemporaryBindingTrace traceToResolveDelegatedProperty) {
        Object v1;
        block2: {
            Diagnostics diagnostics = traceToResolveDelegatedProperty.getBindingContext().getDiagnostics();
            Intrinsics.checkNotNullExpressionValue(diagnostics, "getDiagnostics(...)");
            Iterable iterable = diagnostics;
            for (Object t : iterable) {
                Diagnostic it = (Diagnostic)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getFactory(), Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM.getErrorFactory()) || Intrinsics.areEqual(it.getFactory(), Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM.getWarningFactory()))) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        Diagnostic ranIntoRecursionDiagnostic = v1;
        if (ranIntoRecursionDiagnostic != null) {
            PsiElement psiElement = ranIntoRecursionDiagnostic.getPsiElement();
            Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            trace.report(Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM.on(this.languageVersionSettings, (KtExpression)((PsiElement)((KtExpression)psiElement))));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType resolveWithNewInference(KtExpression delegateExpression, VariableDescriptorWithAccessors variableDescriptor, LexicalScope scopeForDelegate, BindingTrace trace, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession) {
        KotlinType delegateTypeForProperType;
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.NewInference)) {
            return null;
        }
        KotlinType kotlinType = trace.getType(delegateExpression);
        if (kotlinType != null) {
            KotlinType it = kotlinType;
            boolean bl = false;
            return it;
        }
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(trace, "Trace to resolve delegated property");
        Intrinsics.checkNotNullExpressionValue(temporaryBindingTrace, "create(...)");
        TemporaryBindingTrace traceToResolveDelegatedProperty = temporaryBindingTrace;
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(scopeForDelegate, delegateExpression, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, inferenceSession, traceToResolveDelegatedProperty, false, delegateExpression, ContextDependency.DEPENDENT);
        Intrinsics.checkNotNullExpressionValue(kotlinTypeInfo, "getTypeInfo(...)");
        KotlinTypeInfo delegateTypeInfo = kotlinTypeInfo;
        KotlinType kotlinType2 = delegateTypeInfo.getType();
        if (kotlinType2 == null) {
            DelegatedPropertyResolver $this$resolveWithNewInference_u24lambda_u2410 = this;
            boolean bl = false;
            $this$resolveWithNewInference_u24lambda_u2410.completeNotComputedDelegateType(trace, traceToResolveDelegatedProperty);
            return null;
        }
        KotlinType delegateType = kotlinType2;
        DataFlowInfo delegateDataFlow = delegateTypeInfo.getDataFlowInfo();
        TypeConstructor delegateTypeConstructor = delegateType.getConstructor();
        if (delegateTypeConstructor instanceof IntegerLiteralTypeConstructor) {
            delegateType = ((IntegerLiteralTypeConstructor)delegateTypeConstructor).getApproximatedType();
        }
        KotlinType kotlinType3 = delegateTypeForProperType = this.isProperType(delegateType) ? delegateType : null;
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.OperatorProvideDelegate)) {
            NewTypeSubstitutor newTypeSubstitutor;
            TemporaryBindingTrace temporaryBindingTrace2 = TemporaryBindingTrace.create(traceToResolveDelegatedProperty, "Trace to resolve provide delegate");
            Intrinsics.checkNotNullExpressionValue(temporaryBindingTrace2, "create(...)");
            TemporaryBindingTrace traceForProvideDelegate = temporaryBindingTrace2;
            Map<UnwrappedType, UnwrappedType> substitutionMap = this.buildSubstitutionMapOfNonFixedVariables(delegateType);
            if (substitutionMap != null) {
                void $this$mapKeysTo$iv$iv;
                Map<UnwrappedType, UnwrappedType> $this$mapKeys$iv = substitutionMap;
                boolean $i$f$mapKeys = false;
                Map<UnwrappedType, UnwrappedType> map2 = $this$mapKeys$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapKeys$iv.size()));
                boolean $i$f$mapKeysTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    void it;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    TypeConstructor typeConstructor2 = ((UnwrappedType)it.getKey()).getConstructor();
                    Map map4 = map3;
                    boolean bl2 = false;
                    entry = it$iv$iv.getValue();
                    map4.put(typeConstructor2, entry);
                }
                Map map5 = destination$iv$iv;
                newTypeSubstitutor = new NewTypeSubstitutorByConstructorMap(map5);
            } else {
                newTypeSubstitutor = EmptySubstitutor.INSTANCE;
            }
            NewTypeSubstitutor nonFixedVariablesToStubTypesSubstitutor = newTypeSubstitutor;
            UnwrappedType delegateTypeWithoutNonFixedVariables = nonFixedVariablesToStubTypesSubstitutor.safeSubstitute(delegateType.unwrap());
            ExpressionTypingContext contextForProvideDelegate = this.createContextForProvideDelegateMethod(scopeForDelegate, delegateDataFlow, traceForProvideDelegate, new InferenceSessionForExistingCandidates(substitutionMap != null, inferenceSession));
            OverloadResolutionResults<FunctionDescriptor> provideDelegateResults = this.getProvideDelegateMethod(variableDescriptor, delegateExpression, delegateTypeWithoutNonFixedVariables, contextForProvideDelegate);
            if (provideDelegateResults.isSuccess()) {
                FunctionDescriptor functionDescriptor = provideDelegateResults.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue(functionDescriptor, "getResultingDescriptor(...)");
                FunctionDescriptor provideDelegateDescriptor = functionDescriptor;
                if (provideDelegateDescriptor.isOperator()) {
                    UnwrappedType unwrappedType = this.inverseSubstitution(provideDelegateDescriptor.getReturnType(), substitutionMap);
                    if (unwrappedType == null) {
                        return null;
                    }
                    delegateType = unwrappedType;
                    DataFlowInfo dataFlowInfo2 = provideDelegateResults.getResultingCall().getDataFlowInfoForArguments().getResultInfo();
                    Intrinsics.checkNotNullExpressionValue(dataFlowInfo2, "getResultInfo(...)");
                    delegateDataFlow = dataFlowInfo2;
                }
                if (substitutionMap == null) {
                    WritableSlice<VariableDescriptorWithAccessors, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue(writableSlice, "PROVIDE_DELEGATE_RESOLVED_CALL");
                    traceForProvideDelegate.record(writableSlice, variableDescriptor, provideDelegateResults.getResultingCall());
                    traceForProvideDelegate.commit();
                }
            }
        }
        return this.inferDelegateTypeFromGetSetValueMethods(delegateExpression, variableDescriptor, scopeForDelegate, traceToResolveDelegatedProperty, delegateType, delegateTypeForProperType, delegateDataFlow, inferenceSession);
    }

    private final UnwrappedType inverseSubstitution(KotlinType type2, Map<UnwrappedType, ? extends UnwrappedType> substitutionMap) {
        if (type2 == null) {
            return null;
        }
        if (substitutionMap == null) {
            return type2.unwrap();
        }
        HashMap invertedMap = new HashMap();
        for (Map.Entry<UnwrappedType, ? extends UnwrappedType> entry : substitutionMap.entrySet()) {
            UnwrappedType variable = entry.getKey();
            UnwrappedType stubType = entry.getValue();
            ((Map)invertedMap).put(stubType.getConstructor(), variable);
        }
        return new NewTypeSubstitutorByConstructorMap(invertedMap).safeSubstitute(type2.unwrap());
    }

    private final Map<UnwrappedType, UnwrappedType> buildSubstitutionMapOfNonFixedVariables(KotlinType type2) {
        if (type2.getConstructor() instanceof NewTypeVariableConstructor) {
            return null;
        }
        Ref.ObjectRef substitutionMap = new Ref.ObjectRef();
        TypeUtilsKt.contains(type2, arg_0 -> DelegatedPropertyResolver.buildSubstitutionMapOfNonFixedVariables$lambda$12(substitutionMap, arg_0));
        return (Map)substitutionMap.element;
    }

    private final UnwrappedType inferDelegateTypeFromGetSetValueMethods(KtExpression delegateExpression, VariableDescriptorWithAccessors variableDescriptor, LexicalScope scopeForDelegate, TemporaryBindingTrace trace, KotlinType delegateType, KotlinType delegateTypeForProperType, DataFlowInfo delegateDataFlow, InferenceSession inferenceSession) {
        UnwrappedType expectedType = !(variableDescriptor.getType() instanceof DeferredType) ? variableDescriptor.getType().unwrap() : null;
        DelegateInferenceSession newInferenceSession = new DelegateInferenceSession(variableDescriptor, expectedType, this.psiCallResolver, this.postponedArgumentsAnalyzer, this.kotlinConstraintSystemCompleter, this.callComponents, this.builtIns, inferenceSession);
        ExpressionReceiver receiver = this.createReceiverForGetSetValueMethods(delegateExpression, delegateType, trace);
        ExpressionTypingContext context = this.createContextForGetSetValueMethods(variableDescriptor, scopeForDelegate, delegateDataFlow, trace, newInferenceSession);
        this.getGetSetValueMethod(variableDescriptor, delegateExpression, delegateType, trace, scopeForDelegate, delegateDataFlow, true, true, receiver, context);
        if (variableDescriptor.isVar() && !(variableDescriptor.getReturnType() instanceof DeferredType)) {
            this.getGetSetValueMethod(variableDescriptor, delegateExpression, delegateType, trace, scopeForDelegate, delegateDataFlow, false, true, receiver, context);
        }
        Call call2 = CallMaker.makeCall(delegateExpression, receiver);
        Intrinsics.checkNotNullExpressionValue(call2, "makeCall(...)");
        Call call3 = call2;
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context, call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        Intrinsics.checkNotNullExpressionValue(basicCallResolutionContext, "create(...)");
        BasicCallResolutionContext resolutionContext = basicCallResolutionContext;
        KotlinResolutionCallbacksImpl resolutionCallbacks = this.psiCallResolver.createResolutionCallbacks(trace, newInferenceSession, resolutionContext);
        List resolutionResults = newInferenceSession.resolveCandidates(resolutionCallbacks);
        Pair[] object2 = new Pair[]{TuplesKt.to(OperatorNameConventions.GET_VALUE, true), TuplesKt.to(OperatorNameConventions.SET_VALUE, false)};
        for (Pair pair : CollectionsKt.listOf(object2)) {
            ResolutionResultCallInfo it;
            Object v3;
            boolean isGet;
            block4: {
                Name name = (Name)pair.component1();
                isGet = (Boolean)pair.component2();
                Iterable $this$firstOrNull$iv = resolutionResults;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ResolutionResultCallInfo it2 = (ResolutionResultCallInfo)element$iv;
                    boolean bl = false;
                    Object object = ResolutionAtomsKt.resultCallAtom(it2.getResolutionResult());
                    if (!Intrinsics.areEqual(object != null && (object = ((ResolvedCallAtom)object).getAtom()) != null ? object.getName() : null, name)) continue;
                    v3 = element$iv;
                    break block4;
                }
                v3 = null;
            }
            ResolutionResultCallInfo result2 = v3;
            if (result2 == null) continue;
            boolean bl = false;
            DelegatedPropertyResolver.inferDelegateTypeFromGetSetValueMethods$recordResolvedDelegateOrReportError(variableDescriptor, this, trace, delegateExpression, delegateType, it.getOverloadResolutionResults(), isGet);
        }
        KotlinType resolvedDelegateType = this.extractResolvedDelegateType(delegateExpression, trace, delegateType);
        KotlinType kotlinType = delegateTypeForProperType;
        if (kotlinType == null) {
            kotlinType = resolvedDelegateType;
        }
        trace.recordType(delegateExpression, kotlinType);
        trace.commit();
        return resolvedDelegateType.unwrap();
    }

    private final KotlinType extractResolvedDelegateType(KtExpression delegateExpression, BindingTrace trace, KotlinType delegateType) {
        Object object;
        block5: {
            String[] stringArray;
            block4: {
                KotlinType kotlinType;
                KtElement ktElement = delegateExpression;
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                Call call2 = CallUtilKt.getCall(ktElement, bindingContext);
                BindingContext bindingContext2 = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext2, "getBindingContext(...)");
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(call2, bindingContext2);
                KotlinType pretendReturnType = resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null ? resolvedCall2.getReturnType() : null;
                object = pretendReturnType;
                if (object == null) break block4;
                KotlinType it = kotlinType = object;
                boolean bl = false;
                object = this.isProperType(it) ? kotlinType : null;
                if (object != null) break block5;
            }
            String[] it = stringArray = delegateType;
            boolean bl = false;
            object = this.isProperType((KotlinType)it) ? stringArray : null;
            if (object == null) {
                stringArray = new String[]{delegateExpression.getText()};
                object = ErrorUtils.createErrorType(ErrorTypeKind.TYPE_FOR_DELEGATION, stringArray);
            }
        }
        return object;
    }

    private final boolean isProperType(KotlinType $this$isProperType) {
        return !TypeUtilsKt.contains($this$isProperType, DelegatedPropertyResolver::isProperType$lambda$18);
    }

    private final boolean conventionMethodFound(OverloadResolutionResults<FunctionDescriptor> results) {
        return results.isSuccess() || results.isSingleResult() && results.getResultCode() == OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH;
    }

    private static final CharSequence renderCall$lambda$4(BindingContext $context, ValueArgument argument) {
        KtExpression ktExpression = argument.getArgumentExpression();
        Intrinsics.checkNotNull(ktExpression);
        KotlinType kotlinType = $context.getType(ktExpression);
        Intrinsics.checkNotNull(kotlinType);
        KotlinType type2 = kotlinType;
        return DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(type2);
    }

    private static final boolean resolveDelegateExpression$lambda$7(WritableSlice slice, Object object) {
        return slice != BindingContext.CONSTRAINT_SYSTEM_COMPLETER;
    }

    private static final boolean buildSubstitutionMapOfNonFixedVariables$lambda$12(Ref.ObjectRef $substitutionMap, UnwrappedType innerType) {
        Intrinsics.checkNotNullParameter(innerType, "innerType");
        TypeConstructor constructor = innerType.getConstructor();
        if (constructor instanceof NewTypeVariableConstructor) {
            if ($substitutionMap.element == null) {
                $substitutionMap.element = new HashMap();
            }
            Object t = $substitutionMap.element;
            Intrinsics.checkNotNull(t);
            if (!((Map)t).containsKey(innerType)) {
                Object t2 = $substitutionMap.element;
                Intrinsics.checkNotNull(t2);
                ((Map)t2).put(innerType, new StubTypeForProvideDelegateReceiver((NewTypeVariableConstructor)constructor, innerType.isMarkedNullable(), null, 4, null));
            }
        }
        return false;
    }

    private static final void inferDelegateTypeFromGetSetValueMethods$recordResolvedDelegateOrReportError(VariableDescriptorWithAccessors $variableDescriptor, DelegatedPropertyResolver this$0, TemporaryBindingTrace $trace, KtExpression $delegateExpression, KotlinType $delegateType, OverloadResolutionResults<FunctionDescriptor> result2, boolean isGet) {
        VariableAccessorDescriptor accessor;
        VariableAccessorDescriptor variableAccessorDescriptor;
        boolean bl = isGet;
        if (bl) {
            variableAccessorDescriptor = $variableDescriptor.getGetter();
        } else if (!bl) {
            variableAccessorDescriptor = $variableDescriptor.getSetter();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if ((accessor = variableAccessorDescriptor) == null) {
            boolean bl2 = false;
            String string2 = "Delegated property should have getter/setter " + $variableDescriptor + ' ' + $delegateExpression.getText();
            throw new IllegalArgumentException(string2.toString());
        }
        if (result2.isSuccess()) {
            this$0.recordDelegateOperatorResults(result2, $variableDescriptor, accessor, $trace);
        } else {
            this$0.reportGetSetValueResolutionError(result2, accessor, $delegateExpression, $delegateType, $trace, isGet);
        }
    }

    private static final boolean isProperType$lambda$18(UnwrappedType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getConstructor() instanceof TypeVariableTypeConstructor;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\b\u0086\u0004\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J#\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00122\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ1\u0010$\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020 2\b\b\u0002\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b$\u0010%R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010&\u001a\u0004\b'\u0010(R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010)\u001a\u0004\b*\u0010+R\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010,\u001a\u0004\b-\u0010.R\u001a\u0010\t\u001a\u00020\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u0010/\u001a\u0004\b0\u00101R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00102R\u001a\u0010\r\u001a\u00020\f8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\r\u00103\u001a\u0004\b4\u00105R\u001a\u0010\u000f\u001a\u00020\u000e8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000f\u00106\u001a\u0004\b7\u00108"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver$ConstraintSystemCompleterImpl;", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemCompleter;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "Lorg/jetbrains/kotlin/types/KotlinType;", "expectedType", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "variableDescriptor", "Lorg/jetbrains/kotlin/psi/KtExpression;", "delegateExpression", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "scopeForDelegate", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "dataFlowInfo", "<init>", "(Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;)V", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "", "completeConstraintSystem", "(Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;)V", "byExpressionType", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "typeVariableSubstitutor", "Lorg/jetbrains/kotlin/resolve/TemporaryBindingTrace;", "traceToResolveConventionMethods", "getDelegateType", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;Lorg/jetbrains/kotlin/types/TypeSubstitutor;Lorg/jetbrains/kotlin/resolve/TemporaryBindingTrace;)Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "resultingDescriptor", "", "dispatchReceiverOnly", "addConstraintForThisValue", "(Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;Lorg/jetbrains/kotlin/types/TypeSubstitutor;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Z)V", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getProperty", "()Lorg/jetbrains/kotlin/psi/KtProperty;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getExpectedType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "getVariableDescriptor", "()Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getDelegateExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getDataFlowInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;"})
    public final class ConstraintSystemCompleterImpl
    implements ConstraintSystemCompleter {
        @NotNull
        private final KtProperty property;
        @NotNull
        private final KotlinType expectedType;
        @NotNull
        private final VariableDescriptorWithAccessors variableDescriptor;
        @NotNull
        private final KtExpression delegateExpression;
        @NotNull
        private final LexicalScope scopeForDelegate;
        @NotNull
        private final BindingTrace trace;
        @NotNull
        private final DataFlowInfo dataFlowInfo;

        public ConstraintSystemCompleterImpl(@NotNull KtProperty property, @NotNull KotlinType expectedType, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KtExpression delegateExpression, @NotNull LexicalScope scopeForDelegate, @NotNull BindingTrace trace, DataFlowInfo dataFlowInfo) {
            Intrinsics.checkNotNullParameter(property, "property");
            Intrinsics.checkNotNullParameter(expectedType, "expectedType");
            Intrinsics.checkNotNullParameter(variableDescriptor, "variableDescriptor");
            Intrinsics.checkNotNullParameter(delegateExpression, "delegateExpression");
            Intrinsics.checkNotNullParameter(scopeForDelegate, "scopeForDelegate");
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(dataFlowInfo, "dataFlowInfo");
            this.property = property;
            this.expectedType = expectedType;
            this.variableDescriptor = variableDescriptor;
            this.delegateExpression = delegateExpression;
            this.scopeForDelegate = scopeForDelegate;
            this.trace = trace;
            this.dataFlowInfo = dataFlowInfo;
        }

        @NotNull
        public final KtProperty getProperty() {
            return this.property;
        }

        @NotNull
        public final KotlinType getExpectedType() {
            return this.expectedType;
        }

        @NotNull
        public final VariableDescriptorWithAccessors getVariableDescriptor() {
            return this.variableDescriptor;
        }

        @NotNull
        public final KtExpression getDelegateExpression() {
            return this.delegateExpression;
        }

        @NotNull
        public final BindingTrace getTrace() {
            return this.trace;
        }

        @NotNull
        public final DataFlowInfo getDataFlowInfo() {
            return this.dataFlowInfo;
        }

        @Override
        public void completeConstraintSystem(@NotNull ConstraintSystem.Builder constraintSystem, @NotNull ResolvedCall<?> resolvedCall2) {
            Intrinsics.checkNotNullParameter(constraintSystem, "constraintSystem");
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            KotlinType kotlinType = resolvedCall2.getCandidateDescriptor().getReturnType();
            if (kotlinType == null) {
                return;
            }
            KotlinType returnType = kotlinType;
            Map<CallHandle, TypeSubstitutor> map2 = constraintSystem.getTypeVariableSubstitutors();
            Call call2 = resolvedCall2.getCall();
            Intrinsics.checkNotNullExpressionValue(call2, "getCall(...)");
            TypeSubstitutor typeSubstitutor2 = map2.get(TypeVariableKt.toHandle(call2));
            if (typeSubstitutor2 == null) {
                throw new AssertionError((Object)("No substitutor in the system for call: " + resolvedCall2.getCall()));
            }
            TypeSubstitutor typeVariableSubstitutor = typeSubstitutor2;
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(this.trace, "Trace to resolve delegated property convention methods");
            Intrinsics.checkNotNullExpressionValue(temporaryBindingTrace, "create(...)");
            TemporaryBindingTrace traceToResolveConventionMethods = temporaryBindingTrace;
            KotlinType delegateType = this.getDelegateType(returnType, constraintSystem, typeVariableSubstitutor, traceToResolveConventionMethods);
            OverloadResolutionResults getValueResults = DelegatedPropertyResolver.getGetSetValueMethod$default(DelegatedPropertyResolver.this, this.variableDescriptor, this.delegateExpression, delegateType, traceToResolveConventionMethods, this.scopeForDelegate, this.dataFlowInfo, true, false, null, null, 768, null);
            if (DelegatedPropertyResolver.this.conventionMethodFound(getValueResults)) {
                KotlinType returnTypeInSystem;
                Object d = getValueResults.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue(d, "getResultingDescriptor(...)");
                FunctionDescriptor getValueDescriptor = (FunctionDescriptor)d;
                KotlinType getValueReturnType = getValueDescriptor.getReturnType();
                if (getValueReturnType != null && !TypeUtils.noExpectedType(this.expectedType) && (returnTypeInSystem = typeVariableSubstitutor.substitute(getValueReturnType, Variance.INVARIANT)) != null) {
                    constraintSystem.addSubtypeConstraint(returnTypeInSystem, this.expectedType, ConstraintPositionKind.FROM_COMPLETER.position());
                }
                ConstraintSystemCompleterImpl.addConstraintForThisValue$default(this, constraintSystem, typeVariableSubstitutor, getValueDescriptor, false, 8, null);
            }
            if (!this.variableDescriptor.isVar()) {
                return;
            }
            if (this.variableDescriptor.getReturnType() instanceof DeferredType) {
                return;
            }
            OverloadResolutionResults setValueResults = DelegatedPropertyResolver.getGetSetValueMethod$default(DelegatedPropertyResolver.this, this.variableDescriptor, this.delegateExpression, delegateType, traceToResolveConventionMethods, this.scopeForDelegate, this.dataFlowInfo, false, false, null, null, 768, null);
            if (DelegatedPropertyResolver.this.conventionMethodFound(setValueResults)) {
                Object d = setValueResults.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue(d, "getResultingDescriptor(...)");
                FunctionDescriptor setValueDescriptor = (FunctionDescriptor)d;
                List<ValueParameterDescriptor> list = setValueDescriptor.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
                List<ValueParameterDescriptor> setValueParameters = list;
                if (setValueParameters.size() == 3) {
                    if (!TypeUtils.noExpectedType(this.expectedType)) {
                        KotlinType kotlinType2 = setValueParameters.get(2).getType();
                        Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
                        KotlinType thisParameterType = kotlinType2;
                        KotlinType substitutedThisParameterType = typeVariableSubstitutor.substitute(thisParameterType, Variance.INVARIANT);
                        constraintSystem.addSubtypeConstraint(this.expectedType, substitutedThisParameterType, ConstraintPositionKind.FROM_COMPLETER.position());
                    }
                    ConstraintSystemCompleterImpl.addConstraintForThisValue$default(this, constraintSystem, typeVariableSubstitutor, setValueDescriptor, false, 8, null);
                }
            }
        }

        private final KotlinType getDelegateType(KotlinType byExpressionType, ConstraintSystem.Builder constraintSystem, TypeSubstitutor typeVariableSubstitutor, TemporaryBindingTrace traceToResolveConventionMethods) {
            OverloadResolutionResults provideDelegateResults;
            if (DelegatedPropertyResolver.this.isOperatorProvideDelegateSupported() && DelegatedPropertyResolver.this.conventionMethodFound(provideDelegateResults = DelegatedPropertyResolver.this.getProvideDelegateMethod(this.variableDescriptor, this.delegateExpression, byExpressionType, traceToResolveConventionMethods, this.scopeForDelegate, this.dataFlowInfo, null))) {
                Object d = provideDelegateResults.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue(d, "getResultingDescriptor(...)");
                FunctionDescriptor provideDelegateDescriptor = (FunctionDescriptor)d;
                KotlinType provideDelegateReturnType = provideDelegateDescriptor.getReturnType();
                if (provideDelegateDescriptor.isOperator()) {
                    this.addConstraintForThisValue(constraintSystem, typeVariableSubstitutor, provideDelegateDescriptor, true);
                    KotlinType kotlinType = provideDelegateReturnType;
                    if (kotlinType == null) {
                        throw new AssertionError((Object)("No return type fore 'provideDelegate' of " + this.delegateExpression.getText()));
                    }
                    return kotlinType;
                }
            }
            return byExpressionType;
        }

        private final void addConstraintForThisValue(ConstraintSystem.Builder constraintSystem, TypeSubstitutor typeVariableSubstitutor, FunctionDescriptor resultingDescriptor, boolean dispatchReceiverOnly) {
            Annotated annotated;
            Annotated annotated2;
            ReceiverParameterDescriptor extensionReceiver = this.variableDescriptor.getExtensionReceiverParameter();
            ReceiverParameterDescriptor dispatchReceiver = this.variableDescriptor.getDispatchReceiverParameter();
            if (dispatchReceiverOnly) {
                ReceiverParameterDescriptor receiverParameterDescriptor = dispatchReceiver;
                annotated2 = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
            } else {
                annotated2 = extensionReceiver;
                if (annotated2 == null || (annotated2 = annotated2.getType()) == null) {
                    ReceiverParameterDescriptor receiverParameterDescriptor = dispatchReceiver;
                    annotated2 = annotated = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
                }
            }
            if (annotated2 == null) {
                SimpleType simpleType2 = DelegatedPropertyResolver.this.builtIns.getNullableNothingType();
                Intrinsics.checkNotNullExpressionValue(simpleType2, "getNullableNothingType(...)");
                annotated = simpleType2;
            }
            Annotated typeOfThis = annotated;
            List<ValueParameterDescriptor> list = resultingDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
            List<ValueParameterDescriptor> valueParameters2 = list;
            if (valueParameters2.isEmpty()) {
                return;
            }
            ValueParameterDescriptor valueParameterForThis = valueParameters2.get(0);
            constraintSystem.addSubtypeConstraint((KotlinType)typeOfThis, typeVariableSubstitutor.substitute(valueParameterForThis.getType(), Variance.INVARIANT), ConstraintPositionKind.FROM_COMPLETER.position());
        }

        static /* synthetic */ void addConstraintForThisValue$default(ConstraintSystemCompleterImpl constraintSystemCompleterImpl, ConstraintSystem.Builder builder2, TypeSubstitutor typeSubstitutor2, FunctionDescriptor functionDescriptor, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            constraintSystemCompleterImpl.addConstraintForThisValue(builder2, typeSubstitutor2, functionDescriptor, bl);
        }
    }
}

