/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegationResolver$Companion$getDelegates$;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.MemberComparator;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.DelegationFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0011\u0018\u0000 1*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003:\u0003231BU\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J+\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ%\u0010#\u001a\u00020\"2\u0006\u0010 \u001a\u00028\u00002\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0002\u00a2\u0006\u0004\b#\u0010$J\u001d\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010%\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b&\u0010\u001fJ\u0013\u0010'\u001a\u00020\"*\u00028\u0000H\u0002\u00a2\u0006\u0004\b'\u0010(R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010)R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010*R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010+R\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010,R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010-R\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010.R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010/R\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u00100"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegationResolver;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "T", "", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "classOrObject", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "ownerDescriptor", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "existingMembers", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;", "memberExtractor", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/lazy/DelegationFilter;", "delegationFilter", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "<init>", "(Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/Collection;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;Lorg/jetbrains/kotlin/resolve/lazy/DelegationFilter;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "generateDelegatedMembers", "()Ljava/util/Collection;", "existingDelegates", "Lorg/jetbrains/kotlin/types/KotlinType;", "delegatedInterfaceType", "generateDelegatesForInterface", "(Ljava/util/Collection;Lorg/jetbrains/kotlin/types/KotlinType;)Ljava/util/Collection;", "generateDelegationCandidates", "(Lorg/jetbrains/kotlin/types/KotlinType;)Ljava/util/Collection;", "candidate", "delegatedMembers", "", "checkClashWithOtherDelegatedMember", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;Ljava/util/Collection;)Z", "interfaceType", "getDelegatableMembers", "overridesClassMembersOnly", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;)Z", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Ljava/util/Collection;", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;", "Lorg/jetbrains/kotlin/resolve/lazy/DelegationFilter;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Companion", "MemberExtractor", "TypeResolver"})
public final class DelegationResolver<T extends CallableMemberDescriptor> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtPureClassOrObject classOrObject;
    @NotNull
    private final ClassDescriptor ownerDescriptor;
    @NotNull
    private final Collection<CallableDescriptor> existingMembers;
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final MemberExtractor<T> memberExtractor;
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final DelegationFilter delegationFilter;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    private DelegationResolver(KtPureClassOrObject classOrObject, ClassDescriptor ownerDescriptor, Collection<? extends CallableDescriptor> existingMembers, BindingTrace trace, MemberExtractor<? extends T> memberExtractor, TypeResolver typeResolver, DelegationFilter delegationFilter, LanguageVersionSettings languageVersionSettings) {
        this.classOrObject = classOrObject;
        this.ownerDescriptor = ownerDescriptor;
        this.existingMembers = existingMembers;
        this.trace = trace;
        this.memberExtractor = memberExtractor;
        this.typeResolver = typeResolver;
        this.delegationFilter = delegationFilter;
        this.languageVersionSettings = languageVersionSettings;
    }

    private final Collection<T> generateDelegatedMembers() {
        HashSet<T> delegatedMembers = new HashSet<T>();
        for (KtSuperTypeListEntry delegationSpecifier : this.classOrObject.getSuperTypeListEntries()) {
            KtTypeReference typeReference;
            KotlinType delegatedInterfaceType;
            if (!(delegationSpecifier instanceof KtDelegatedSuperTypeEntry) || ((KtDelegatedSuperTypeEntry)delegationSpecifier).getTypeReference() == null || (delegatedInterfaceType = this.typeResolver.resolve(typeReference)) == null || KotlinTypeKt.isError(delegatedInterfaceType)) continue;
            Collection<T> delegatesForInterface = this.generateDelegatesForInterface((Collection)delegatedMembers, delegatedInterfaceType);
            delegatedMembers.addAll(delegatesForInterface);
        }
        return delegatedMembers;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<T> generateDelegatesForInterface(Collection<? extends T> existingDelegates, KotlinType delegatedInterfaceType) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.generateDelegationCandidates(delegatedInterfaceType);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CallableMemberDescriptor candidate = (CallableMemberDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(!DelegationResolver.Companion.isOverridingAnyOf(candidate, this.existingMembers) && !this.checkClashWithOtherDelegatedMember(candidate, existingDelegates))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<T> generateDelegationCandidates(KotlinType delegatedInterfaceType) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getDelegatableMembers(delegatedInterfaceType);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Modality modality;
            void memberDescriptor;
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (((MemberDescriptor)memberDescriptor).getModality() == Modality.ABSTRACT) {
                modality = Modality.OPEN;
            } else {
                Modality modality2 = ((MemberDescriptor)memberDescriptor).getModality();
                modality = modality2;
                Intrinsics.checkNotNullExpressionValue((Object)modality2, "getModality(...)");
            }
            Modality newModality = modality;
            CallableMemberDescriptor callableMemberDescriptor2 = memberDescriptor.newCopyBuilder().setOwner(this.ownerDescriptor).setDispatchReceiverParameter(this.ownerDescriptor.getThisAsReceiverParameter()).setModality(newModality).setVisibility(DescriptorVisibilities.INHERITED).setKind(CallableMemberDescriptor.Kind.DELEGATION).setCopyOverrides(false).build();
            Intrinsics.checkNotNull(callableMemberDescriptor2, "null cannot be cast to non-null type T of org.jetbrains.kotlin.resolve.DelegationResolver");
            collection.add(callableMemberDescriptor2);
        }
        return (List)destination$iv$iv;
    }

    private final boolean checkClashWithOtherDelegatedMember(T candidate, Collection<? extends T> delegatedMembers) {
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = delegatedMembers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                boolean bl = false;
                if (!DelegationResolver.Companion.isOverridableBy(it, (CallableDescriptor)candidate)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        CallableMemberDescriptor alreadyDelegated = v0;
        if (alreadyDelegated != null) {
            if (this.classOrObject instanceof KtClassOrObject) {
                this.trace.report(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED.on((KtClassOrObject)((PsiElement)((Object)this.classOrObject)), (KtClassOrObject)this.classOrObject, alreadyDelegated));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<T> getDelegatableMembers(KotlinType interfaceType) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.memberExtractor.getMembersByType(interfaceType);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(ModalityUtilsKt.isOverridable(descriptor2) && (descriptor2.getKind().isReal() || !this.overridesClassMembersOnly(descriptor2)) && this.delegationFilter.filter(descriptor2, this.languageVersionSettings))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean overridesClassMembersOnly(T $this$overridesClassMembersOnly) {
        boolean bl;
        block3: {
            Set<T> set = DescriptorUtils.getAllOverriddenDeclarations($this$overridesClassMembersOnly);
            Intrinsics.checkNotNullExpressionValue(set, "getAllOverriddenDeclarations(...)");
            Iterable $this$all$iv = set;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                    boolean bl2 = false;
                    if (DescriptorUtils.isClass(it.getContainingDeclaration())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public /* synthetic */ DelegationResolver(KtPureClassOrObject classOrObject, ClassDescriptor ownerDescriptor, Collection existingMembers, BindingTrace trace, MemberExtractor memberExtractor, TypeResolver typeResolver, DelegationFilter delegationFilter, LanguageVersionSettings languageVersionSettings, DefaultConstructorMarker $constructor_marker) {
        this(classOrObject, ownerDescriptor, existingMembers, trace, memberExtractor, typeResolver, delegationFilter, languageVersionSettings);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jk\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\n\"\b\b\u0001\u0010\u0005*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010 \u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b \u0010!J7\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040&2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010$H\u0007\u00a2\u0006\u0004\b'\u0010("}, d2={"Lorg/jetbrains/kotlin/resolve/DelegationResolver$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "T", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "classOrObject", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "ownerDescriptor", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "existingMembers", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;", "memberExtractor", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/lazy/DelegationFilter;", "delegationFilter", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "generateDelegatedMembers", "(Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/Collection;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;Lorg/jetbrains/kotlin/resolve/lazy/DelegationFilter;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)Ljava/util/Collection;", "candidate", "possiblyOverriddenBy", "", "isOverridingAnyOf", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;Ljava/util/Collection;)Z", "memberOne", "memberTwo", "isOverridableBy", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Z", "descriptor", "toInterface", "Lorg/jetbrains/kotlin/types/KotlinType;", "delegateExpressionType", "", "getDelegates", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/types/KotlinType;)Ljava/util/Map;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T extends CallableMemberDescriptor> Collection<T> generateDelegatedMembers(@NotNull KtPureClassOrObject classOrObject, @NotNull ClassDescriptor ownerDescriptor, @NotNull Collection<? extends CallableDescriptor> existingMembers, @NotNull BindingTrace trace, @NotNull MemberExtractor<? extends T> memberExtractor, @NotNull TypeResolver typeResolver, @NotNull DelegationFilter delegationFilter, @NotNull LanguageVersionSettings languageVersionSettings) {
            Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
            Intrinsics.checkNotNullParameter(ownerDescriptor, "ownerDescriptor");
            Intrinsics.checkNotNullParameter(existingMembers, "existingMembers");
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(memberExtractor, "memberExtractor");
            Intrinsics.checkNotNullParameter(typeResolver, "typeResolver");
            Intrinsics.checkNotNullParameter(delegationFilter, "delegationFilter");
            Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
            return new DelegationResolver(classOrObject, ownerDescriptor, existingMembers, trace, memberExtractor, typeResolver, delegationFilter, languageVersionSettings, null).generateDelegatedMembers();
        }

        private final boolean isOverridingAnyOf(CallableMemberDescriptor candidate, Collection<? extends CallableDescriptor> possiblyOverriddenBy) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = possiblyOverriddenBy;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CallableDescriptor it = (CallableDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!Companion.isOverridableBy(it, candidate)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean isOverridableBy(CallableDescriptor memberOne, CallableDescriptor memberTwo) {
            return OverridingUtil.DEFAULT.isOverridableBy(memberOne, memberTwo, null).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<CallableMemberDescriptor, CallableMemberDescriptor> getDelegates(@NotNull ClassDescriptor descriptor2, @NotNull ClassDescriptor toInterface, @Nullable KotlinType delegateExpressionType) {
            KotlinType kotlinType;
            List<CallableMemberDescriptor> delegatedMembers;
            block5: {
                block4: {
                    KotlinType kotlinType2;
                    void $this$filterIsInstance$iv;
                    Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
                    Intrinsics.checkNotNullParameter(toInterface, "toInterface");
                    KotlinType kotlinType3 = delegateExpressionType;
                    if (kotlinType3 != null ? DynamicTypesKt.isDynamic(kotlinType3) : false) {
                        return MapsKt.emptyMap();
                    }
                    Sequence sequence2 = kotlin.collections.CollectionsKt.asSequence(ResolutionScope.DefaultImpls.getContributedDescriptors$default(descriptor2.getDefaultType().getMemberScope(), null, null, 3, null));
                    boolean $i$f$filterIsInstance = false;
                    Sequence sequence3 = SequencesKt.filter($this$filterIsInstance$iv, Companion$getDelegates$$inlined$filterIsInstance$1.INSTANCE);
                    Intrinsics.checkNotNull(sequence3, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                    Iterable<CallableMemberDescriptor> iterable = SequencesKt.asIterable(SequencesKt.filter(sequence3, Companion::getDelegates$lambda$1));
                    MemberComparator memberComparator = MemberComparator.INSTANCE;
                    Intrinsics.checkNotNullExpressionValue(memberComparator, "INSTANCE");
                    delegatedMembers = kotlin.collections.CollectionsKt.sortedWith(iterable, memberComparator);
                    kotlinType = delegateExpressionType;
                    if (kotlinType == null) break block4;
                    KotlinType it = kotlinType2 = kotlinType;
                    boolean bl = false;
                    kotlinType = !TypeUtilsKt.isNothing(it) ? kotlinType2 : null;
                    if (kotlinType != null) break block5;
                }
                SimpleType simpleType2 = toInterface.getDefaultType();
                Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
                kotlinType = simpleType2;
            }
            KotlinType scopeType = kotlinType;
            MemberScope scope2 = scopeType.getMemberScope();
            return CollectionsKt.keysToMapExceptNulls((Iterable)delegatedMembers, arg_0 -> Companion.getDelegates$lambda$6(toInterface, scopeType, scope2, arg_0));
        }

        public static /* synthetic */ Map getDelegates$default(Companion companion, ClassDescriptor classDescriptor, ClassDescriptor classDescriptor2, KotlinType kotlinType, int n, Object object) {
            if ((n & 4) != 0) {
                kotlinType = null;
            }
            return companion.getDelegates(classDescriptor, classDescriptor2, kotlinType);
        }

        private static final boolean getDelegates$lambda$1(CallableMemberDescriptor it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return it.getKind() == CallableMemberDescriptor.Kind.DELEGATION;
        }

        /*
         * WARNING - void declaration
         */
        private static final CallableMemberDescriptor getDelegates$lambda$6(ClassDescriptor $toInterface, KotlinType $scopeType, MemberScope $scope, CallableMemberDescriptor delegatingMember) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            CallableMemberDescriptor it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter(delegatingMember, "delegatingMember");
            Set<CallableDescriptor> set = DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)delegatingMember);
            Intrinsics.checkNotNullExpressionValue(set, "getAllOverriddenDescriptors(...)");
            Iterable iterable = set;
            boolean $i$f$filter = false;
            void var7_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (CallableMemberDescriptor)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getContainingDeclaration(), $toInterface)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CallableMemberDescriptor callableMemberDescriptor;
                void overriddenDescriptor;
                it = (CallableMemberDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (KotlinTypeKt.isError($scopeType)) {
                    callableMemberDescriptor = overriddenDescriptor;
                } else {
                    Object v3;
                    block5: {
                        void $this$firstOrNull$iv;
                        Name name;
                        Intrinsics.checkNotNullExpressionValue(overriddenDescriptor.getName(), "getName(...)");
                        Iterable iterable2 = kotlin.collections.CollectionsKt.plus($scope.getContributedFunctions(name, NoLookupLocation.WHEN_CHECK_OVERRIDES), (Iterable)$scope.getContributedVariables(name, NoLookupLocation.WHEN_CHECK_OVERRIDES));
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            CallableMemberDescriptor it2 = (CallableMemberDescriptor)element$iv;
                            boolean bl2 = false;
                            boolean bl3 = Intrinsics.areEqual(it2, overriddenDescriptor) || OverridingUtil.overrides((CallableDescriptor)it2, (CallableDescriptor)overriddenDescriptor, DescriptorUtilsKt.isTypeRefinementEnabled(DescriptorUtilsKt.getModule(it2)), true);
                            if (!bl3) continue;
                            v3 = element$iv;
                            break block5;
                        }
                        v3 = null;
                    }
                    callableMemberDescriptor = v3;
                }
                collection.add(callableMemberDescriptor);
            }
            List actualDelegates = (List)destination$iv$iv;
            return (CallableMemberDescriptor)kotlin.collections.CollectionsKt.firstOrNull(actualDelegates);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\bf\u0018\u0000*\n\b\u0001\u0010\u0002 \u0001*\u00020\u00012\u00020\u0003J\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H'\u00a2\u0006\u0004\b\u0007\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "T", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "", "getMembersByType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Ljava/util/Collection;"})
    public static interface MemberExtractor<T extends CallableMemberDescriptor> {
        @NotNull
        public Collection<T> getMembersByType(@NotNull KotlinType var1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H'\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;", "", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "reference", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolve", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;)Lorg/jetbrains/kotlin/types/KotlinType;"})
    public static interface TypeResolver {
        @Nullable
        public KotlinType resolve(@NotNull KtTypeReference var1);
    }
}

