/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithNavigationSubstitute;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.synthetic.SyntheticMemberDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\t\u001a\u00020\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0007\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0013J\u0019\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0019\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0019\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/DescriptorToSourceUtils;", "", "<init>", "()V", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "result", "descriptor", "", "collectEffectiveReferencedDescriptors", "(Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)V", "", "getEffectiveReferencedDescriptors", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Ljava/util/Collection;", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "Lcom/intellij/psi/PsiElement;", "getSourceForExtensionReceiverParameterDescriptor", "(Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;)Lcom/intellij/psi/PsiElement;", "getSourceFromDescriptor", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "getSourceFromAnnotation", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;)Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "descriptorToDeclaration", "declarationDescriptor", "Lorg/jetbrains/kotlin/psi/KtFile;", "getContainingFile", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/psi/KtFile;", "findTopLevelParent", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;"})
public final class DescriptorToSourceUtils {
    @NotNull
    public static final DescriptorToSourceUtils INSTANCE = new DescriptorToSourceUtils();

    private DescriptorToSourceUtils() {
    }

    private final void collectEffectiveReferencedDescriptors(List<DeclarationDescriptor> result2, DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof DeclarationDescriptorWithNavigationSubstitute) {
            this.collectEffectiveReferencedDescriptors(result2, ((DeclarationDescriptorWithNavigationSubstitute)descriptor2).getSubstitute());
            return;
        }
        if (descriptor2 instanceof CallableMemberDescriptor) {
            CallableMemberDescriptor.Kind kind = ((CallableMemberDescriptor)descriptor2).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)kind, "getKind(...)");
            CallableMemberDescriptor.Kind kind2 = kind;
            if (kind2 != CallableMemberDescriptor.Kind.DECLARATION && kind2 != CallableMemberDescriptor.Kind.SYNTHESIZED) {
                for (CallableMemberDescriptor callableMemberDescriptor : ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors()) {
                    CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor.getOriginal();
                    Intrinsics.checkNotNullExpressionValue(callableMemberDescriptor2, "getOriginal(...)");
                    this.collectEffectiveReferencedDescriptors(result2, callableMemberDescriptor2);
                }
                return;
            }
            if (descriptor2 instanceof SyntheticMemberDescriptor) {
                this.collectEffectiveReferencedDescriptors(result2, (DeclarationDescriptor)((SyntheticMemberDescriptor)((Object)descriptor2)).getBaseDescriptorForSynthetic());
                return;
            }
        }
        result2.add(descriptor2);
    }

    @NotNull
    public static final Collection<DeclarationDescriptor> getEffectiveReferencedDescriptors(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        ArrayList result2 = new ArrayList();
        List list = result2;
        DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getOriginal(...)");
        INSTANCE.collectEffectiveReferencedDescriptors(list, declarationDescriptor);
        return result2;
    }

    private static final PsiElement getSourceForExtensionReceiverParameterDescriptor(ReceiverParameterDescriptor descriptor2) {
        if (!Intrinsics.areEqual(descriptor2.getSource(), SourceElement.NO_SOURCE) || !(descriptor2.getValue() instanceof ExtensionReceiver)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        CallableDescriptor callableDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
        if (callableDescriptor == null) {
            return null;
        }
        CallableDescriptor containingDeclaration = callableDescriptor;
        SourceElement sourceElement = containingDeclaration.getSource();
        Intrinsics.checkNotNullExpressionValue(sourceElement, "getSource(...)");
        PsiElement psiElement = PsiSourceElementKt.getPsi(sourceElement);
        KtCallableDeclaration ktCallableDeclaration = psiElement instanceof KtCallableDeclaration ? (KtCallableDeclaration)psiElement : null;
        if (ktCallableDeclaration == null) {
            return null;
        }
        KtCallableDeclaration psi = ktCallableDeclaration;
        return psi.getReceiverTypeReference();
    }

    @Nullable
    public static final PsiElement getSourceFromDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        Object object;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (descriptor2 instanceof ReceiverParameterDescriptor) {
            PsiElement psiElement = DescriptorToSourceUtils.getSourceForExtensionReceiverParameterDescriptor((ReceiverParameterDescriptor)descriptor2);
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                return it;
            }
        }
        return (object = descriptor2 instanceof DeclarationDescriptorWithSource ? (DeclarationDescriptorWithSource)descriptor2 : null) != null && (object = object.getSource()) != null ? PsiSourceElementKt.getPsi((SourceElement)object) : null;
    }

    @Nullable
    public static final KtAnnotationEntry getSourceFromAnnotation(@NotNull AnnotationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        PsiElement psiElement = PsiSourceElementKt.getPsi(descriptor2.getSource());
        return psiElement instanceof KtAnnotationEntry ? (KtAnnotationEntry)psiElement : null;
    }

    @Nullable
    public static final PsiElement descriptorToDeclaration(@NotNull DeclarationDescriptor descriptor2) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Collection<DeclarationDescriptor> effectiveReferencedDescriptors = DescriptorToSourceUtils.getEffectiveReferencedDescriptors(descriptor2);
        if (effectiveReferencedDescriptors.size() == 1) {
            Object t = CollectionsKt.firstOrNull((Iterable)effectiveReferencedDescriptors);
            Intrinsics.checkNotNull(t);
            psiElement = DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)t);
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    @Nullable
    public static final KtFile getContainingFile(@NotNull DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter(declarationDescriptor, "declarationDescriptor");
        DeclarationDescriptor declarationDescriptor2 = INSTANCE.findTopLevelParent(declarationDescriptor);
        if (declarationDescriptor2 == null) {
            return null;
        }
        DeclarationDescriptor descriptor2 = declarationDescriptor2;
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (psiElement == null) {
            return null;
        }
        PsiElement declaration = psiElement;
        PsiFile psiFile = declaration.getContainingFile();
        return psiFile instanceof KtFile ? (KtFile)psiFile : null;
    }

    private final DeclarationDescriptor findTopLevelParent(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor descriptor2 = declarationDescriptor;
        if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = descriptor2;
            Intrinsics.checkNotNull(declarationDescriptor2, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor");
            descriptor2 = ((PropertyAccessorDescriptor)declarationDescriptor2).getCorrespondingProperty();
        }
        while (descriptor2 != null && !DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            descriptor2 = descriptor2.getContainingDeclaration();
        }
        return descriptor2;
    }
}

