/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FilePreprocessorExtension;
import org.jetbrains.kotlin.resolve.FilePreprocessorKt;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000fR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/FilePreprocessor;", "", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "", "Lorg/jetbrains/kotlin/resolve/FilePreprocessorExtension;", "extensions", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Ljava/lang/Iterable;)V", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "", "preprocessFile", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "registerFileByPackage", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "Ljava/lang/Iterable;"})
public final class FilePreprocessor {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final Iterable<FilePreprocessorExtension> extensions;

    public FilePreprocessor(@NotNull BindingTrace trace, @NotNull Iterable<? extends FilePreprocessorExtension> extensions) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        this.trace = trace;
        this.extensions = extensions;
    }

    public final void preprocessFile(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        this.registerFileByPackage(file2);
        for (FilePreprocessorExtension extension : this.extensions) {
            extension.preprocessFile(file2);
        }
    }

    private final void registerFileByPackage(KtFile file2) {
        WritableSlice<FqName, Collection<KtFile>> writableSlice = BindingContext.PACKAGE_TO_FILES;
        Intrinsics.checkNotNullExpressionValue(writableSlice, "PACKAGE_TO_FILES");
        FilePreprocessorKt.addElementToSlice(this.trace, writableSlice, file2.getPackageFqName(), file2);
    }
}

