/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\f\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0001%B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u000eJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u00c7\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J0\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c7\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0017\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001e\u001a\u0004\b\u0005\u0010\u000eR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001f\u001a\u0004\b \u0010\u0013R\u0011\u0010\"\u001a\u00020\n8G\u00a2\u0006\u0006\u001a\u0004\b!\u0010\fR\u0013\u0010$\u001a\u0004\u0018\u00010\u00068G\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/ImportPath;", "", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "", "isAllUnder", "Lorg/jetbrains/kotlin/name/Name;", "alias", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;ZLorg/jetbrains/kotlin/name/Name;)V", "", "toString", "()Ljava/lang/String;", "hasAlias", "()Z", "component1", "()Lorg/jetbrains/kotlin/name/FqName;", "component2", "component3", "()Lorg/jetbrains/kotlin/name/Name;", "copy", "(Lorg/jetbrains/kotlin/name/FqName;ZLorg/jetbrains/kotlin/name/Name;)Lorg/jetbrains/kotlin/resolve/ImportPath;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lorg/jetbrains/kotlin/name/FqName;", "getFqName", "Z", "Lorg/jetbrains/kotlin/name/Name;", "getAlias", "getPathStr", "pathStr", "getImportedName", "importedName", "Companion"})
public final class ImportPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FqName fqName;
    private final boolean isAllUnder;
    @Nullable
    private final Name alias;

    public ImportPath(@NotNull FqName fqName2, boolean isAllUnder, @Nullable Name alias) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        this.fqName = fqName2;
        this.isAllUnder = isAllUnder;
        this.alias = alias;
    }

    public /* synthetic */ ImportPath(FqName fqName2, boolean bl, Name name, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            name = null;
        }
        this(fqName2, bl, name);
    }

    @NotNull
    public final FqName getFqName() {
        return this.fqName;
    }

    public final boolean isAllUnder() {
        return this.isAllUnder;
    }

    @Nullable
    public final Name getAlias() {
        return this.alias;
    }

    @NotNull
    public final String getPathStr() {
        return RenderingUtilsKt.render(this.fqName.toUnsafe()) + (this.isAllUnder ? ".*" : "");
    }

    @NotNull
    public String toString() {
        return this.getPathStr() + (this.alias != null ? " as " + this.alias.asString() : "");
    }

    public final boolean hasAlias() {
        return this.alias != null;
    }

    @Nullable
    public final Name getImportedName() {
        if (!this.isAllUnder) {
            Name name = this.alias;
            if (name == null) {
                name = this.fqName.shortName();
            }
            return name;
        }
        return null;
    }

    @NotNull
    public final FqName component1() {
        return this.fqName;
    }

    public final boolean component2() {
        return this.isAllUnder;
    }

    @Nullable
    public final Name component3() {
        return this.alias;
    }

    @NotNull
    public final ImportPath copy(@NotNull FqName fqName2, boolean isAllUnder, @Nullable Name alias) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return new ImportPath(fqName2, isAllUnder, alias);
    }

    public static /* synthetic */ ImportPath copy$default(ImportPath importPath, FqName fqName2, boolean bl, Name name, int n, Object object) {
        if ((n & 1) != 0) {
            fqName2 = importPath.fqName;
        }
        if ((n & 2) != 0) {
            bl = importPath.isAllUnder;
        }
        if ((n & 4) != 0) {
            name = importPath.alias;
        }
        return importPath.copy(fqName2, bl, name);
    }

    public int hashCode() {
        int result2 = this.fqName.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isAllUnder);
        result2 = result2 * 31 + (this.alias == null ? 0 : this.alias.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ImportPath)) {
            return false;
        }
        ImportPath importPath = (ImportPath)other;
        if (!Intrinsics.areEqual(this.fqName, importPath.fqName)) {
            return false;
        }
        if (this.isAllUnder != importPath.isAllUnder) {
            return false;
        }
        return Intrinsics.areEqual(this.alias, importPath.alias);
    }

    public ImportPath(@NotNull FqName fqName2, boolean isAllUnder) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        this(fqName2, isAllUnder, null, 4, null);
    }

    @NotNull
    public static final ImportPath fromString(@NotNull String pathStr) {
        return Companion.fromString(pathStr);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/resolve/ImportPath$Companion;", "", "<init>", "()V", "", "pathStr", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "fromString", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/resolve/ImportPath;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ImportPath fromString(@NotNull String pathStr) {
            ImportPath importPath;
            Intrinsics.checkNotNullParameter(pathStr, "pathStr");
            if (StringsKt.endsWith$default(pathStr, ".*", false, 2, null)) {
                String string2 = pathStr.substring(0, pathStr.length() - 2);
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                importPath = new ImportPath(new FqName(string2), true, null, 4, null);
            } else {
                importPath = new ImportPath(new FqName(pathStr), false, null, 4, null);
            }
            return importPath;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

