/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\bJ\u001f\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0015\u001a\u00020\f8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\f8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0012\u001a\u0004\b\u0019\u0010\u0017R\u001a\u0010\u001a\u001a\u00020\f8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0012\u001a\u0004\b\u001b\u0010\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/InlineClassDescriptorResolver;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "descriptor", "", "isSynthesizedBoxMethod", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;)Z", "isSynthesizedUnboxMethod", "isSynthesizedBoxOrUnboxMethod", "isSpecializedEqualsMethod", "Lorg/jetbrains/kotlin/name/Name;", "name", "isSynthesizedInlineClassMemberWithName", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;Lorg/jetbrains/kotlin/name/Name;)Z", "isSynthesizedInlineClassMember", "BOX_METHOD_NAME", "Lorg/jetbrains/kotlin/name/Name;", "UNBOX_METHOD_NAME", "SPECIALIZED_EQUALS_NAME", "BOXING_VALUE_PARAMETER_NAME", "getBOXING_VALUE_PARAMETER_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME", "getSPECIALIZED_EQUALS_FIRST_PARAMETER_NAME", "SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME", "getSPECIALIZED_EQUALS_SECOND_PARAMETER_NAME"})
public final class InlineClassDescriptorResolver {
    @NotNull
    public static final InlineClassDescriptorResolver INSTANCE = new InlineClassDescriptorResolver();
    @NotNull
    public static final Name BOX_METHOD_NAME;
    @NotNull
    public static final Name UNBOX_METHOD_NAME;
    @NotNull
    public static final Name SPECIALIZED_EQUALS_NAME;
    @NotNull
    private static final Name BOXING_VALUE_PARAMETER_NAME;
    @NotNull
    private static final Name SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME;
    @NotNull
    private static final Name SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME;

    private InlineClassDescriptorResolver() {
    }

    @NotNull
    public final Name getBOXING_VALUE_PARAMETER_NAME() {
        return BOXING_VALUE_PARAMETER_NAME;
    }

    @NotNull
    public final Name getSPECIALIZED_EQUALS_FIRST_PARAMETER_NAME() {
        return SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME;
    }

    @NotNull
    public final Name getSPECIALIZED_EQUALS_SECOND_PARAMETER_NAME() {
        return SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME;
    }

    public static final boolean isSynthesizedBoxMethod(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return INSTANCE.isSynthesizedInlineClassMemberWithName(descriptor2, BOX_METHOD_NAME);
    }

    public static final boolean isSynthesizedUnboxMethod(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return INSTANCE.isSynthesizedInlineClassMemberWithName(descriptor2, UNBOX_METHOD_NAME);
    }

    public static final boolean isSynthesizedBoxOrUnboxMethod(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return INSTANCE.isSynthesizedInlineClassMember(descriptor2) && (Intrinsics.areEqual(descriptor2.getName(), BOX_METHOD_NAME) || Intrinsics.areEqual(descriptor2.getName(), UNBOX_METHOD_NAME));
    }

    public static final boolean isSpecializedEqualsMethod(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return INSTANCE.isSynthesizedInlineClassMemberWithName(descriptor2, SPECIALIZED_EQUALS_NAME);
    }

    private final boolean isSynthesizedInlineClassMemberWithName(CallableMemberDescriptor descriptor2, Name name) {
        return this.isSynthesizedInlineClassMember(descriptor2) && Intrinsics.areEqual(descriptor2.getName(), name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSynthesizedInlineClassMember(CallableMemberDescriptor descriptor2) {
        if (descriptor2.getKind() != CallableMemberDescriptor.Kind.SYNTHESIZED) return false;
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        if (!InlineClassesUtilsKt.isInlineClass(declarationDescriptor)) return false;
        return true;
    }

    static {
        Name name = Name.identifier("box");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
        BOX_METHOD_NAME = name;
        Name name2 = Name.identifier("unbox");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        UNBOX_METHOD_NAME = name2;
        Name name3 = Name.identifier("equals-impl0");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        SPECIALIZED_EQUALS_NAME = name3;
        Name name4 = Name.identifier("v");
        Intrinsics.checkNotNullExpressionValue(name4, "identifier(...)");
        BOXING_VALUE_PARAMETER_NAME = name4;
        Name name5 = Name.identifier("p1");
        Intrinsics.checkNotNullExpressionValue(name5, "identifier(...)");
        SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME = name5;
        Name name6 = Name.identifier("p2");
        Intrinsics.checkNotNullExpressionValue(name6, "identifier(...)");
        SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME = name6;
    }
}

