/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationsChecker;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/resolve/LateinitModifierApplicabilityChecker;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "ktDeclaration", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "descriptor", "", "checkLateinitModifierApplicability", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;)V"})
public final class LateinitModifierApplicabilityChecker {
    @NotNull
    public static final LateinitModifierApplicabilityChecker INSTANCE = new LateinitModifierApplicabilityChecker();

    private LateinitModifierApplicabilityChecker() {
    }

    public final void checkLateinitModifierApplicability(@NotNull BindingTrace trace, @NotNull KtCallableDeclaration ktDeclaration, @NotNull VariableDescriptor descriptor2) {
        String string2;
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(ktDeclaration, "ktDeclaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!ktDeclaration.hasModifier(KtTokens.LATEINIT_KEYWORD)) {
            return;
        }
        VariableDescriptor variableDescriptor = descriptor2;
        if (variableDescriptor instanceof PropertyDescriptor) {
            string2 = "properties";
        } else if (variableDescriptor instanceof LocalVariableDescriptor) {
            string2 = "local variables";
        } else {
            throw new AssertionError((Object)("Should be a property or a local variable: " + descriptor2));
        }
        String variables = string2;
        KotlinType kotlinType = ((VariableDescriptorWithAccessors)descriptor2).getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        KotlinType type2 = kotlinType;
        if (!((VariableDescriptorWithAccessors)descriptor2).isVar()) {
            trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is allowed only on mutable " + variables));
        }
        if (InlineClassesUtilsKt.isInlineClassType(type2)) {
            if (TypeUtilsKt.isUnsignedNumberType(type2)) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables + " of unsigned types"));
            } else {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables + " of inline class types"));
            }
        }
        if (type2.isMarkedNullable()) {
            trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables + " of nullable types"));
        } else if (TypeUtils.isNullableType(type2)) {
            trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables + " of a type with nullable upper bound"));
        }
        if (KotlinBuiltIns.isPrimitiveType(type2)) {
            trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables + " of primitive types"));
        }
        if (ktDeclaration instanceof KtProperty) {
            if (((KtProperty)ktDeclaration).hasDelegateExpression()) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on delegated properties"));
            } else if (((KtProperty)ktDeclaration).hasInitializer()) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables + " with initializer"));
            }
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            boolean hasBackingField;
            boolean isAbstract = ((PropertyDescriptor)descriptor2).getModality() == Modality.ABSTRACT;
            boolean hasDelegateExpressionOrInitializer = ktDeclaration instanceof KtProperty && ((KtProperty)ktDeclaration).hasDelegateExpressionOrInitializer();
            boolean hasAccessorImplementation = DeclarationsChecker.Companion.hasAnyAccessorImplementation((PropertyDescriptor)descriptor2);
            Boolean bl = (Boolean)trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2);
            boolean bl2 = hasBackingField = bl != null ? bl : false;
            if (ktDeclaration instanceof KtParameter) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on primary constructor parameters"));
            }
            if (isAbstract) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on abstract properties"));
            }
            if (!hasDelegateExpressionOrInitializer) {
                if (hasAccessorImplementation) {
                    trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on properties with a custom getter or setter"));
                } else if (!isAbstract && !hasBackingField) {
                    trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on properties without backing field"));
                }
            }
            if (((PropertyDescriptor)descriptor2).getExtensionReceiverParameter() != null) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on extension properties"));
            }
        }
    }
}

