/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorWithInitializerImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.LateinitModifierApplicabilityChecker;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.VariableTypeAndInitializerResolver;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceSession;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J;\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010%\u001a\u00020$2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b%\u0010&J7\u0010/\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010(\u001a\u00020'2\u0006\u0010*\u001a\u00020)2\u0006\u0010,\u001a\u00020+2\u0006\u0010.\u001a\u00020-H\u0002\u00a2\u0006\u0004\b/\u00100J\u0017\u00103\u001a\u00020$2\u0006\u00102\u001a\u000201H\u0002\u00a2\u0006\u0004\b3\u00104J1\u0010:\u001a\u0002072\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010(\u001a\u00020'2\b\u00106\u001a\u0004\u0018\u0001052\u0006\u0010.\u001a\u00020-H\u0001\u00a2\u0006\u0004\b8\u00109J\u001b\u0010<\u001a\u00020$*\u00020;2\u0006\u0010.\u001a\u00020-H\u0002\u00a2\u0006\u0004\b<\u0010=R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010>R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010?R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010@R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010AR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010BR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010CR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010DR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010E"}, d2={"Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;", "", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "identifierChecker", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/VariableTypeAndInitializerResolver;", "variableTypeAndInitializerResolver", "Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;", "delegatedPropertyResolver", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "dataFlowValueFactory", "<init>", "(Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/VariableTypeAndInitializerResolver;Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "typingContext", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "scope", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingFacade;", "facade", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "process", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingFacade;)Lkotlin/Pair;", "context", "descriptor", "ktProperty", "", "checkLocalVariableDeclaration", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;Lorg/jetbrains/kotlin/psi/KtProperty;)V", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "variable", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "inferenceSession", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "resolveLocalVariableDescriptor", "(Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;Lorg/jetbrains/kotlin/resolve/BindingTrace;)Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "Lorg/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl;", "propertyDescriptor", "initializeWithDefaultGetterSetter", "(Lorg/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl;)V", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "Lorg/jetbrains/kotlin/descriptors/impl/LocalVariableDescriptor;", "resolveLocalVariableDescriptorWithType$frontend", "(Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingTrace;)Lorg/jetbrains/kotlin/descriptors/impl/LocalVariableDescriptor;", "resolveLocalVariableDescriptorWithType", "Lorg/jetbrains/kotlin/descriptors/VariableAccessorDescriptor;", "updateAccessorFlagsFromResolvedCallForDelegatedProperty", "(Lorg/jetbrains/kotlin/descriptors/VariableAccessorDescriptor;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "Lorg/jetbrains/kotlin/resolve/VariableTypeAndInitializerResolver;", "Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;"})
public final class LocalVariableResolver {
    @NotNull
    private final ModifiersChecker modifiersChecker;
    @NotNull
    private final IdentifierChecker identifierChecker;
    @NotNull
    private final DataFlowAnalyzer dataFlowAnalyzer;
    @NotNull
    private final AnnotationResolver annotationResolver;
    @NotNull
    private final VariableTypeAndInitializerResolver variableTypeAndInitializerResolver;
    @NotNull
    private final DelegatedPropertyResolver delegatedPropertyResolver;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;

    public LocalVariableResolver(@NotNull ModifiersChecker modifiersChecker, @NotNull IdentifierChecker identifierChecker, @NotNull DataFlowAnalyzer dataFlowAnalyzer2, @NotNull AnnotationResolver annotationResolver, @NotNull VariableTypeAndInitializerResolver variableTypeAndInitializerResolver, @NotNull DelegatedPropertyResolver delegatedPropertyResolver, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkNotNullParameter(modifiersChecker, "modifiersChecker");
        Intrinsics.checkNotNullParameter(identifierChecker, "identifierChecker");
        Intrinsics.checkNotNullParameter(dataFlowAnalyzer2, "dataFlowAnalyzer");
        Intrinsics.checkNotNullParameter(annotationResolver, "annotationResolver");
        Intrinsics.checkNotNullParameter(variableTypeAndInitializerResolver, "variableTypeAndInitializerResolver");
        Intrinsics.checkNotNullParameter(delegatedPropertyResolver, "delegatedPropertyResolver");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(dataFlowValueFactory, "dataFlowValueFactory");
        this.modifiersChecker = modifiersChecker;
        this.identifierChecker = identifierChecker;
        this.dataFlowAnalyzer = dataFlowAnalyzer2;
        this.annotationResolver = annotationResolver;
        this.variableTypeAndInitializerResolver = variableTypeAndInitializerResolver;
        this.delegatedPropertyResolver = delegatedPropertyResolver;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    @NotNull
    public final Pair<KotlinTypeInfo, VariableDescriptor> process(@NotNull KtProperty property, @NotNull ExpressionTypingContext typingContext, @NotNull LexicalScope scope2, @NotNull ExpressionTypingFacade facade) {
        KtPropertyAccessor setter;
        KtPropertyAccessor getter;
        Intrinsics.checkNotNullParameter(property, "property");
        Intrinsics.checkNotNullParameter(typingContext, "typingContext");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(facade, "facade");
        Object Context2 = ((ExpressionTypingContext)typingContext.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceScope(scope2);
        Intrinsics.checkNotNullExpressionValue(Context2, "replaceScope(...)");
        ExpressionTypingContext context = (ExpressionTypingContext)Context2;
        KtTypeReference receiverTypeRef = property.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            context.trace.report(Errors.LOCAL_EXTENSION_PROPERTY.on((KtTypeReference)((PsiElement)receiverTypeRef)));
        }
        if ((getter = property.getGetter()) != null) {
            context.trace.report(Errors.LOCAL_VARIABLE_WITH_GETTER.on((KtPropertyAccessor)((PsiElement)getter)));
        }
        if ((setter = property.getSetter()) != null) {
            context.trace.report(Errors.LOCAL_VARIABLE_WITH_SETTER.on((KtPropertyAccessor)((PsiElement)setter)));
        }
        KtVariableDeclaration ktVariableDeclaration = property;
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
        InferenceSession inferenceSession = context.inferenceSession;
        Intrinsics.checkNotNullExpressionValue(inferenceSession, "inferenceSession");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        VariableDescriptor propertyDescriptor = this.resolveLocalVariableDescriptor(scope2, ktVariableDeclaration, dataFlowInfo, inferenceSession, bindingTrace);
        KtExpression delegateExpression = property.getDelegateExpression();
        if (delegateExpression != null) {
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.LocalDelegatedProperties)) {
                BindingTrace bindingTrace2 = context.trace;
                KtPropertyDelegate ktPropertyDelegate = property.getDelegate();
                Intrinsics.checkNotNull(ktPropertyDelegate);
                bindingTrace2.report(Errors.UNSUPPORTED_FEATURE.on(ktPropertyDelegate, TuplesKt.to(LanguageFeature.LocalDelegatedProperties, this.languageVersionSettings)));
            }
            if (propertyDescriptor instanceof VariableDescriptorWithAccessors) {
                DataFlowInfo dataFlowInfo2 = typingContext.dataFlowInfo;
                Intrinsics.checkNotNullExpressionValue(dataFlowInfo2, "dataFlowInfo");
                VariableDescriptorWithAccessors variableDescriptorWithAccessors = (VariableDescriptorWithAccessors)propertyDescriptor;
                LexicalScope lexicalScope = typingContext.scope;
                Intrinsics.checkNotNullExpressionValue(lexicalScope, "scope");
                InferenceSession inferenceSession2 = typingContext.inferenceSession;
                Intrinsics.checkNotNullExpressionValue(inferenceSession2, "inferenceSession");
                BindingTrace bindingTrace3 = typingContext.trace;
                Intrinsics.checkNotNullExpressionValue(bindingTrace3, "trace");
                this.delegatedPropertyResolver.resolvePropertyDelegate(dataFlowInfo2, property, variableDescriptorWithAccessors, delegateExpression, lexicalScope, inferenceSession2, bindingTrace3);
                VariableAccessorDescriptor variableAccessorDescriptor = ((VariableDescriptorWithAccessors)propertyDescriptor).getGetter();
                if (variableAccessorDescriptor != null) {
                    BindingTrace bindingTrace4 = typingContext.trace;
                    Intrinsics.checkNotNullExpressionValue(bindingTrace4, "trace");
                    this.updateAccessorFlagsFromResolvedCallForDelegatedProperty(variableAccessorDescriptor, bindingTrace4);
                }
                VariableAccessorDescriptor variableAccessorDescriptor2 = ((VariableDescriptorWithAccessors)propertyDescriptor).getSetter();
                if (variableAccessorDescriptor2 != null) {
                    BindingTrace bindingTrace5 = typingContext.trace;
                    Intrinsics.checkNotNullExpressionValue(bindingTrace5, "trace");
                    this.updateAccessorFlagsFromResolvedCallForDelegatedProperty(variableAccessorDescriptor2, bindingTrace5);
                }
            }
        }
        KtExpression initializer = property.getInitializer();
        KotlinTypeInfo typeInfo = null;
        if (initializer != null) {
            KotlinType kotlinType = propertyDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            KotlinType outType = kotlinType;
            KotlinTypeInfo kotlinTypeInfo = facade.getTypeInfo(initializer, (ExpressionTypingContext)context.replaceExpectedType(outType));
            Intrinsics.checkNotNullExpressionValue(kotlinTypeInfo, "getTypeInfo(...)");
            typeInfo = kotlinTypeInfo;
            DataFlowInfo dataFlowInfo3 = typeInfo.getDataFlowInfo();
            KotlinType type2 = typeInfo.getType();
            if (type2 != null) {
                DataFlowValue initializerDataFlowValue = this.dataFlowValueFactory.createDataFlowValue(initializer, type2, context);
                if (!propertyDescriptor.isVar() && initializerDataFlowValue.getCanBeBound()) {
                    context.trace.record(BindingContext.BOUND_INITIALIZER_VALUE, propertyDescriptor, initializerDataFlowValue);
                }
                if (property.getTypeReference() == null) {
                    BindingContext bindingContext = context.trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                    DataFlowValue variableDataFlowValue = this.dataFlowValueFactory.createDataFlowValueForProperty(property, propertyDescriptor, bindingContext, DescriptorUtils.getContainingModuleOrNull(scope2.getOwnerDescriptor()));
                    typeInfo = typeInfo.replaceDataFlowInfo(dataFlowInfo3.assign(variableDataFlowValue, initializerDataFlowValue, this.languageVersionSettings));
                }
            }
        } else {
            typeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        }
        this.checkLocalVariableDeclaration(context, propertyDescriptor, property);
        return new Pair<KotlinTypeInfo, VariableDescriptor>(typeInfo.replaceType(this.dataFlowAnalyzer.checkStatementType(property, context)), propertyDescriptor);
    }

    private final void checkLocalVariableDeclaration(ExpressionTypingContext context, VariableDescriptor descriptor2, KtProperty ktProperty) {
        ExpressionTypingUtils.checkVariableShadowing(context.scope, context.trace, descriptor2);
        this.modifiersChecker.withTrace(context.trace).checkModifiersForLocalDeclaration(ktProperty, descriptor2);
        KtDeclaration ktDeclaration = ktProperty;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        this.identifierChecker.checkDeclaration(ktDeclaration, bindingTrace);
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace2, "trace");
        LateinitModifierApplicabilityChecker.INSTANCE.checkLateinitModifierApplicability(bindingTrace2, ktProperty, descriptor2);
    }

    private final VariableDescriptor resolveLocalVariableDescriptor(LexicalScope scope2, KtVariableDeclaration variable, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession, BindingTrace trace) {
        DeclarationDescriptor containingDeclaration = scope2.getOwnerDescriptor();
        VariableDescriptorWithInitializerImpl result2 = null;
        KotlinType type2 = null;
        if (KtPsiUtil.isScriptDeclaration(variable)) {
            PropertyDescriptorImpl propertyDescriptorImpl = PropertyDescriptorImpl.create(containingDeclaration, this.annotationResolver.resolveAnnotationsWithArguments(scope2, variable.getModifierList(), trace), Modality.FINAL, DescriptorVisibilities.INTERNAL, variable.isVar(), KtPsiUtil.safeName(variable.getName()), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(variable), false, false, false, false, false, variable instanceof KtProperty && ((KtProperty)variable).hasDelegate());
            Intrinsics.checkNotNullExpressionValue(propertyDescriptorImpl, "create(...)");
            PropertyDescriptorImpl propertyDescriptor = propertyDescriptorImpl;
            type2 = this.variableTypeAndInitializerResolver.resolveType(propertyDescriptor, scope2, variable, dataFlowInfo, inferenceSession, trace, true);
            Intrinsics.checkNotNull(containingDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ScriptDescriptor");
            ReceiverParameterDescriptor receiverParameterDescriptor = ((ScriptDescriptor)containingDeclaration).getThisAsReceiverParameter();
            Intrinsics.checkNotNullExpressionValue(receiverParameterDescriptor, "getThisAsReceiverParameter(...)");
            ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
            propertyDescriptor.setType(type2, CollectionsKt.emptyList(), receiverParameter, null, CollectionsKt.emptyList());
            this.initializeWithDefaultGetterSetter(propertyDescriptor);
            trace.record(BindingContext.VARIABLE, variable, propertyDescriptor);
            result2 = propertyDescriptor;
        } else {
            LocalVariableDescriptor variableDescriptor = this.resolveLocalVariableDescriptorWithType$frontend(scope2, variable, null, trace);
            type2 = this.variableTypeAndInitializerResolver.resolveType(variableDescriptor, scope2, variable, dataFlowInfo, inferenceSession, trace, true);
            variableDescriptor.setOutType(type2);
            result2 = variableDescriptor;
        }
        if (inferenceSession instanceof BuilderInferenceSession) {
            ((BuilderInferenceSession)inferenceSession).addExpression(variable);
        }
        this.variableTypeAndInitializerResolver.setConstantForVariableIfNeeded(result2, scope2, variable, dataFlowInfo, type2, inferenceSession, trace);
        ForceResolveUtil.forceResolveAllContents(type2.getAnnotations());
        return result2;
    }

    private final void initializeWithDefaultGetterSetter(PropertyDescriptorImpl propertyDescriptor) {
        PropertySetterDescriptor setter;
        PropertyGetterDescriptorImpl getter = propertyDescriptor.getGetter();
        if (getter == null && !DescriptorVisibilities.isPrivate(propertyDescriptor.getVisibility())) {
            getter = DescriptorFactory.createDefaultGetter(propertyDescriptor, Annotations.Companion.getEMPTY());
            getter.initialize(propertyDescriptor.getType());
        }
        if ((setter = propertyDescriptor.getSetter()) == null && propertyDescriptor.isVar()) {
            setter = DescriptorFactory.createDefaultSetter(propertyDescriptor, Annotations.Companion.getEMPTY(), Annotations.Companion.getEMPTY());
        }
        propertyDescriptor.initialize(getter, setter);
    }

    @NotNull
    public final LocalVariableDescriptor resolveLocalVariableDescriptorWithType$frontend(@NotNull LexicalScope scope2, @NotNull KtVariableDeclaration variable, @Nullable KotlinType type2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(variable, "variable");
        Intrinsics.checkNotNullParameter(trace, "trace");
        boolean hasDelegate = variable instanceof KtProperty && ((KtProperty)variable).hasDelegate();
        boolean hasLateinit = variable.hasModifier(KtTokens.LATEINIT_KEYWORD);
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope2.getOwnerDescriptor(), this.annotationResolver.resolveAnnotationsWithArguments(scope2, variable.getModifierList(), trace), UnderscoreUtilKt.isSingleUnderscore(variable) ? Name.special("<underscore local var>") : KtPsiUtil.safeName(variable.getName()), type2, variable.isVar(), hasDelegate, hasLateinit, KotlinSourceElementKt.toSourceElement(variable));
        trace.record(BindingContext.VARIABLE, variable, variableDescriptor);
        return variableDescriptor;
    }

    private final void updateAccessorFlagsFromResolvedCallForDelegatedProperty(VariableAccessorDescriptor $this$updateAccessorFlagsFromResolvedCallForDelegatedProperty, BindingTrace trace) {
        if ($this$updateAccessorFlagsFromResolvedCallForDelegatedProperty instanceof FunctionDescriptorImpl) {
            FunctionDescriptor resultingDescriptor;
            ResolvedCall resolvedCall2 = (ResolvedCall)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, $this$updateAccessorFlagsFromResolvedCallForDelegatedProperty);
            FunctionDescriptor functionDescriptor = resultingDescriptor = resolvedCall2 != null ? (FunctionDescriptor)resolvedCall2.getResultingDescriptor() : null;
            if (resultingDescriptor != null) {
                ((FunctionDescriptorImpl)((Object)$this$updateAccessorFlagsFromResolvedCallForDelegatedProperty)).setSuspend(resultingDescriptor.isSuspend());
            }
        }
    }
}

