/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\r\u0010\fR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000eR&\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\n0\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;", "", "Lorg/jetbrains/kotlin/storage/StorageManager;", "storageManager", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleDescriptor", "<init>", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "descriptor", "", "getMissingSuperClassifiers", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;)Ljava/util/Set;", "doGetMissingClassifiers", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "missingClassifiers", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;"})
public final class MissingSupertypesResolver {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final MemoizedFunctionToNotNull<ClassifierDescriptor, Set<ClassifierDescriptor>> missingClassifiers;

    public MissingSupertypesResolver(@NotNull StorageManager storageManager, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        this.moduleDescriptor = moduleDescriptor;
        this.missingClassifiers = storageManager.createMemoizedFunction(arg_0 -> MissingSupertypesResolver.missingClassifiers$lambda$0(this, arg_0));
    }

    @NotNull
    public final Set<ClassifierDescriptor> getMissingSuperClassifiers(@NotNull ClassifierDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return (Set)this.missingClassifiers.invoke(descriptor2);
    }

    private final Set<ClassifierDescriptor> doGetMissingClassifiers(ClassifierDescriptor descriptor2) {
        Set missingSuperClassifiers = new LinkedHashSet();
        SimpleType simpleType2 = descriptor2.getDefaultType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
        SimpleType type2 = simpleType2;
        for (KotlinType supertype : TypeUtilsKt.supertypes(type2)) {
            ClassId superTypeClassId;
            ClassDescriptor dependency;
            ClassifierDescriptor supertypeDeclaration = supertype.getConstructor().getDeclarationDescriptor();
            if (!(supertypeDeclaration instanceof ClassDescriptor) || ((ClassDescriptor)supertypeDeclaration).isExpect() || Intrinsics.areEqual(((ClassDescriptor)supertypeDeclaration).getVisibility(), DescriptorVisibilities.LOCAL) || DescriptorUtilsKt.getClassId(supertypeDeclaration) == null || (dependency = FindClassInModuleKt.findClassAcrossModuleDependencies(this.moduleDescriptor, superTypeClassId)) != null && !(dependency instanceof NotFoundClasses.MockClassDescriptor)) continue;
            missingSuperClassifiers.add(supertypeDeclaration);
        }
        return CollectionsKt.toSet(missingSuperClassifiers);
    }

    private static final Set missingClassifiers$lambda$0(MissingSupertypesResolver this$0, ClassifierDescriptor classifier2) {
        Intrinsics.checkNotNullParameter(classifier2, "classifier");
        return this$0.doGetMissingClassifiers(classifier2);
    }
}

