/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.Compatibility;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerHelpersKt;
import org.jetbrains.kotlin.resolve.TargetAllowedPredicate;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ?\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J=\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ-\u0010\"\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00172\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0004\b\"\u0010#J1\u0010$\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b$\u0010%J5\u0010&\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0019\u0010)\u001a\u00020!2\b\u0010(\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0004\b)\u0010*R\u0019\u0010-\u001a\u00070+\u00a2\u0006\u0002\b,8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010."}, d2={"Lorg/jetbrains/kotlin/resolve/ModifierCheckerCore;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "listOwner", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "", "check", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "list", "parentDescriptor", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "actualTargets", "checkModifierList", "(Lorg/jetbrains/kotlin/psi/KtModifierList;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Ljava/util/List;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "Lcom/intellij/lang/ASTNode;", "firstNode", "secondNode", "Lcom/intellij/psi/PsiElement;", "owner", "", "incorrectNodes", "checkCompatibility", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lcom/intellij/lang/ASTNode;Lcom/intellij/lang/ASTNode;Lcom/intellij/psi/PsiElement;Ljava/util/Set;)V", "node", "", "checkTarget", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lcom/intellij/lang/ASTNode;Ljava/util/List;)Z", "checkParent", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lcom/intellij/lang/ASTNode;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)Z", "checkLanguageLevelSupport", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lcom/intellij/lang/ASTNode;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Ljava/util/List;)Z", "d", "isFinalExpectClass", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "MODIFIER_KEYWORD_SET", "Lcom/intellij/psi/tree/TokenSet;"})
public final class ModifierCheckerCore {
    @NotNull
    public static final ModifierCheckerCore INSTANCE = new ModifierCheckerCore();
    @NotNull
    private static final TokenSet MODIFIER_KEYWORD_SET;

    private ModifierCheckerCore() {
    }

    public final void check(@NotNull KtModifierListOwner listOwner, @NotNull BindingTrace trace, @Nullable DeclarationDescriptor descriptor2, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(listOwner, "listOwner");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        if (listOwner instanceof KtDeclarationWithBody) {
            for (KtParameter parameter : ((KtDeclarationWithBody)listOwner).getValueParameters()) {
                if (parameter.hasValOrVar()) continue;
                Intrinsics.checkNotNull(parameter);
                this.check(parameter, trace, (DeclarationDescriptor)trace.get(BindingContext.VALUE_PARAMETER, parameter), languageVersionSettings);
            }
        }
        KtElement ktElement = listOwner;
        ClassDescriptor classDescriptor = descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : null;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        List<KotlinTarget> actualTargets = AnnotationChecker.Companion.getDeclarationSiteActualTargetList(ktElement, classDescriptor, bindingContext);
        KtModifierList ktModifierList = listOwner.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList list = ktModifierList;
        DeclarationDescriptor declarationDescriptor = descriptor2;
        this.checkModifierList(list, trace, declarationDescriptor != null ? declarationDescriptor.getContainingDeclaration() : null, actualTargets, languageVersionSettings);
    }

    private final void checkModifierList(KtModifierList list, BindingTrace trace, DeclarationDescriptor parentDescriptor, List<? extends KotlinTarget> actualTargets, LanguageVersionSettings languageVersionSettings) {
        if (list.getStub() != null) {
            return;
        }
        HashSet incorrectNodes = new HashSet();
        ASTNode[] aSTNodeArray = list.getNode().getChildren(MODIFIER_KEYWORD_SET);
        Intrinsics.checkNotNullExpressionValue(aSTNodeArray, "getChildren(...)");
        ASTNode[] children2 = aSTNodeArray;
        int n = children2.length;
        for (int i = 0; i < n; ++i) {
            ASTNode first2;
            ASTNode second2 = children2[i];
            int n2 = children2.length;
            for (int j = 0; j < n2 && !Intrinsics.areEqual(first2 = children2[j], second2); ++j) {
                Intrinsics.checkNotNull(first2);
                Intrinsics.checkNotNull(second2);
                PsiElement psiElement = list.getOwner();
                Intrinsics.checkNotNullExpressionValue(psiElement, "getOwner(...)");
                this.checkCompatibility(trace, first2, second2, psiElement, incorrectNodes);
            }
            if (incorrectNodes.contains(second2)) continue;
            Intrinsics.checkNotNull(second2);
            if (!this.checkTarget(trace, second2, actualTargets)) {
                ((Collection)incorrectNodes).add(second2);
                continue;
            }
            if (!this.checkParent(trace, second2, parentDescriptor, languageVersionSettings)) {
                ((Collection)incorrectNodes).add(second2);
                continue;
            }
            if (this.checkLanguageLevelSupport(trace, second2, languageVersionSettings, actualTargets)) continue;
            ((Collection)incorrectNodes).add(second2);
        }
    }

    private final void checkCompatibility(BindingTrace trace, ASTNode firstNode, ASTNode secondNode, PsiElement owner, Set<ASTNode> incorrectNodes) {
        IElementType iElementType = firstNode.getElementType();
        Intrinsics.checkNotNull(iElementType, "null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
        KtModifierKeywordToken firstModifier = (KtModifierKeywordToken)iElementType;
        IElementType iElementType2 = secondNode.getElementType();
        Intrinsics.checkNotNull(iElementType2, "null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
        KtModifierKeywordToken secondModifier = (KtModifierKeywordToken)iElementType2;
        Compatibility compatibility = ModifierCheckerHelpersKt.compatibility(firstModifier, secondModifier);
        switch (WhenMappings.$EnumSwitchMapping$0[compatibility.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                if (!incorrectNodes.add(secondNode)) break;
                trace.report(Errors.REPEATED_MODIFIER.on(secondNode.getPsi(), firstModifier));
                break;
            }
            case 3: {
                trace.report(Errors.REDUNDANT_MODIFIER.on(secondNode.getPsi(), secondModifier, firstModifier));
                break;
            }
            case 4: {
                trace.report(Errors.REDUNDANT_MODIFIER.on(firstNode.getPsi(), firstModifier, secondModifier));
                break;
            }
            case 5: {
                trace.report(Errors.DEPRECATED_MODIFIER_PAIR.on(firstNode.getPsi(), firstModifier, secondModifier));
                trace.report(Errors.DEPRECATED_MODIFIER_PAIR.on(secondNode.getPsi(), secondModifier, firstModifier));
                break;
            }
            case 6: 
            case 7: {
                if (compatibility == Compatibility.COMPATIBLE_FOR_CLASSES_ONLY && owner instanceof KtClassOrObject) {
                    return;
                }
                if (incorrectNodes.add(firstNode)) {
                    trace.report(Errors.INCOMPATIBLE_MODIFIERS.on(firstNode.getPsi(), firstModifier, secondModifier));
                }
                if (!incorrectNodes.add(secondNode)) break;
                trace.report(Errors.INCOMPATIBLE_MODIFIERS.on(secondNode.getPsi(), secondModifier, firstModifier));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final boolean checkTarget(BindingTrace trace, ASTNode node, List<? extends KotlinTarget> actualTargets) {
        KotlinTarget it;
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        Set<KotlinTarget> redundantTargets;
        KtModifierKeywordToken modifier;
        block20: {
            Set<KotlinTarget> set;
            Set<KotlinTarget> deprecatedTargets;
            boolean bl2;
            block19: {
                IElementType iElementType = node.getElementType();
                Intrinsics.checkNotNull(iElementType, "null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
                modifier = (KtModifierKeywordToken)iElementType;
                Set<KotlinTarget> set2 = ModifierCheckerHelpersKt.getPossibleTargetMap().get(modifier);
                if (set2 == null) {
                    set2 = SetsKt.emptySet();
                }
                Set<KotlinTarget> possibleTargets = set2;
                Iterable $this$any$iv2 = actualTargets;
                boolean $i$f$any2 = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv2) {
                        KotlinTarget it2 = (KotlinTarget)((Object)element$iv);
                        boolean bl3 = false;
                        if (!possibleTargets.contains((Object)it2)) continue;
                        bl2 = true;
                        break block19;
                    }
                    bl2 = false;
                }
            }
            if (!bl2) {
                PsiElement psiElement = node.getPsi();
                Object object = CollectionsKt.firstOrNull(actualTargets);
                if (object == null || (object = object.getDescription()) == null) {
                    object = "this";
                }
                trace.report(Errors.WRONG_MODIFIER_TARGET.on(psiElement, modifier, (String)object));
                return false;
            }
            Set<KotlinTarget> set3 = ModifierCheckerHelpersKt.getDeprecatedTargetMap().get(modifier);
            if (set3 == null) {
                set3 = deprecatedTargets = SetsKt.emptySet();
            }
            if ((set = ModifierCheckerHelpersKt.getRedundantTargetMap().get(modifier)) == null) {
                set = SetsKt.emptySet();
            }
            redundantTargets = set;
            $this$any$iv = actualTargets;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (KotlinTarget)((Object)element$iv);
                    boolean bl4 = false;
                    if (!deprecatedTargets.contains((Object)it)) continue;
                    bl = true;
                    break block20;
                }
                bl = false;
            }
        }
        if (bl) {
            PsiElement psiElement = node.getPsi();
            Object object = CollectionsKt.firstOrNull(actualTargets);
            if (object == null || (object = object.getDescription()) == null) {
                object = "this";
            }
            trace.report(Errors.DEPRECATED_MODIFIER_FOR_TARGET.on(psiElement, modifier, (String)object));
        } else {
            boolean bl5;
            block21: {
                $this$any$iv = actualTargets;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl5 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (KotlinTarget)((Object)element$iv);
                        boolean bl6 = false;
                        if (!redundantTargets.contains((Object)it)) continue;
                        bl5 = true;
                        break block21;
                    }
                    bl5 = false;
                }
            }
            if (bl5) {
                PsiElement psiElement = node.getPsi();
                Object object = CollectionsKt.firstOrNull(actualTargets);
                if (object == null || (object = object.getDescription()) == null) {
                    object = "this";
                }
                trace.report(Errors.REDUNDANT_MODIFIER_FOR_TARGET.on(psiElement, modifier, (String)object));
            }
        }
        return true;
    }

    private final boolean checkParent(BindingTrace trace, ASTNode node, DeclarationDescriptor parentDescriptor, LanguageVersionSettings languageVersionSettings) {
        boolean bl;
        List<KotlinTarget> actualParents;
        KtModifierKeywordToken modifier;
        block16: {
            List<KotlinTarget> list;
            IElementType iElementType = node.getElementType();
            Intrinsics.checkNotNull(iElementType, "null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
            modifier = (KtModifierKeywordToken)iElementType;
            DeclarationDescriptor declarationDescriptor = parentDescriptor;
            if (declarationDescriptor instanceof ClassDescriptor) {
                ClassKind classKind = ((ClassDescriptor)parentDescriptor).getKind();
                Intrinsics.checkNotNullExpressionValue((Object)classKind, "getKind(...)");
                list = KotlinTarget.Companion.classActualTargets(classKind, ((ClassDescriptor)parentDescriptor).isInner(), ((ClassDescriptor)parentDescriptor).isCompanionObject(), DescriptorUtils.isLocal(parentDescriptor));
            } else {
                list = declarationDescriptor instanceof PropertySetterDescriptor ? KotlinTarget.Companion.getPROPERTY_SETTER_LIST() : (declarationDescriptor instanceof PropertyGetterDescriptor ? KotlinTarget.Companion.getPROPERTY_GETTER_LIST() : (declarationDescriptor instanceof FunctionDescriptor ? KotlinTarget.Companion.getFUNCTION_LIST() : KotlinTarget.Companion.getFILE_LIST()));
            }
            actualParents = list;
            Set<KotlinTarget> deprecatedParents = ModifierCheckerHelpersKt.getDeprecatedParentTargetMap().get(modifier);
            if (deprecatedParents != null) {
                boolean bl2;
                block15: {
                    Iterable $this$any$iv = actualParents;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KotlinTarget it = (KotlinTarget)((Object)element$iv);
                            boolean bl3 = false;
                            if (!deprecatedParents.contains((Object)it)) continue;
                            bl2 = true;
                            break block15;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    PsiElement psiElement = node.getPsi();
                    Object object = CollectionsKt.firstOrNull(actualParents);
                    if (object == null || (object = object.getDescription()) == null) {
                        object = "this scope";
                    }
                    trace.report(Errors.DEPRECATED_MODIFIER_CONTAINING_DECLARATION.on(psiElement, modifier, (String)object));
                    return true;
                }
            }
            if (Intrinsics.areEqual(modifier, KtTokens.PROTECTED_KEYWORD) && this.isFinalExpectClass(parentDescriptor)) {
                trace.report(Errors.WRONG_MODIFIER_CONTAINING_DECLARATION.on(node.getPsi(), modifier, "final expect class"));
            }
            TargetAllowedPredicate targetAllowedPredicate = ModifierCheckerHelpersKt.getPossibleParentTargetPredicateMap().get(modifier);
            if (targetAllowedPredicate == null) {
                return true;
            }
            TargetAllowedPredicate possibleParentPredicate = targetAllowedPredicate;
            Iterable $this$any$iv = actualParents;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl4 = false;
                    if (!possibleParentPredicate.isAllowed(it, languageVersionSettings)) continue;
                    bl = true;
                    break block16;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        PsiElement psiElement = node.getPsi();
        Object object = CollectionsKt.firstOrNull(actualParents);
        if (object == null || (object = object.getDescription()) == null) {
            object = "this scope";
        }
        trace.report(Errors.WRONG_MODIFIER_CONTAINING_DECLARATION.on(psiElement, modifier, (String)object));
        return false;
    }

    private final boolean checkLanguageLevelSupport(BindingTrace trace, ASTNode node, LanguageVersionSettings languageVersionSettings, List<? extends KotlinTarget> actualTargets) {
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNull(iElementType, "null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
        KtModifierKeywordToken modifier = (KtModifierKeywordToken)iElementType;
        List<LanguageFeature> list = ModifierCheckerHelpersKt.getFeatureDependencies().get(modifier);
        if (list == null) {
            return true;
        }
        List<LanguageFeature> dependencies = list;
        block5: for (LanguageFeature dependency : dependencies) {
            Set<KotlinTarget> restrictedTargets = ModifierCheckerHelpersKt.getFeatureDependenciesTargets().get((Object)dependency);
            if (restrictedTargets != null && CollectionsKt.intersect((Iterable)actualTargets, (Iterable)restrictedTargets).isEmpty()) continue;
            if (dependency == LanguageFeature.Coroutines) {
                DiagnosticSink diagnosticSink = trace;
                PsiElement psiElement = node.getPsi();
                Intrinsics.checkNotNullExpressionValue(psiElement, "getPsi(...)");
                CoroutineCallCheckerKt.checkCoroutinesFeature(languageVersionSettings, diagnosticSink, psiElement);
                continue;
            }
            if (dependency == LanguageFeature.InlineClasses && languageVersionSettings.supportsFeature(LanguageFeature.JvmInlineValueClasses)) {
                trace.report(Errors.INLINE_CLASS_DEPRECATED.on(node.getPsi()));
                continue;
            }
            LanguageFeature.State featureSupport = languageVersionSettings.getFeatureSupport(dependency);
            if (dependency == LanguageFeature.MultiPlatformProjects && featureSupport == LanguageFeature.State.DISABLED) {
                trace.report(Errors.NOT_A_MULTIPLATFORM_COMPILATION.on(node.getPsi()));
                continue;
            }
            Pair<LanguageFeature, LanguageVersionSettings> diagnosticData = TuplesKt.to(dependency, languageVersionSettings);
            switch (WhenMappings.$EnumSwitchMapping$1[featureSupport.ordinal()]) {
                case 1: {
                    trace.report(Errors.EXPERIMENTAL_FEATURE_WARNING.on(node.getPsi(), diagnosticData));
                    continue block5;
                }
                case 2: {
                    trace.report(Errors.UNSUPPORTED_FEATURE.on(node.getPsi(), diagnosticData));
                    return false;
                }
                case 3: {
                    continue block5;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return true;
    }

    private final boolean isFinalExpectClass(DeclarationDescriptor d) {
        return d instanceof ClassDescriptor && ModalityUtilsKt.isFinalOrEnum((ClassDescriptor)d) && ((ClassDescriptor)d).isExpect();
    }

    static {
        TokenSet[] tokenSetArray = new TokenSet[2];
        tokenSetArray[0] = KtTokens.SOFT_KEYWORDS;
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.FUN_KEYWORD};
        tokenSetArray[1] = TokenSet.create(iElementTypeArray);
        TokenSet tokenSet = TokenSet.orSet(tokenSetArray);
        Intrinsics.checkNotNullExpressionValue(tokenSet, "orSet(...)");
        MODIFIER_KEYWORD_SET = tokenSet;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Compatibility.values().length];
            try {
                nArray[Compatibility.COMPATIBLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.REPEATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.REDUNDANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.REVERSE_REDUNDANT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.DEPRECATED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.COMPATIBLE_FOR_CLASSES_ONLY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.INCOMPATIBLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LanguageFeature.State.values().length];
            try {
                nArray[LanguageFeature.State.ENABLED_WITH_WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageFeature.State.DISABLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageFeature.State.ENABLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

