/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.utils.DFS;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\b\b\u0000\u0010\u0001*\u00020\u0000*\u00028\u0000H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a#\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\"\b\b\u0000\u0010\u0001*\u00020\u0000*\u00028\u0000H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a=\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\n\"\b\b\u0000\u0010\t*\u00020\b*\b\u0012\u0004\u0012\u00028\u00000\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00000\u000bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000e"}, d2={"Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "D", "", "findTopMostOverriddenDescriptors", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Ljava/util/List;", "", "findOriginalTopMostOverriddenDescriptors", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Ljava/util/Set;", "", "H", "", "Lkotlin/Function1;", "descriptorByHandle", "selectMostSpecificInEachOverridableGroup", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function1;)Ljava/util/Collection;"})
public final class OverridingUtilsKt {
    @NotNull
    public static final <D extends CallableDescriptor> List<D> findTopMostOverriddenDescriptors(@NotNull D $this$findTopMostOverriddenDescriptors) {
        Intrinsics.checkNotNullParameter($this$findTopMostOverriddenDescriptors, "<this>");
        ArrayList arrayList = new ArrayList();
        Object r = DFS.dfs((Collection)CollectionsKt.listOf($this$findTopMostOverriddenDescriptors), OverridingUtilsKt::findTopMostOverriddenDescriptors$lambda$0, new DFS.CollectingNodeHandler<CallableDescriptor, CallableDescriptor, ArrayList<D>>(arrayList){

            public void afterChildren(CallableDescriptor current) {
                Intrinsics.checkNotNullParameter(current, "current");
                if (current.getOverriddenDescriptors().isEmpty()) {
                    ((ArrayList)this.result).add(current);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue(r, "dfs(...)");
        return (List)r;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <D extends CallableDescriptor> Set<D> findOriginalTopMostOverriddenDescriptors(@NotNull D $this$findOriginalTopMostOverriddenDescriptors) {
        void var2_2;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter($this$findOriginalTopMostOverriddenDescriptors, "<this>");
        Iterable iterable = OverridingUtilsKt.findTopMostOverriddenDescriptors($this$findOriginalTopMostOverriddenDescriptors);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            CallableDescriptor callableDescriptor = (CallableDescriptor)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            CallableDescriptor callableDescriptor2 = it.getOriginal();
            Intrinsics.checkNotNull(callableDescriptor2, "null cannot be cast to non-null type D of org.jetbrains.kotlin.resolve.OverridingUtilsKt.findOriginalTopMostOverriddenDescriptors");
            collection.add(callableDescriptor2);
        }
        return (Set)var2_2;
    }

    @NotNull
    public static final <H> Collection<H> selectMostSpecificInEachOverridableGroup(@NotNull Collection<? extends H> $this$selectMostSpecificInEachOverridableGroup, @NotNull Function1<? super H, ? extends CallableDescriptor> descriptorByHandle) {
        Intrinsics.checkNotNullParameter($this$selectMostSpecificInEachOverridableGroup, "<this>");
        Intrinsics.checkNotNullParameter(descriptorByHandle, "descriptorByHandle");
        if ($this$selectMostSpecificInEachOverridableGroup.size() <= 1) {
            return $this$selectMostSpecificInEachOverridableGroup;
        }
        LinkedList<? extends H> queue = new LinkedList<H>($this$selectMostSpecificInEachOverridableGroup);
        SmartSet<Object> result2 = SmartSet.Companion.create();
        while (!((Collection)queue).isEmpty()) {
            Collection<Object> overridableGroup2;
            Object nextHandle = CollectionsKt.first((List)queue);
            SmartSet conflictedHandles = SmartSet.Companion.create();
            Intrinsics.checkNotNullExpressionValue(OverridingUtil.extractMembersOverridableInBothWays(nextHandle, (Collection)queue, descriptorByHandle, arg_0 -> OverridingUtilsKt.selectMostSpecificInEachOverridableGroup$lambda$2(conflictedHandles, arg_0)), "extractMembersOverridableInBothWays(...)");
            if (overridableGroup2.size() == 1 && conflictedHandles.isEmpty()) {
                Object t = CollectionsKt.single((Iterable)overridableGroup2);
                Intrinsics.checkNotNullExpressionValue(t, "single(...)");
                result2.add(t);
                continue;
            }
            H mostSpecific = OverridingUtil.selectMostSpecificMember(overridableGroup2, descriptorByHandle);
            CallableDescriptor mostSpecificDescriptor = descriptorByHandle.invoke(mostSpecific);
            Iterable $this$filterNotTo$iv = overridableGroup2;
            boolean $i$f$filterNotTo = false;
            Iterator iterator2 = $this$filterNotTo$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (OverridingUtil.isMoreSpecific(mostSpecificDescriptor, descriptorByHandle.invoke(it))) continue;
                ((Collection)conflictedHandles).add(element$iv);
            }
            if (!((Collection)conflictedHandles).isEmpty()) {
                result2.addAll(conflictedHandles);
            }
            result2.add(mostSpecific);
        }
        return result2;
    }

    private static final Iterable findTopMostOverriddenDescriptors$lambda$0(CallableDescriptor current) {
        return current.getOverriddenDescriptors();
    }

    private static final Unit selectMostSpecificInEachOverridableGroup$lambda$2(SmartSet $conflictedHandles, Object it) {
        Intrinsics.checkNotNull(it);
        $conflictedHandles.add(it);
        return Unit.INSTANCE;
    }
}

