/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.resolve.FindLoopsInSupertypes;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.utils.DFS;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JY\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\t2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\tH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/SupertypeLoopCheckerImpl;", "Lorg/jetbrains/kotlin/descriptors/SupertypeLoopChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "currentTypeConstructor", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "superTypes", "Lkotlin/Function1;", "", "neighbors", "", "reportLoop", "findLoopsInSupertypesAndDisconnect", "(Lorg/jetbrains/kotlin/types/TypeConstructor;Ljava/util/Collection;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/util/Collection;"})
public final class SupertypeLoopCheckerImpl
implements SupertypeLoopChecker {
    @Override
    @NotNull
    public Collection<KotlinType> findLoopsInSupertypesAndDisconnect(@NotNull TypeConstructor currentTypeConstructor, @NotNull Collection<? extends KotlinType> superTypes2, @NotNull Function1<? super TypeConstructor, ? extends Iterable<? extends KotlinType>> neighbors2, @NotNull Function1<? super KotlinType, Unit> reportLoop) {
        Intrinsics.checkNotNullParameter(currentTypeConstructor, "currentTypeConstructor");
        Intrinsics.checkNotNullParameter(superTypes2, "superTypes");
        Intrinsics.checkNotNullParameter(neighbors2, "neighbors");
        Intrinsics.checkNotNullParameter(reportLoop, "reportLoop");
        DFS.Neighbors<TypeConstructor> graph2 = arg_0 -> SupertypeLoopCheckerImpl.findLoopsInSupertypesAndDisconnect$lambda$1(neighbors2, arg_0);
        SmartList<KotlinType> superTypesToRemove = new SmartList<KotlinType>();
        for (KotlinType superType : superTypes2) {
            ClassifierDescriptor it;
            if (!FindLoopsInSupertypes.access$isReachable(superType.getConstructor(), currentTypeConstructor, graph2)) continue;
            superTypesToRemove.add(superType);
            reportLoop.invoke(superType);
            if (currentTypeConstructor.getDeclarationDescriptor() == null) continue;
            boolean bl = false;
            if (!DescriptorUtilsKt.isCompanionObject(it)) continue;
            SimpleType simpleType2 = it.getDefaultType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
            reportLoop.invoke(simpleType2);
        }
        return superTypesToRemove.isEmpty() ? superTypes2 : (Collection)CollectionsKt.minus((Iterable)superTypes2, (Iterable)superTypesToRemove);
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable findLoopsInSupertypesAndDisconnect$lambda$1(Function1 $neighbors, TypeConstructor node) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull(node);
        Iterable $this$map$iv = (Iterable)$neighbors.invoke(node);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getConstructor());
        }
        return (List)destination$iv$iv;
    }
}

