/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.container.DefaultImplementation;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.UpperBoundViolatedReporter;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@DefaultImplementation(impl=UpperBoundChecker.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJg\u0010\u001b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00162 \b\u0002\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00190\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ-\u0010 \u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b \u0010!J/\u0010$\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b$\u0010%JE\u0010)\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00142\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010(\u001a\u00020'H\u0004\u00a2\u0006\u0004\b)\u0010*R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010+"}, d2={"Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;", "typeChecker", "<init>", "(Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;)V", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "", "checkBoundsOfExpandedTypeAlias", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "argumentReference", "argumentType", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "substitutor", "Lorg/jetbrains/kotlin/psi/KtElement;", "typeAliasUsageElement", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "diagnosticForTypeAliases", "checkBounds", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;Lorg/jetbrains/kotlin/types/TypeSubstitutor;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;)V", "typeReference", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "checkBoundsInSupertype", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "", "reportWarning", "checkBoundsForAbbreviatedSupertype", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/psi/KtTypeReference;Z)V", "bound", "Lorg/jetbrains/kotlin/resolve/UpperBoundViolatedReporter;", "upperBoundViolatedReporter", "checkBound", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtTypeReference;Lorg/jetbrains/kotlin/types/TypeSubstitutor;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/resolve/UpperBoundViolatedReporter;)Z", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;"})
public class UpperBoundChecker {
    @NotNull
    private final KotlinTypeChecker typeChecker;

    public UpperBoundChecker(@NotNull KotlinTypeChecker typeChecker) {
        Intrinsics.checkNotNullParameter(typeChecker, "typeChecker");
        this.typeChecker = typeChecker;
    }

    public void checkBoundsOfExpandedTypeAlias(@NotNull KotlinType type2, @NotNull KtExpression expression, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(trace, "trace");
    }

    public void checkBounds(@Nullable KtTypeReference argumentReference, @NotNull KotlinType argumentType, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor2, @NotNull BindingTrace trace, @Nullable KtElement typeAliasUsageElement, @NotNull DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor> diagnosticForTypeAliases) {
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        Intrinsics.checkNotNullParameter(typeParameterDescriptor, "typeParameterDescriptor");
        Intrinsics.checkNotNullParameter(substitutor2, "substitutor");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(diagnosticForTypeAliases, "diagnosticForTypeAliases");
        if (typeParameterDescriptor.getUpperBounds().isEmpty()) {
            return;
        }
        UpperBoundViolatedReporter diagnosticsReporter = new UpperBoundViolatedReporter(trace, argumentType, typeParameterDescriptor, null, diagnosticForTypeAliases, 8, null);
        for (KotlinType bound : typeParameterDescriptor.getUpperBounds()) {
            Intrinsics.checkNotNull(bound);
            this.checkBound(bound, argumentType, argumentReference, substitutor2, typeAliasUsageElement, diagnosticsReporter);
        }
    }

    public static /* synthetic */ void checkBounds$default(UpperBoundChecker upperBoundChecker, KtTypeReference ktTypeReference, KotlinType kotlinType, TypeParameterDescriptor typeParameterDescriptor, TypeSubstitutor typeSubstitutor2, BindingTrace bindingTrace, KtElement ktElement, DiagnosticFactory3 diagnosticFactory3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkBounds");
        }
        if ((n & 0x20) != 0) {
            ktElement = null;
        }
        if ((n & 0x40) != 0) {
            diagnosticFactory3 = Errors.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION;
        }
        upperBoundChecker.checkBounds(ktTypeReference, kotlinType, typeParameterDescriptor, typeSubstitutor2, bindingTrace, ktElement, diagnosticFactory3);
    }

    public final void checkBoundsInSupertype(@NotNull KtTypeReference typeReference, @NotNull KotlinType type2, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings) {
        boolean bl;
        Intrinsics.checkNotNullParameter(typeReference, "typeReference");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        if (KotlinTypeKt.isError(type2)) {
            return;
        }
        KtTypeElement ktTypeElement = typeReference.getTypeElement();
        if (ktTypeElement == null) {
            return;
        }
        KtTypeElement typeElement = ktTypeElement;
        List<TypeParameterDescriptor> list = type2.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        List<TypeParameterDescriptor> parameters2 = list;
        List<TypeProjection> arguments2 = type2.getArguments();
        boolean bl2 = bl = parameters2.size() == arguments2.size();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        List<KtTypeReference> list2 = typeElement.getTypeArgumentsAsTypes();
        Intrinsics.checkNotNullExpressionValue(list2, "getTypeArgumentsAsTypes(...)");
        List<KtTypeReference> ktTypeArguments = list2;
        if (FlexibleTypesKt.isFlexible(type2) && !DynamicTypesKt.isDynamic(type2)) {
            boolean bl3;
            boolean bl4 = bl3 = ktTypeArguments.size() == 2;
            if (_Assertions.ENABLED && !bl3) {
                boolean $i$a$-assert-UpperBoundChecker$checkBoundsInSupertype$22 = false;
                String $i$a$-assert-UpperBoundChecker$checkBoundsInSupertype$22 = "Flexible type cannot be denoted in Kotlin otherwise than as ft<T1, T2>, but was: " + PsiUtilsKt.getElementTextWithContext(typeReference);
                throw new AssertionError((Object)$i$a$-assert-UpperBoundChecker$checkBoundsInSupertype$22);
            }
            FlexibleType flexibleType = FlexibleTypesKt.asFlexibleType(type2);
            KtTypeReference ktTypeReference = ktTypeArguments.get(0);
            Intrinsics.checkNotNullExpressionValue(ktTypeReference, "get(...)");
            this.checkBoundsInSupertype(ktTypeReference, flexibleType.getLowerBound(), trace, languageVersionSettings);
            KtTypeReference ktTypeReference2 = ktTypeArguments.get(1);
            Intrinsics.checkNotNullExpressionValue(ktTypeReference2, "get(...)");
            this.checkBoundsInSupertype(ktTypeReference2, flexibleType.getUpperBound(), trace, languageVersionSettings);
            return;
        }
        if (type2 instanceof AbbreviatedType) {
            this.checkBoundsForAbbreviatedSupertype(type2, trace, typeReference, ktTypeArguments.size() != arguments2.size() && !languageVersionSettings.supportsFeature(LanguageFeature.ReportMissingUpperBoundsViolatedErrorOnAbbreviationAtSupertypes));
            return;
        }
        if (ktTypeArguments.size() != arguments2.size()) {
            return;
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(type2);
        Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(...)");
        TypeSubstitutor substitutor2 = typeSubstitutor2;
        int n = ((Collection)ktTypeArguments).size();
        for (int i = 0; i < n; ++i) {
            KtTypeReference ktTypeArgument;
            if (ktTypeArguments.get(i) == null) continue;
            KotlinType kotlinType = arguments2.get(i).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            this.checkBoundsInSupertype(ktTypeArgument, kotlinType, trace, languageVersionSettings);
            KotlinType kotlinType2 = arguments2.get(i).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
            TypeParameterDescriptor typeParameterDescriptor = parameters2.get(i);
            Intrinsics.checkNotNullExpressionValue(typeParameterDescriptor, "get(...)");
            UpperBoundChecker.checkBounds$default(this, ktTypeArgument, kotlinType2, typeParameterDescriptor, substitutor2, trace, null, null, 96, null);
        }
    }

    private final void checkBoundsForAbbreviatedSupertype(KotlinType type2, BindingTrace trace, KtTypeReference typeReference, boolean reportWarning) {
        List<TypeParameterDescriptor> list = type2.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        List<TypeParameterDescriptor> parameters2 = list;
        List<TypeProjection> arguments2 = type2.getArguments();
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(type2);
        Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(...)");
        TypeSubstitutor substitutor2 = typeSubstitutor2;
        DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor> diagnostic = reportWarning ? Errors.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION_WARNING : Errors.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION;
        int n = ((Collection)arguments2).size();
        for (int i = 0; i < n; ++i) {
            KotlinType argumentType;
            if (arguments2.get(i).isStarProjection()) continue;
            Intrinsics.checkNotNullExpressionValue(arguments2.get(i).getType(), "getType(...)");
            this.checkBoundsForAbbreviatedSupertype(argumentType, trace, typeReference, reportWarning);
            TypeParameterDescriptor typeParameterDescriptor = parameters2.get(i);
            Intrinsics.checkNotNullExpressionValue(typeParameterDescriptor, "get(...)");
            KtElement ktElement = typeReference;
            Intrinsics.checkNotNull(diagnostic);
            this.checkBounds(null, argumentType, typeParameterDescriptor, substitutor2, trace, ktElement, diagnostic);
        }
    }

    protected final boolean checkBound(@NotNull KotlinType bound, @NotNull KotlinType argumentType, @Nullable KtTypeReference argumentReference, @NotNull TypeSubstitutor substitutor2, @Nullable KtElement typeAliasUsageElement, @NotNull UpperBoundViolatedReporter upperBoundViolatedReporter) {
        Intrinsics.checkNotNullParameter(bound, "bound");
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        Intrinsics.checkNotNullParameter(substitutor2, "substitutor");
        Intrinsics.checkNotNullParameter(upperBoundViolatedReporter, "upperBoundViolatedReporter");
        KotlinType kotlinType = substitutor2.safeSubstitute(bound, Variance.INVARIANT);
        Intrinsics.checkNotNullExpressionValue(kotlinType, "safeSubstitute(...)");
        KotlinType substitutedBound = kotlinType;
        if (!this.typeChecker.isSubtypeOf(argumentType, substitutedBound)) {
            if (argumentReference != null) {
                upperBoundViolatedReporter.report(argumentReference, substitutedBound);
            } else if (typeAliasUsageElement != null && !TypeUtilsKt.containsTypeAliasParameters(substitutedBound) && !TypeUtilsKt.containsTypeAliasParameters(argumentType)) {
                upperBoundViolatedReporter.reportForTypeAliasExpansion(typeAliasUsageElement, substitutedBound);
            }
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean checkBound$default(UpperBoundChecker upperBoundChecker, KotlinType kotlinType, KotlinType kotlinType2, KtTypeReference ktTypeReference, TypeSubstitutor typeSubstitutor2, KtElement ktElement, UpperBoundViolatedReporter upperBoundViolatedReporter, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkBound");
        }
        if ((n & 0x10) != 0) {
            ktElement = null;
        }
        return upperBoundChecker.checkBound(kotlinType, kotlinType2, ktTypeReference, typeSubstitutor2, ktElement, upperBoundViolatedReporter);
    }
}

