/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u001a\b\u0002\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\b\u0012 \b\u0002\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001bR&\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u001cR,\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/UpperBoundViolatedReporter;", "", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "Lorg/jetbrains/kotlin/types/KotlinType;", "argumentType", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "baseDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "diagnosticForTypeAliases", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;)V", "typeArgumentReference", "substitutedBound", "", "report", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lorg/jetbrains/kotlin/types/KotlinType;)V", "callElement", "reportForTypeAliasExpansion", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/types/KotlinType;)V", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;"})
public final class UpperBoundViolatedReporter {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final KotlinType argumentType;
    @NotNull
    private final TypeParameterDescriptor typeParameterDescriptor;
    @NotNull
    private final DiagnosticFactory2<KtTypeReference, KotlinType, KotlinType> baseDiagnostic;
    @NotNull
    private final DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor> diagnosticForTypeAliases;

    public UpperBoundViolatedReporter(@NotNull BindingTrace trace, @NotNull KotlinType argumentType, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull DiagnosticFactory2<KtTypeReference, KotlinType, KotlinType> baseDiagnostic, @NotNull DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor> diagnosticForTypeAliases) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        Intrinsics.checkNotNullParameter(typeParameterDescriptor, "typeParameterDescriptor");
        Intrinsics.checkNotNullParameter(baseDiagnostic, "baseDiagnostic");
        Intrinsics.checkNotNullParameter(diagnosticForTypeAliases, "diagnosticForTypeAliases");
        this.trace = trace;
        this.argumentType = argumentType;
        this.typeParameterDescriptor = typeParameterDescriptor;
        this.baseDiagnostic = baseDiagnostic;
        this.diagnosticForTypeAliases = diagnosticForTypeAliases;
    }

    public /* synthetic */ UpperBoundViolatedReporter(BindingTrace bindingTrace, KotlinType kotlinType, TypeParameterDescriptor typeParameterDescriptor, DiagnosticFactory2 diagnosticFactory2, DiagnosticFactory3 diagnosticFactory3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            diagnosticFactory2 = Errors.UPPER_BOUND_VIOLATED;
        }
        if ((n & 0x10) != 0) {
            diagnosticFactory3 = Errors.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION;
        }
        this(bindingTrace, kotlinType, typeParameterDescriptor, diagnosticFactory2, diagnosticFactory3);
    }

    public final void report(@NotNull KtTypeReference typeArgumentReference, @NotNull KotlinType substitutedBound) {
        Intrinsics.checkNotNullParameter(typeArgumentReference, "typeArgumentReference");
        Intrinsics.checkNotNullParameter(substitutedBound, "substitutedBound");
        ParametrizedDiagnostic<KtTypeReference> parametrizedDiagnostic = this.baseDiagnostic.on((KtTypeReference)((PsiElement)typeArgumentReference), substitutedBound, this.argumentType);
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
        DiagnosticUtilsKt.reportDiagnosticOnce(this.trace, parametrizedDiagnostic);
    }

    public final void reportForTypeAliasExpansion(@NotNull KtElement callElement, @NotNull KotlinType substitutedBound) {
        Intrinsics.checkNotNullParameter(callElement, "callElement");
        Intrinsics.checkNotNullParameter(substitutedBound, "substitutedBound");
        ParametrizedDiagnostic<KtElement> parametrizedDiagnostic = this.diagnosticForTypeAliases.on((KtElement)((PsiElement)callElement), substitutedBound, this.argumentType, this.typeParameterDescriptor);
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
        DiagnosticUtilsKt.reportDiagnosticOnce(this.trace, parametrizedDiagnostic);
    }
}

