/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorWithInitializerImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationReturnTypeSanitizer;
import org.jetbrains.kotlin.resolve.DeclarationSignatureAnonymousTypeTransformer;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.WrappedTypeFactory;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 G2\u00020\u0001:\u0001GB]\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018JG\u0010(\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#2\u0006\u0010&\u001a\u00020%H\u0007\u00a2\u0006\u0004\b(\u0010)JI\u0010*\u001a\u0004\u0018\u00010'2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#2\u0006\u0010&\u001a\u00020%H\u0007\u00a2\u0006\u0004\b*\u0010)JE\u0010.\u001a\u00020-2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010,\u001a\u00020'2\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b.\u0010/JG\u00103\u001a\u00020'2\u0006\u00101\u001a\u0002002\u0006\u0010\u001a\u001a\u0002022\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#2\u0006\u0010&\u001a\u00020%H\u0002\u00a2\u0006\u0004\b3\u00104J?\u00107\u001a\u00020'2\u0006\u0010+\u001a\u00020\u001b2\u0006\u00106\u001a\u0002052\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#2\u0006\u0010&\u001a\u00020%H\u0002\u00a2\u0006\u0004\b7\u00108J\u001f\u0010;\u001a\u00020:2\u0006\u00109\u001a\u00020'2\u0006\u0010&\u001a\u00020%H\u0002\u00a2\u0006\u0004\b;\u0010<R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010=R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010>R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010?R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010@R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010AR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010BR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010CR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010DR\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010ER\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010F"}, d2={"Lorg/jetbrains/kotlin/resolve/VariableTypeAndInitializerResolver;", "", "Lorg/jetbrains/kotlin/storage/StorageManager;", "storageManager", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "expressionTypingServices", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;", "delegatedPropertyResolver", "Lorg/jetbrains/kotlin/types/WrappedTypeFactory;", "wrappedTypeFactory", "Lorg/jetbrains/kotlin/types/TypeApproximator;", "typeApproximator", "Lorg/jetbrains/kotlin/resolve/DeclarationReturnTypeSanitizer;", "declarationReturnTypeSanitizer", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "", "Lorg/jetbrains/kotlin/resolve/DeclarationSignatureAnonymousTypeTransformer;", "anonymousTypeTransformers", "<init>", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;Lorg/jetbrains/kotlin/types/WrappedTypeFactory;Lorg/jetbrains/kotlin/types/TypeApproximator;Lorg/jetbrains/kotlin/resolve/DeclarationReturnTypeSanitizer;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Ljava/lang/Iterable;)V", "Lorg/jetbrains/kotlin/descriptors/impl/VariableDescriptorWithInitializerImpl;", "variableDescriptor", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "scopeForInitializer", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "variable", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "inferenceSession", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "", "local", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolveType", "(Lorg/jetbrains/kotlin/descriptors/impl/VariableDescriptorWithInitializerImpl;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;Lorg/jetbrains/kotlin/resolve/BindingTrace;Z)Lorg/jetbrains/kotlin/types/KotlinType;", "resolveTypeNullable", "scope", "variableType", "", "setConstantForVariableIfNeeded", "(Lorg/jetbrains/kotlin/descriptors/impl/VariableDescriptorWithInitializerImpl;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "resolveDelegatedPropertyType", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;Lorg/jetbrains/kotlin/resolve/BindingTrace;Z)Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "initializer", "resolveInitializerType", "(Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;Lorg/jetbrains/kotlin/resolve/BindingTrace;Z)Lorg/jetbrains/kotlin/types/KotlinType;", "type", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "approximateType", "(Lorg/jetbrains/kotlin/types/KotlinType;Z)Lorg/jetbrains/kotlin/types/UnwrappedType;", "Lorg/jetbrains/kotlin/storage/StorageManager;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;", "Lorg/jetbrains/kotlin/types/WrappedTypeFactory;", "Lorg/jetbrains/kotlin/types/TypeApproximator;", "Lorg/jetbrains/kotlin/resolve/DeclarationReturnTypeSanitizer;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Ljava/lang/Iterable;", "Companion"})
public final class VariableTypeAndInitializerResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final DelegatedPropertyResolver delegatedPropertyResolver;
    @NotNull
    private final WrappedTypeFactory wrappedTypeFactory;
    @NotNull
    private final TypeApproximator typeApproximator;
    @NotNull
    private final DeclarationReturnTypeSanitizer declarationReturnTypeSanitizer;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final Iterable<DeclarationSignatureAnonymousTypeTransformer> anonymousTypeTransformers;

    public VariableTypeAndInitializerResolver(@NotNull StorageManager storageManager, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull TypeResolver typeResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull DelegatedPropertyResolver delegatedPropertyResolver, @NotNull WrappedTypeFactory wrappedTypeFactory, @NotNull TypeApproximator typeApproximator, @NotNull DeclarationReturnTypeSanitizer declarationReturnTypeSanitizer, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Iterable<? extends DeclarationSignatureAnonymousTypeTransformer> anonymousTypeTransformers) {
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        Intrinsics.checkNotNullParameter(expressionTypingServices, "expressionTypingServices");
        Intrinsics.checkNotNullParameter(typeResolver, "typeResolver");
        Intrinsics.checkNotNullParameter(constantExpressionEvaluator, "constantExpressionEvaluator");
        Intrinsics.checkNotNullParameter(delegatedPropertyResolver, "delegatedPropertyResolver");
        Intrinsics.checkNotNullParameter(wrappedTypeFactory, "wrappedTypeFactory");
        Intrinsics.checkNotNullParameter(typeApproximator, "typeApproximator");
        Intrinsics.checkNotNullParameter(declarationReturnTypeSanitizer, "declarationReturnTypeSanitizer");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(anonymousTypeTransformers, "anonymousTypeTransformers");
        this.storageManager = storageManager;
        this.expressionTypingServices = expressionTypingServices;
        this.typeResolver = typeResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.delegatedPropertyResolver = delegatedPropertyResolver;
        this.wrappedTypeFactory = wrappedTypeFactory;
        this.typeApproximator = typeApproximator;
        this.declarationReturnTypeSanitizer = declarationReturnTypeSanitizer;
        this.languageVersionSettings = languageVersionSettings;
        this.anonymousTypeTransformers = anonymousTypeTransformers;
    }

    @NotNull
    public final KotlinType resolveType(@NotNull VariableDescriptorWithInitializerImpl variableDescriptor, @NotNull LexicalScope scopeForInitializer, @NotNull KtVariableDeclaration variable, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession, @NotNull BindingTrace trace, boolean local) {
        Intrinsics.checkNotNullParameter(variableDescriptor, "variableDescriptor");
        Intrinsics.checkNotNullParameter(scopeForInitializer, "scopeForInitializer");
        Intrinsics.checkNotNullParameter(variable, "variable");
        Intrinsics.checkNotNullParameter(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkNotNullParameter(inferenceSession, "inferenceSession");
        Intrinsics.checkNotNullParameter(trace, "trace");
        KotlinType kotlinType = this.resolveTypeNullable(variableDescriptor, scopeForInitializer, variable, dataFlowInfo, inferenceSession, trace, local);
        if (kotlinType != null) {
            KotlinType it = kotlinType;
            boolean bl = false;
            return it;
        }
        if (local) {
            trace.report(Errors.VARIABLE_WITH_NO_TYPE_NO_INITIALIZER.on((KtVariableDeclaration)((PsiElement)variable)));
        }
        String string2 = variableDescriptor.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        return Companion.getTypeForPropertyWithoutReturnType(string2);
    }

    @Nullable
    public final KotlinType resolveTypeNullable(@NotNull VariableDescriptorWithInitializerImpl variableDescriptor, @NotNull LexicalScope scopeForInitializer, @NotNull KtVariableDeclaration variable, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession, @NotNull BindingTrace trace, boolean local) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(variableDescriptor, "variableDescriptor");
        Intrinsics.checkNotNullParameter(scopeForInitializer, "scopeForInitializer");
        Intrinsics.checkNotNullParameter(variable, "variable");
        Intrinsics.checkNotNullParameter(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkNotNullParameter(inferenceSession, "inferenceSession");
        Intrinsics.checkNotNullParameter(trace, "trace");
        KtTypeReference propertyTypeRef = variable.getTypeReference();
        if (propertyTypeRef != null) {
            kotlinType = this.typeResolver.resolveType(scopeForInitializer, propertyTypeRef, trace, true);
        } else if (!variable.hasInitializer() && variable instanceof KtProperty && variableDescriptor instanceof VariableDescriptorWithAccessors && ((KtProperty)variable).hasDelegateExpression()) {
            kotlinType = this.resolveDelegatedPropertyType((KtProperty)variable, (VariableDescriptorWithAccessors)((Object)variableDescriptor), scopeForInitializer, dataFlowInfo, inferenceSession, trace, local);
        } else if (variable.hasInitializer()) {
            if (!local) {
                kotlinType = this.wrappedTypeFactory.createRecursionIntolerantDeferredType(trace, () -> VariableTypeAndInitializerResolver.resolveTypeNullable$lambda$1(variable, trace, this, scopeForInitializer, dataFlowInfo, inferenceSession, local, variableDescriptor));
            } else {
                KtExpression ktExpression = variable.getInitializer();
                Intrinsics.checkNotNull(ktExpression);
                kotlinType = this.resolveInitializerType(scopeForInitializer, ktExpression, dataFlowInfo, inferenceSession, trace, local);
            }
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    public final void setConstantForVariableIfNeeded(@NotNull VariableDescriptorWithInitializerImpl variableDescriptor, @NotNull LexicalScope scope2, @NotNull KtVariableDeclaration variable, @NotNull DataFlowInfo dataFlowInfo, @NotNull KotlinType variableType, @NotNull InferenceSession inferenceSession, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(variableDescriptor, "variableDescriptor");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(variable, "variable");
        Intrinsics.checkNotNullParameter(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkNotNullParameter(variableType, "variableType");
        Intrinsics.checkNotNullParameter(inferenceSession, "inferenceSession");
        Intrinsics.checkNotNullParameter(trace, "trace");
        if (!variable.hasInitializer() || variable.isVar()) {
            return;
        }
        variableDescriptor.setCompileTimeInitializerFactory(() -> VariableTypeAndInitializerResolver.setConstantForVariableIfNeeded$lambda$3(this, variableDescriptor, variableType, variable, scope2, dataFlowInfo, inferenceSession, trace));
    }

    private final KotlinType resolveDelegatedPropertyType(KtProperty property, VariableDescriptorWithAccessors variableDescriptor, LexicalScope scopeForInitializer, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession, BindingTrace trace, boolean local) {
        return this.wrappedTypeFactory.createRecursionIntolerantDeferredType(trace, () -> VariableTypeAndInitializerResolver.resolveDelegatedPropertyType$lambda$5(property, this, variableDescriptor, scopeForInitializer, trace, dataFlowInfo, inferenceSession, local));
    }

    private final KotlinType resolveInitializerType(LexicalScope scope2, KtExpression initializer, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession, BindingTrace trace, boolean local) {
        KotlinType kotlinType = this.expressionTypingServices.safeGetType(scope2, initializer, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, inferenceSession, trace);
        Intrinsics.checkNotNullExpressionValue(kotlinType, "safeGetType(...)");
        KotlinType inferredType = kotlinType;
        UnwrappedType approximatedType = this.approximateType(inferredType, local);
        return this.declarationReturnTypeSanitizer.sanitizeReturnType(approximatedType, this.wrappedTypeFactory, trace, this.languageVersionSettings);
    }

    private final UnwrappedType approximateType(KotlinType type2, boolean local) {
        return this.typeApproximator.approximateDeclarationType(type2, local);
    }

    private static final KotlinType resolveTypeNullable$lambda$1(KtVariableDeclaration $variable, BindingTrace $trace, VariableTypeAndInitializerResolver this$0, LexicalScope $scopeForInitializer, DataFlowInfo $dataFlowInfo, InferenceSession $inferenceSession, boolean $local, VariableDescriptorWithInitializerImpl $variableDescriptor) {
        KtDeclaration ktDeclaration = $variable;
        LanguageVersionSettings languageVersionSettings = this$0.expressionTypingServices.getLanguageVersionSettings();
        Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "getLanguageVersionSettings(...)");
        PreliminaryDeclarationVisitor.Companion.createForDeclaration(ktDeclaration, $trace, languageVersionSettings);
        KtExpression ktExpression = $variable.getInitializer();
        Intrinsics.checkNotNull(ktExpression);
        KotlinType initializerType = this$0.resolveInitializerType($scopeForInitializer, ktExpression, $dataFlowInfo, $inferenceSession, $trace, $local);
        KotlinType kotlinType = DescriptorResolver.transformAnonymousTypeIfNeeded($variableDescriptor, $variable, initializerType, $trace, this$0.anonymousTypeTransformers, this$0.languageVersionSettings);
        Intrinsics.checkNotNullExpressionValue(kotlinType, "transformAnonymousTypeIfNeeded(...)");
        return kotlinType;
    }

    private static final ConstantValue setConstantForVariableIfNeeded$lambda$3$lambda$2(VariableDescriptorWithInitializerImpl $variableDescriptor, KotlinType $variableType, KtVariableDeclaration $variable, VariableTypeAndInitializerResolver this$0, LexicalScope $scope, DataFlowInfo $dataFlowInfo, InferenceSession $inferenceSession, BindingTrace $trace) {
        if (!DescriptorUtils.shouldRecordInitializerForProperty($variableDescriptor, $variableType)) {
            return null;
        }
        KtExpression initializer = $variable.getInitializer();
        ExpressionTypingServices expressionTypingServices = this$0.expressionTypingServices;
        KtExpression ktExpression = initializer;
        Intrinsics.checkNotNull(ktExpression);
        KotlinType kotlinType = expressionTypingServices.safeGetType($scope, ktExpression, $variableType, $dataFlowInfo, $inferenceSession, $trace);
        Intrinsics.checkNotNullExpressionValue(kotlinType, "safeGetType(...)");
        KotlinType initializerType = kotlinType;
        CompileTimeConstant<?> compileTimeConstant = this$0.constantExpressionEvaluator.evaluateExpression(initializer, $trace, initializerType);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant<?> constant = compileTimeConstant;
        if (constant.getUsesNonConstValAsConstant() && $variableDescriptor.isConst()) {
            $trace.report(Errors.NON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION.on((KtExpression)((PsiElement)initializer)));
        }
        return constant.toConstantValue(initializerType);
    }

    private static final NullableLazyValue setConstantForVariableIfNeeded$lambda$3(VariableTypeAndInitializerResolver this$0, VariableDescriptorWithInitializerImpl $variableDescriptor, KotlinType $variableType, KtVariableDeclaration $variable, LexicalScope $scope, DataFlowInfo $dataFlowInfo, InferenceSession $inferenceSession, BindingTrace $trace) {
        return this$0.storageManager.createRecursionTolerantNullableLazyValue(() -> VariableTypeAndInitializerResolver.setConstantForVariableIfNeeded$lambda$3$lambda$2($variableDescriptor, $variableType, $variable, this$0, $scope, $dataFlowInfo, $inferenceSession, $trace), null);
    }

    private static final KotlinType resolveDelegatedPropertyType$lambda$5(KtProperty $property, VariableTypeAndInitializerResolver this$0, VariableDescriptorWithAccessors $variableDescriptor, LexicalScope $scopeForInitializer, BindingTrace $trace, DataFlowInfo $dataFlowInfo, InferenceSession $inferenceSession, boolean $local) {
        KotlinType kotlinType;
        block3: {
            KtExpression delegateExpression;
            block2: {
                KtExpression ktExpression = $property.getDelegateExpression();
                Intrinsics.checkNotNull(ktExpression);
                delegateExpression = ktExpression;
                KotlinType type2 = this$0.delegatedPropertyResolver.resolveDelegateExpression(delegateExpression, $property, $variableDescriptor, $scopeForInitializer, $trace, $dataFlowInfo, $inferenceSession);
                KotlinType getterReturnType = this$0.delegatedPropertyResolver.getGetValueMethodReturnType($variableDescriptor, delegateExpression, type2, $trace, $scopeForInitializer, $dataFlowInfo, $inferenceSession);
                kotlinType = getterReturnType;
                if (kotlinType == null) break block2;
                KotlinType it = kotlinType;
                boolean bl = false;
                UnwrappedType unwrappedType = this$0.approximateType(it, $local);
                kotlinType = unwrappedType;
                if (unwrappedType != null) break block3;
            }
            String[] stringArray = new String[]{delegateExpression.getText()};
            kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.TYPE_FOR_DELEGATION, stringArray);
        }
        KotlinType delegatedType = kotlinType;
        KotlinType kotlinType2 = DescriptorResolver.transformAnonymousTypeIfNeeded($variableDescriptor, $property, delegatedType, $trace, this$0.anonymousTypeTransformers, this$0.languageVersionSettings);
        Intrinsics.checkNotNullExpressionValue(kotlinType2, "transformAnonymousTypeIfNeeded(...)");
        return kotlinType2;
    }

    @NotNull
    public static final SimpleType getTypeForPropertyWithoutReturnType(@NotNull String property) {
        return Companion.getTypeForPropertyWithoutReturnType(property);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/resolve/VariableTypeAndInitializerResolver$Companion;", "", "<init>", "()V", "", "property", "Lorg/jetbrains/kotlin/types/SimpleType;", "getTypeForPropertyWithoutReturnType", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/types/SimpleType;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleType getTypeForPropertyWithoutReturnType(@NotNull String property) {
            Intrinsics.checkNotNullParameter(property, "property");
            String[] stringArray = new String[]{property};
            return ErrorUtils.createErrorType(ErrorTypeKind.RETURN_TYPE_FOR_PROPERTY, stringArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

