/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.bindingContextUtil;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001d\u0010\u0007\u001a\u0004\u0018\u00010\u0006*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0019\u0010\u000b\u001a\u00020\n*\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u000b\u0010\f\u001a!\u0010\u0011\u001a\u00020\u0010*\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u0019\u0010\u0014\u001a\u00020\n*\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0019\u0010\u0016\u001a\u00020\n*\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0015\u001a1\u0010\u001a\u001a\u00020\u0010\"\u000e\b\u0000\u0010\u0018*\b\u0012\u0004\u0012\u00028\u00000\u0017*\b\u0012\u0004\u0012\u00028\u00000\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a#\u0010\u001f\u001a\u00020\u0010*\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u001f\u0010 \u001a\u001b\u0010$\u001a\u00020#*\u00020\u00012\u0006\u0010\"\u001a\u00020!H\u0007\u00a2\u0006\u0004\b$\u0010%\u001a\u001b\u0010&\u001a\u00020#*\u00020\u00012\u0006\u0010\"\u001a\u00020!H\u0007\u00a2\u0006\u0004\b&\u0010%\u001a!\u0010)\u001a\b\u0012\u0004\u0012\u00020(0'*\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b)\u0010*\u001a\u001d\u0010-\u001a\u0004\u0018\u00010,*\u00020+2\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b-\u0010.\u001a\u001d\u0010-\u001a\u0004\u0018\u00010,*\u00020/2\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b-\u00100\u001aC\u00105\u001a\u0004\u0018\u00018\u0000\"\b\b\u0000\u00101*\u00020!*\u00020\t2\"\u00104\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000302\"\n\u0012\u0006\b\u0001\u0012\u00028\u000003H\u0007\u00a2\u0006\u0004\b5\u00106\u001a\u001f\u00107\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b7\u00108\u001a)\u0010:\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\t2\u0006\u00109\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b:\u0010;\u001a\u001d\u0010<\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b<\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "context", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getTargetFunctionDescriptor", "(Lorg/jetbrains/kotlin/psi/KtReturnExpression;Lorg/jetbrains/kotlin/resolve/BindingContext;)Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "getTargetFunction", "(Lorg/jetbrains/kotlin/psi/KtReturnExpression;Lorg/jetbrains/kotlin/resolve/BindingContext;)Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lorg/jetbrains/kotlin/psi/KtElement;", "", "isUsedAsExpression", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/resolve/BindingContext;)Z", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "value", "", "recordUsedAsExpression", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/resolve/BindingTrace;Z)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isUsedAsResultOfLambda", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingContext;)Z", "isUsedAsStatement", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "C", "expression", "recordDataFlowInfo", "(Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "scope", "element", "recordScope", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/psi/KtElement;)V", "Lcom/intellij/psi/PsiElement;", "position", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getDataFlowInfoAfter", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getDataFlowInfoBefore", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getReferenceTargets", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingContext;)Ljava/util/Collection;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getAbbreviatedTypeOrType", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lorg/jetbrains/kotlin/resolve/BindingContext;)Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "(Lorg/jetbrains/kotlin/psi/KtTypeElement;Lorg/jetbrains/kotlin/resolve/BindingContext;)Lorg/jetbrains/kotlin/types/KotlinType;", "T", "", "Ljava/lang/Class;", "parentClasses", "getParentOfTypeCodeFragmentAware", "(Lorg/jetbrains/kotlin/psi/KtElement;[Ljava/lang/Class;)Lcom/intellij/psi/PsiElement;", "getEnclosingDescriptor", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "skipInlineFunctionLiterals", "getEnclosingFunctionDescriptor", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/psi/KtElement;Z)Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isInlineableFunctionLiteral"})
public final class BindingContextUtilsKt {
    @Nullable
    public static final FunctionDescriptor getTargetFunctionDescriptor(@NotNull KtReturnExpression $this$getTargetFunctionDescriptor, @NotNull BindingContext context) {
        Intrinsics.checkNotNullParameter($this$getTargetFunctionDescriptor, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        KtSimpleNameExpression targetLabel = $this$getTargetFunctionDescriptor.getTargetLabel();
        if (targetLabel != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor;
            PsiElement psiElement = (PsiElement)context.get(BindingContext.LABEL_TARGET, targetLabel);
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                simpleFunctionDescriptor = (SimpleFunctionDescriptor)context.get(BindingContext.FUNCTION, it);
            } else {
                simpleFunctionDescriptor = null;
            }
            return simpleFunctionDescriptor;
        }
        PsiElement $this$getNonStrictParentOfType$iv = $this$getTargetFunctionDescriptor;
        boolean $i$f$getNonStrictParentOfType = false;
        DeclarationDescriptor declarationDescriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtDeclarationWithBody.class, false));
        FunctionDescriptor functionDescriptor = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (functionDescriptor == null) {
            return null;
        }
        FunctionDescriptor containingFunctionDescriptor = functionDescriptor;
        return SequencesKt.firstOrNull(SequencesKt.dropWhile(SequencesKt.generateSequence(containingFunctionDescriptor, BindingContextUtilsKt::getTargetFunctionDescriptor$lambda$1), BindingContextUtilsKt::getTargetFunctionDescriptor$lambda$2));
    }

    @Nullable
    public static final KtCallableDeclaration getTargetFunction(@NotNull KtReturnExpression $this$getTargetFunction, @NotNull BindingContext context) {
        KtCallableDeclaration ktCallableDeclaration;
        Intrinsics.checkNotNullParameter($this$getTargetFunction, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        FunctionDescriptor functionDescriptor = BindingContextUtilsKt.getTargetFunctionDescriptor($this$getTargetFunction, context);
        if (functionDescriptor != null) {
            FunctionDescriptor it = functionDescriptor;
            boolean bl = false;
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(it);
            ktCallableDeclaration = psiElement instanceof KtCallableDeclaration ? (KtCallableDeclaration)psiElement : null;
        } else {
            ktCallableDeclaration = null;
        }
        return ktCallableDeclaration;
    }

    public static final boolean isUsedAsExpression(@NotNull KtElement $this$isUsedAsExpression, @NotNull BindingContext context) {
        Intrinsics.checkNotNullParameter($this$isUsedAsExpression, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        Boolean bl = (Boolean)context.get(BindingContext.USED_AS_EXPRESSION, $this$isUsedAsExpression);
        return bl != null ? bl : false;
    }

    public static final void recordUsedAsExpression(@NotNull KtElement $this$recordUsedAsExpression, @NotNull BindingTrace trace, boolean value2) {
        Intrinsics.checkNotNullParameter($this$recordUsedAsExpression, "<this>");
        Intrinsics.checkNotNullParameter(trace, "trace");
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        if (BindingContextUtilsKt.isUsedAsExpression($this$recordUsedAsExpression, bindingContext)) {
            return;
        }
        trace.record(BindingContext.USED_AS_EXPRESSION, $this$recordUsedAsExpression, value2);
    }

    public static final boolean isUsedAsResultOfLambda(@NotNull KtExpression $this$isUsedAsResultOfLambda, @NotNull BindingContext context) {
        Intrinsics.checkNotNullParameter($this$isUsedAsResultOfLambda, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        Object v = context.get(BindingContext.USED_AS_RESULT_OF_LAMBDA, $this$isUsedAsResultOfLambda);
        Intrinsics.checkNotNull(v);
        return (Boolean)v;
    }

    public static final boolean isUsedAsStatement(@NotNull KtExpression $this$isUsedAsStatement, @NotNull BindingContext context) {
        Intrinsics.checkNotNullParameter($this$isUsedAsStatement, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        return !BindingContextUtilsKt.isUsedAsExpression($this$isUsedAsStatement, context);
    }

    public static final <C extends ResolutionContext<C>> void recordDataFlowInfo(@NotNull ResolutionContext<C> $this$recordDataFlowInfo, @Nullable KtExpression expression) {
        Intrinsics.checkNotNullParameter($this$recordDataFlowInfo, "<this>");
        if (expression == null) {
            return;
        }
        KotlinTypeInfo typeInfo = (KotlinTypeInfo)$this$recordDataFlowInfo.trace.get(BindingContext.EXPRESSION_TYPE_INFO, expression);
        if (typeInfo != null) {
            BindingTrace bindingTrace = $this$recordDataFlowInfo.trace;
            DataFlowInfo dataFlowInfo = $this$recordDataFlowInfo.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression, typeInfo.replaceDataFlowInfo(dataFlowInfo));
        } else if (!Intrinsics.areEqual($this$recordDataFlowInfo.dataFlowInfo, DataFlowInfo.Companion.getEMPTY())) {
            BindingTrace bindingTrace = $this$recordDataFlowInfo.trace;
            DataFlowInfo dataFlowInfo = $this$recordDataFlowInfo.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression, TypeInfoFactoryKt.noTypeInfo(dataFlowInfo));
        }
    }

    public static final void recordScope(@NotNull BindingTrace $this$recordScope, @NotNull LexicalScope scope2, @Nullable KtElement element) {
        Intrinsics.checkNotNullParameter($this$recordScope, "<this>");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        if (element != null) {
            HierarchicalScope hierarchicalScope = ScopeUtilsKt.takeSnapshot(scope2);
            Intrinsics.checkNotNull(hierarchicalScope, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.LexicalScope");
            $this$recordScope.record(BindingContext.LEXICAL_SCOPE, element, (LexicalScope)hierarchicalScope);
        }
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfoAfter(@NotNull BindingContext $this$getDataFlowInfoAfter, @NotNull PsiElement position) {
        Intrinsics.checkNotNullParameter($this$getDataFlowInfoAfter, "<this>");
        Intrinsics.checkNotNullParameter(position, "position");
        Iterator<PsiElement> iterator2 = PsiUtilsKt.getParentsWithSelf(position).iterator();
        while (iterator2.hasNext()) {
            PsiElement element = iterator2.next();
            KtExpression ktExpression = element instanceof KtExpression ? (KtExpression)element : null;
            if (ktExpression == null) continue;
            Object it = ktExpression;
            boolean bl = false;
            PsiElement parent2 = it.getParent();
            KotlinTypeInfo kotlinTypeInfo = parent2 instanceof KtQualifiedExpression && Intrinsics.areEqual(it, ((KtQualifiedExpression)parent2).getSelectorExpression()) ? null : (KotlinTypeInfo)$this$getDataFlowInfoAfter.get(BindingContext.EXPRESSION_TYPE_INFO, it);
            if (kotlinTypeInfo == null) continue;
            it = kotlinTypeInfo;
            boolean bl2 = false;
            return ((KotlinTypeInfo)it).getDataFlowInfo();
        }
        return DataFlowInfo.Companion.getEMPTY();
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfoBefore(@NotNull BindingContext $this$getDataFlowInfoBefore, @NotNull PsiElement position) {
        Intrinsics.checkNotNullParameter($this$getDataFlowInfoBefore, "<this>");
        Intrinsics.checkNotNullParameter(position, "position");
        Iterator<PsiElement> iterator2 = PsiUtilsKt.getParentsWithSelf(position).iterator();
        while (iterator2.hasNext()) {
            PsiElement element = iterator2.next();
            KtExpression ktExpression = element instanceof KtExpression ? (KtExpression)element : null;
            if (ktExpression == null) continue;
            Object it = ktExpression;
            boolean bl = false;
            DataFlowInfo dataFlowInfo = (DataFlowInfo)$this$getDataFlowInfoBefore.get(BindingContext.DATA_FLOW_INFO_BEFORE, it);
            if (dataFlowInfo == null) continue;
            it = dataFlowInfo;
            boolean bl2 = false;
            return it;
        }
        return DataFlowInfo.Companion.getEMPTY();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Collection<DeclarationDescriptor> getReferenceTargets(@NotNull KtExpression $this$getReferenceTargets, @NotNull BindingContext context) {
        Collection collection;
        Intrinsics.checkNotNullParameter($this$getReferenceTargets, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        DeclarationDescriptor targetDescriptor = $this$getReferenceTargets instanceof KtReferenceExpression ? (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, $this$getReferenceTargets) : null;
        Object object = targetDescriptor;
        if (object != null) {
            DeclarationDescriptor it = object;
            boolean bl = false;
            List<DeclarationDescriptor> list = CollectionsKt.listOf(it);
            object = list;
            if (list != null) {
                collection = (Collection)object;
                return collection;
            }
        }
        Collection collection2 = (Collection)context.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, $this$getReferenceTargets);
        collection = collection2;
        if (collection2 != null) return collection;
        collection = CollectionsKt.emptyList();
        return collection;
    }

    @Nullable
    public static final KotlinType getAbbreviatedTypeOrType(@NotNull KtTypeReference $this$getAbbreviatedTypeOrType, @NotNull BindingContext context) {
        Intrinsics.checkNotNullParameter($this$getAbbreviatedTypeOrType, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        KotlinType kotlinType = (KotlinType)context.get(BindingContext.ABBREVIATED_TYPE, $this$getAbbreviatedTypeOrType);
        if (kotlinType == null) {
            kotlinType = (KotlinType)context.get(BindingContext.TYPE, $this$getAbbreviatedTypeOrType);
        }
        return kotlinType;
    }

    @Nullable
    public static final KotlinType getAbbreviatedTypeOrType(@NotNull KtTypeElement $this$getAbbreviatedTypeOrType, @NotNull BindingContext context) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter($this$getAbbreviatedTypeOrType, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        PsiElement parent2 = $this$getAbbreviatedTypeOrType.getParent();
        if (parent2 instanceof KtTypeReference) {
            kotlinType = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)parent2, context);
        } else if (parent2 instanceof KtNullableType) {
            KotlinType outerType = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeElement)parent2, context);
            if ($this$getAbbreviatedTypeOrType instanceof KtNullableType) {
                kotlinType = outerType;
            } else {
                KotlinType kotlinType2 = outerType;
                kotlinType = kotlinType2 != null ? TypeUtilsKt.makeNotNullable(kotlinType2) : null;
            }
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    @Nullable
    public static final <T extends PsiElement> T getParentOfTypeCodeFragmentAware(@NotNull KtElement $this$getParentOfTypeCodeFragmentAware, Class<? extends T> ... parentClasses) {
        PsiElement context;
        Intrinsics.checkNotNullParameter($this$getParentOfTypeCodeFragmentAware, "<this>");
        Intrinsics.checkNotNullParameter(parentClasses, "parentClasses");
        T t = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfTypeCodeFragmentAware, Arrays.copyOf(parentClasses, parentClasses.length));
        if (t != null) {
            T it = t;
            boolean bl = false;
            return it;
        }
        PsiFile containingFile = $this$getParentOfTypeCodeFragmentAware.getContainingFile();
        if (containingFile instanceof KtCodeFragment && (context = ((KtCodeFragment)containingFile).getContext()) != null) {
            return PsiTreeUtil.getParentOfType(context, Arrays.copyOf(parentClasses, parentClasses.length));
        }
        return null;
    }

    @NotNull
    public static final DeclarationDescriptor getEnclosingDescriptor(@NotNull BindingContext context, @NotNull KtElement element) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(element, "element");
        Class[] classArray = new Class[]{KtNamedDeclaration.class};
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)BindingContextUtilsKt.getParentOfTypeCodeFragmentAware(element, classArray);
        if (ktNamedDeclaration == null) {
            throw new KotlinExceptionWithAttachments("No parent KtNamedDeclaration for of type " + element.getClass()).withPsiAttachment("element.kt", element);
        }
        KtNamedDeclaration declaration = ktNamedDeclaration;
        if (declaration instanceof KtFunctionLiteral) {
            declarationDescriptor = BindingContextUtilsKt.getEnclosingDescriptor(context, declaration);
        } else {
            declarationDescriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
            if (declarationDescriptor == null) {
                throw new KotlinExceptionWithAttachments("No descriptor for named declaration of type " + declaration.getClass()).withPsiAttachment("declaration.kt", declaration);
            }
        }
        return declarationDescriptor;
    }

    @Nullable
    public static final FunctionDescriptor getEnclosingFunctionDescriptor(@NotNull BindingContext context, @NotNull KtElement element, boolean skipInlineFunctionLiterals) {
        DeclarationDescriptor descriptor2;
        block2: {
            block3: {
                Intrinsics.checkNotNullParameter(context, "context");
                Intrinsics.checkNotNullParameter(element, "element");
                KtElement current = element;
                while (true) {
                    Class[] classArray = new Class[]{KtFunction.class, KtClassOrObject.class};
                    KtTypeParameterListOwner functionOrClass = (KtTypeParameterListOwner)BindingContextUtilsKt.getParentOfTypeCodeFragmentAware(current, classArray);
                    descriptor2 = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionOrClass);
                    if (!(functionOrClass instanceof KtFunction)) break block2;
                    if (!(descriptor2 instanceof FunctionDescriptor)) break block3;
                    if (!skipInlineFunctionLiterals) break;
                    KtTypeParameterListOwner ktTypeParameterListOwner = functionOrClass;
                    KtFunctionLiteral ktFunctionLiteral = ktTypeParameterListOwner instanceof KtFunctionLiteral ? (KtFunctionLiteral)ktTypeParameterListOwner : null;
                    PsiElement psiElement = ktFunctionLiteral != null ? ktFunctionLiteral.getParent() : null;
                    KtExpression ktExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
                    if (ktExpression == null) {
                        ktExpression = functionOrClass;
                    }
                    if (!BindingContextUtilsKt.isInlineableFunctionLiteral(ktExpression, context)) break;
                    current = functionOrClass;
                }
                return (FunctionDescriptor)descriptor2;
            }
            return null;
        }
        return descriptor2 instanceof ClassDescriptor ? (FunctionDescriptor)((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor() : null;
    }

    public static final boolean isInlineableFunctionLiteral(@NotNull KtExpression expression, @NotNull BindingContext context) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(expression instanceof KtLambdaExpression || expression instanceof KtNamedFunction && ((KtNamedFunction)expression).getName() == null)) {
            return false;
        }
        PsiElement wrapper = expression;
        while (Intrinsics.areEqual(KtPsiUtil.deparenthesizeOnce((psiElement = wrapper.getParent()) instanceof KtExpression ? (KtExpression)psiElement : null), wrapper)) {
            Intrinsics.checkNotNullExpressionValue(wrapper.getParent(), "getParent(...)");
        }
        PsiElement psiElement2 = wrapper.getParent();
        KtValueArgument ktValueArgument = psiElement2 instanceof KtValueArgument ? (KtValueArgument)psiElement2 : null;
        if (ktValueArgument == null) {
            return false;
        }
        KtValueArgument argument = ktValueArgument;
        Object object = argument.getParent();
        KtValueArgumentList ktValueArgumentList = object instanceof KtValueArgumentList ? (KtValueArgumentList)object : null;
        PsiElement psiElement3 = (ktValueArgumentList != null ? (KtElementImplStub)ktValueArgumentList : (KtElementImplStub)argument).getParent();
        KtCallExpression ktCallExpression = psiElement3 instanceof KtCallExpression ? (KtCallExpression)psiElement3 : null;
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression call2 = ktCallExpression;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(call2, context);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        object = resolvedCall3.getResultingDescriptor();
        FunctionDescriptor functionDescriptor = object instanceof FunctionDescriptor ? (FunctionDescriptor)object : null;
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor descriptor2 = functionDescriptor;
        if (descriptor2.isInline()) {
            ValueParameterDescriptor valueParameterDescriptor;
            Object v7;
            block13: {
                Iterable iterable = resolvedCall3.getValueArguments().entrySet();
                for (Object t : iterable) {
                    boolean bl;
                    block12: {
                        Map.Entry entry = (Map.Entry)t;
                        boolean bl2 = false;
                        ResolvedValueArgument valueArgument = (ResolvedValueArgument)entry.getValue();
                        List<ValueArgument> list = valueArgument.getArguments();
                        Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                ValueArgument it = (ValueArgument)element$iv;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual(it.asElement(), argument)) continue;
                                bl = true;
                                break block12;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    v7 = t;
                    break block13;
                }
                v7 = null;
            }
            object = v7;
            if (object == null || (valueParameterDescriptor = (ValueParameterDescriptor)object.getKey()) == null) {
                return false;
            }
            ValueParameterDescriptor parameter = valueParameterDescriptor;
            return !parameter.isNoinline() && !parameter.isCrossinline();
        }
        return false;
    }

    private static final FunctionDescriptor getTargetFunctionDescriptor$lambda$1(FunctionDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return DescriptorUtils.getParentOfType(it, FunctionDescriptor.class);
    }

    private static final boolean getTargetFunctionDescriptor$lambda$2(FunctionDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof AnonymousFunctionDescriptor;
    }
}

