/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.AstLoadingFilter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolveUtilKt;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallExpressionElement;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassifierQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.PackageQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 g2\u00020\u0001:\u0001gBO\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJG\u0010'\u001a\u0016\u0012\u0004\u0012\u00020$\u0012\f\u0012\n\u0012\u0004\u0012\u00020&\u0018\u00010%0#2\u0006\u0010\u001c\u001a\u00020\u001b2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b'\u0010(JA\u00101\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0006\u0012\u0004\u0018\u0001000#2\u0006\u0010*\u001a\u00020)2\b\u0010,\u001a\u0004\u0018\u00010+2\b\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010\u001e\u001a\u00020/H\u0002\u00a2\u0006\u0004\b1\u00102J3\u00104\u001a\u0002032\u0006\u0010*\u001a\u00020)2\b\u0010,\u001a\u0004\u0018\u00010+2\b\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010\u001e\u001a\u00020/H\u0007\u00a2\u0006\u0004\b4\u00105J;\u00104\u001a\u0002032\u0006\u0010*\u001a\u00020)2\b\u0010,\u001a\u0004\u0018\u00010+2\b\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010\u001e\u001a\u00020/2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b4\u00106J\u001f\u00109\u001a\u0002032\u0006\u00108\u001a\u0002072\u0006\u0010\u001e\u001a\u00020/H\u0007\u00a2\u0006\u0004\b9\u0010:J;\u0010;\u001a\u0002032\u0006\u00108\u001a\u0002072\b\u0010,\u001a\u0004\u0018\u00010+2\b\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010\u001e\u001a\u00020/2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b;\u0010<J!\u0010@\u001a\b\u0012\u0004\u0012\u00020?0>*\u00020=2\u0006\u0010\u001e\u001a\u00020/H\u0002\u00a2\u0006\u0004\b@\u0010AJ-\u0010G\u001a\b\u0012\u0004\u0012\u00020F0E2\u0006\u0010\u001e\u001a\u00020/2\u0006\u0010B\u001a\u00020)2\u0006\u0010D\u001a\u00020CH\u0002\u00a2\u0006\u0004\bG\u0010HJ;\u0010K\u001a\u0002032\u0006\u0010,\u001a\u00020+2\b\u0010.\u001a\u0004\u0018\u00010-2\b\u0010J\u001a\u0004\u0018\u00010I2\u0006\u0010\u001e\u001a\u00020/2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\bK\u0010LJ'\u0010N\u001a\u0002032\u0006\u0010,\u001a\u00020+2\u0006\u0010M\u001a\u00020?2\u0006\u0010\u001e\u001a\u00020/H\u0002\u00a2\u0006\u0004\bN\u0010OJ'\u0010R\u001a\u0002032\u0006\u0010P\u001a\u00020=2\u0006\u0010Q\u001a\u0002032\u0006\u0010\u001e\u001a\u00020/H\u0002\u00a2\u0006\u0004\bR\u0010SJ'\u0010U\u001a\u00020\u00182\u0006\u0010P\u001a\u00020=2\u0006\u0010T\u001a\u0002032\u0006\u0010\u001e\u001a\u00020/H\u0002\u00a2\u0006\u0004\bU\u0010VJ\u001f\u0010W\u001a\u0002032\u0006\u0010B\u001a\u00020=2\u0006\u0010\u001e\u001a\u00020/H\u0007\u00a2\u0006\u0004\bW\u0010XJ)\u0010[\u001a\u00020\u00182\u0006\u0010Z\u001a\u00020Y2\b\u0010J\u001a\u0004\u0018\u00010I2\u0006\u0010\u001e\u001a\u00020/H\u0002\u00a2\u0006\u0004\b[\u0010\\R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010]R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010^R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010_R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010`R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010aR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010bR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010cR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010dR\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010eR\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0083.\u00a2\u0006\u0006\n\u0004\b\u0017\u0010f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver;", "", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "callResolver", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "argumentTypeResolver", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "builtIns", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "qualifiedExpressionResolver", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "kotlinTypeRefiner", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/CallResolver;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;)V", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "expressionTypingServices", "", "setExpressionTypingServices", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;)V", "Lorg/jetbrains/kotlin/psi/Call;", "call", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/CheckArgumentTypesMode;", "checkArguments", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "initialDataFlowInfoForArguments", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getResolvedCallForFunction", "(Lorg/jetbrains/kotlin/psi/Call;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lorg/jetbrains/kotlin/resolve/calls/context/CheckArgumentTypesMode;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;)Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "nameExpression", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "receiver", "Lcom/intellij/lang/ASTNode;", "callOperationNode", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getVariableType", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;Lcom/intellij/lang/ASTNode;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)Lkotlin/Pair;", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "getSimpleNameExpressionTypeInfo", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;Lcom/intellij/lang/ASTNode;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;Lcom/intellij/lang/ASTNode;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;)Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callExpression", "getCallExpressionTypeInfo", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "getCallExpressionTypeInfoWithoutFinalTypeCheck", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;Lcom/intellij/lang/ASTNode;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;)Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "", "Lorg/jetbrains/kotlin/resolve/calls/CallExpressionElement;", "elementChain", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)Ljava/util/List;", "expression", "Lorg/jetbrains/kotlin/resolve/calls/context/TemporaryTraceAndCache;", "traceAndCache", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "resolveSimpleName", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/resolve/calls/context/TemporaryTraceAndCache;)Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "selectorExpression", "getUnsafeSelectorTypeInfo", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;Lcom/intellij/lang/ASTNode;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;)Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "element", "getSafeOrUnsafeSelectorTypeInfo", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;Lorg/jetbrains/kotlin/resolve/calls/CallExpressionElement;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "qualified", "selectorTypeInfo", "checkSelectorTypeInfo", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "resultTypeInfo", "recordResultTypeInfo", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)V", "getQualifiedExpressionTypeInfo", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "qualifier", "resolveDeferredReceiverInQualifiedExpression", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)V", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "Companion"})
public final class CallExpressionResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final DataFlowAnalyzer dataFlowAnalyzer;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    private final KotlinTypeRefiner kotlinTypeRefiner;
    private ExpressionTypingServices expressionTypingServices;

    public CallExpressionResolver(@NotNull CallResolver callResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer2, @NotNull KotlinBuiltIns builtIns, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(callResolver, "callResolver");
        Intrinsics.checkNotNullParameter(constantExpressionEvaluator, "constantExpressionEvaluator");
        Intrinsics.checkNotNullParameter(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkNotNullParameter(dataFlowAnalyzer2, "dataFlowAnalyzer");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(qualifiedExpressionResolver, "qualifiedExpressionResolver");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(dataFlowValueFactory, "dataFlowValueFactory");
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        this.callResolver = callResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.argumentTypeResolver = argumentTypeResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer2;
        this.builtIns = builtIns;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.kotlinTypeRefiner = kotlinTypeRefiner;
    }

    public final void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        Intrinsics.checkNotNullParameter(expressionTypingServices, "expressionTypingServices");
        this.expressionTypingServices = expressionTypingServices;
    }

    private final Pair<Boolean, ResolvedCall<FunctionDescriptor>> getResolvedCallForFunction(Call call2, ResolutionContext<?> context, CheckArgumentTypesMode checkArguments, DataFlowInfo initialDataFlowInfoForArguments) {
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.callResolver.resolveFunctionCall(BasicCallResolutionContext.create(context, call2, checkArguments, new DataFlowInfoForArgumentsImpl(initialDataFlowInfoForArguments, call2)));
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, "resolveFunctionCall(...)");
        OverloadResolutionResults<FunctionDescriptor> results = overloadResolutionResults;
        return !results.isNothing() ? new Pair<Boolean, ResolvedCall<FunctionDescriptor>>(true, OverloadResolutionResultsUtil.getResultingCall(results, context)) : new Pair<Boolean, Object>(false, null);
    }

    private final Pair<Boolean, KotlinType> getVariableType(KtSimpleNameExpression nameExpression, Receiver receiver, ASTNode callOperationNode, ExpressionTypingContext context) {
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as local variable or property", nameExpression);
        Call call2 = CallMaker.makePropertyCall(receiver, callOperationNode, nameExpression);
        Intrinsics.checkNotNullExpressionValue(call2, "makePropertyCall(...)");
        Call call3 = call2;
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context.replaceTraceAndCache(temporaryForVariable), call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        Intrinsics.checkNotNullExpressionValue(basicCallResolutionContext, "create(...)");
        BasicCallResolutionContext contextForVariable = basicCallResolutionContext;
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.callResolver.resolveSimpleProperty(contextForVariable);
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, "resolveSimpleProperty(...)");
        OverloadResolutionResults<VariableDescriptor> resolutionResult = overloadResolutionResults;
        boolean isLHSOfDot = KtPsiUtil.isLHSOfDot(nameExpression);
        if (!resolutionResult.isNothing() && resolutionResult.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER) {
            boolean isQualifier;
            boolean bl = isQualifier = isLHSOfDot && resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject;
            if (!isQualifier) {
                temporaryForVariable.commit();
                return new Pair<Boolean, Object>(true, (resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null));
            }
        }
        temporaryForVariable.commit();
        return new Pair<Boolean, Object>(!resolutionResult.isNothing(), (resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null));
    }

    @NotNull
    public final KotlinTypeInfo getSimpleNameExpressionTypeInfo(@NotNull KtSimpleNameExpression nameExpression, @Nullable Receiver receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkNotNullParameter(nameExpression, "nameExpression");
        Intrinsics.checkNotNullParameter(context, "context");
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
        return this.getSimpleNameExpressionTypeInfo(nameExpression, receiver, callOperationNode, context, dataFlowInfo);
    }

    private final KotlinTypeInfo getSimpleNameExpressionTypeInfo(KtSimpleNameExpression nameExpression, Receiver receiver, ASTNode callOperationNode, ExpressionTypingContext context, DataFlowInfo initialDataFlowInfoForArguments) {
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as variable", nameExpression);
        Object Context2 = context.replaceTraceAndCache(temporaryForVariable);
        Intrinsics.checkNotNullExpressionValue(Context2, "replaceTraceAndCache(...)");
        Pair<Boolean, KotlinType> pair = this.getVariableType(nameExpression, receiver, callOperationNode, (ExpressionTypingContext)Context2);
        boolean notNothing = pair.component1();
        KotlinType type2 = pair.component2();
        if (notNothing) {
            temporaryForVariable.commit();
            return TypeInfoFactoryKt.createTypeInfo(type2, initialDataFlowInfoForArguments);
        }
        Call call2 = CallMaker.makeCall(nameExpression, receiver, callOperationNode, nameExpression, CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(call2, "makeCall(...)");
        Call call3 = call2;
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context, "trace to resolve as function", nameExpression);
        Object Context3 = context.replaceTraceAndCache(temporaryForFunction);
        Intrinsics.checkNotNullExpressionValue(Context3, "replaceTraceAndCache(...)");
        ExpressionTypingContext newContext = (ExpressionTypingContext)Context3;
        Pair<Boolean, ResolvedCall<FunctionDescriptor>> pair2 = this.getResolvedCallForFunction(call3, newContext, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, initialDataFlowInfoForArguments);
        boolean resolveResult = pair2.component1();
        ResolvedCall<FunctionDescriptor> resolvedCall2 = pair2.component2();
        if (resolveResult) {
            FunctionDescriptor functionDescriptor;
            ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
            FunctionDescriptor functionDescriptor2 = functionDescriptor = resolvedCall3 != null ? resolvedCall3.getResultingDescriptor() : null;
            if (!(functionDescriptor instanceof ConstructorDescriptor)) {
                temporaryForFunction.commit();
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on((KtExpression)((PsiElement)nameExpression), nameExpression, hasValueParameters));
                FunctionDescriptor functionDescriptor3 = functionDescriptor;
                return TypeInfoFactoryKt.createTypeInfo(functionDescriptor3 != null ? functionDescriptor3.getReturnType() : null, context);
            }
        }
        TemporaryTraceAndCache temporaryForQualifier = TemporaryTraceAndCache.create(context, "trace to resolve as qualifier", nameExpression);
        Object Context4 = context.replaceTraceAndCache(temporaryForQualifier);
        Intrinsics.checkNotNullExpressionValue(Context4, "replaceTraceAndCache(...)");
        ExpressionTypingContext contextForQualifier = (ExpressionTypingContext)Context4;
        Qualifier qualifier = this.qualifiedExpressionResolver.resolveNameExpressionAsQualifierForDiagnostics(nameExpression, receiver, contextForQualifier);
        if (qualifier != null) {
            Qualifier it = qualifier;
            boolean bl = false;
            QualifiedExpressionResolveUtilKt.resolveQualifierAsStandaloneExpression(it, contextForQualifier);
            temporaryForQualifier.commit();
        } else {
            temporaryForVariable.commit();
        }
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    @NotNull
    public final KotlinTypeInfo getCallExpressionTypeInfo(@NotNull KtCallExpression callExpression, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(context, "context");
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
        KotlinTypeInfo typeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck(callExpression, null, null, context, dataFlowInfo);
        if (context.contextDependency == ContextDependency.INDEPENDENT) {
            this.dataFlowAnalyzer.checkType(typeInfo.getType(), (KtExpression)callExpression, (ResolutionContext)context);
        }
        return typeInfo;
    }

    private final KotlinTypeInfo getCallExpressionTypeInfoWithoutFinalTypeCheck(KtCallExpression callExpression, Receiver receiver, ASTNode callOperationNode, ExpressionTypingContext context, DataFlowInfo initialDataFlowInfoForArguments) {
        Call call2 = CallMaker.makeCall(receiver, callOperationNode, callExpression);
        Intrinsics.checkNotNullExpressionValue(call2, "makeCall(...)");
        Call call3 = call2;
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context, "trace to resolve as function call", callExpression);
        Object Context2 = context.replaceTraceAndCache(temporaryForFunction);
        Intrinsics.checkNotNullExpressionValue(Context2, "replaceTraceAndCache(...)");
        Pair<Boolean, ResolvedCall<FunctionDescriptor>> pair = this.getResolvedCallForFunction(call3, (ResolutionContext<?>)Context2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, initialDataFlowInfoForArguments);
        boolean resolveResult = pair.component1();
        ResolvedCall<FunctionDescriptor> resolvedCall2 = pair.component2();
        if (resolveResult) {
            DataFlowInfo resultFlowInfo;
            ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
            FunctionDescriptor functionDescriptor = resolvedCall3 != null ? resolvedCall3.getResultingDescriptor() : null;
            temporaryForFunction.commit();
            if (callExpression.getValueArgumentList() == null && callExpression.getLambdaArguments().isEmpty()) {
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on((KtExpression)((PsiElement)callExpression), callExpression, hasValueParameters));
            }
            if (functionDescriptor == null) {
                return TypeInfoFactoryKt.noTypeInfo(context);
            }
            if (functionDescriptor instanceof ConstructorDescriptor) {
                ClassDescriptor classDescriptor = ((ConstructorDescriptor)functionDescriptor).getConstructedClass();
                Intrinsics.checkNotNullExpressionValue(classDescriptor, "getConstructedClass(...)");
                ClassDescriptor constructedClass = classDescriptor;
                if (DescriptorUtils.isAnnotationClass(constructedClass)) {
                    boolean supported;
                    BindingTrace bindingTrace = context.trace;
                    Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
                    if (!Companion.canInstantiateAnnotationClass(callExpression, bindingTrace) && !(supported = context.languageVersionSettings.supportsFeature(LanguageFeature.InstantiationOfAnnotationClasses))) {
                        context.trace.report(Errors.ANNOTATION_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                    }
                }
                if (DescriptorUtils.isEnumClass(constructedClass)) {
                    context.trace.report(Errors.ENUM_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                }
                if (DescriptorUtils.isSealedClass(constructedClass)) {
                    context.trace.report(Errors.SEALED_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                }
            }
            KotlinType type2 = functionDescriptor.getReturnType();
            List<KtValueArgument> list = callExpression.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
            List<KtValueArgument> arguments2 = list;
            DataFlowInfo dataFlowInfo = resolvedCall2.getDataFlowInfoForArguments().getResultInfo();
            Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "getResultInfo(...)");
            DataFlowInfo jumpFlowInfo = resultFlowInfo = dataFlowInfo;
            boolean jumpOutPossible = false;
            for (KtValueArgument argument : arguments2) {
                KotlinTypeInfo argTypeInfo = (KotlinTypeInfo)context.trace.get(BindingContext.EXPRESSION_TYPE_INFO, argument.getArgumentExpression());
                if (argTypeInfo == null || !argTypeInfo.getJumpOutPossible()) continue;
                jumpOutPossible = true;
                jumpFlowInfo = argTypeInfo.getJumpFlowInfo();
                break;
            }
            return TypeInfoFactoryKt.createTypeInfo(type2, resultFlowInfo, jumpOutPossible, jumpFlowInfo);
        }
        KtExpression calleeExpression = callExpression.getCalleeExpression();
        if (calleeExpression instanceof KtSimpleNameExpression && callExpression.getTypeArgumentList() == null) {
            TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as variable with 'invoke' call", callExpression);
            KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)calleeExpression;
            Object Context3 = context.replaceTraceAndCache(temporaryForVariable);
            Intrinsics.checkNotNullExpressionValue(Context3, "replaceTraceAndCache(...)");
            Pair<Boolean, KotlinType> pair2 = this.getVariableType(ktSimpleNameExpression, receiver, callOperationNode, (ExpressionTypingContext)Context3);
            boolean notNothing = pair2.component1();
            KotlinType type3 = pair2.component2();
            TemporaryBindingTrace temporaryBindingTrace = temporaryForVariable.trace;
            WritableSlice<KtExpression, Qualifier> writableSlice = BindingContext.QUALIFIER;
            Intrinsics.checkNotNullExpressionValue(writableSlice, "QUALIFIER");
            Qualifier qualifier = (Qualifier)temporaryBindingTrace.get(writableSlice, calleeExpression);
            if (notNothing && (qualifier == null || !(qualifier instanceof PackageQualifier))) {
                ResolvedCall<? extends CallableDescriptor> it = CallUtilKt.getResolvedCall(callExpression, temporaryForVariable.trace.getBindingContext());
                boolean bl = false;
                ResolvedCallImpl resolvedCallImpl = it instanceof ResolvedCallImpl ? (ResolvedCallImpl)it : null;
                if (resolvedCallImpl != null) {
                    resolvedCallImpl.addStatus(ResolutionStatus.OTHER_ERROR);
                }
                temporaryForVariable.commit();
                BindingTrace bindingTrace = context.trace;
                PsiElement psiElement = calleeExpression;
                KotlinType kotlinType = type3;
                if (kotlinType == null) {
                    kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_EXPECTED_TYPE, new String[0]);
                }
                bindingTrace.report(Errors.FUNCTION_EXPECTED.on((KtExpression)psiElement, calleeExpression, kotlinType));
                this.argumentTypeResolver.analyzeArgumentsAndRecordTypes(BasicCallResolutionContext.create(context, call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, new DataFlowInfoForArgumentsImpl(initialDataFlowInfoForArguments, call3)), ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
                return TypeInfoFactoryKt.noTypeInfo(context);
            }
        }
        temporaryForFunction.commit();
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    private final List<CallExpressionElement> elementChain(KtQualifiedExpression $this$elementChain, ExpressionTypingContext context) {
        return this.qualifiedExpressionResolver.resolveQualifierInExpressionAndUnroll($this$elementChain, context, arg_0 -> CallExpressionResolver.elementChain$lambda$2(context, this, arg_0));
    }

    private final OverloadResolutionResults<VariableDescriptor> resolveSimpleName(ExpressionTypingContext context, KtSimpleNameExpression expression, TemporaryTraceAndCache traceAndCache) {
        Call call2 = CallMaker.makePropertyCall(null, null, expression);
        Intrinsics.checkNotNullExpressionValue(call2, "makePropertyCall(...)");
        Call call3 = call2;
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context.replaceTraceAndCache(traceAndCache), call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        Intrinsics.checkNotNullExpressionValue(basicCallResolutionContext, "create(...)");
        BasicCallResolutionContext contextForVariable = basicCallResolutionContext;
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.callResolver.resolveSimpleProperty(contextForVariable);
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, "resolveSimpleProperty(...)");
        return overloadResolutionResults;
    }

    private final KotlinTypeInfo getUnsafeSelectorTypeInfo(Receiver receiver, ASTNode callOperationNode, KtExpression selectorExpression, ExpressionTypingContext context, DataFlowInfo initialDataFlowInfoForArguments) {
        KotlinTypeInfo kotlinTypeInfo;
        KtExpression ktExpression = selectorExpression;
        if (ktExpression instanceof KtCallExpression) {
            kotlinTypeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck((KtCallExpression)selectorExpression, receiver, callOperationNode, context, initialDataFlowInfoForArguments);
        } else if (ktExpression instanceof KtSimpleNameExpression) {
            kotlinTypeInfo = this.getSimpleNameExpressionTypeInfo((KtSimpleNameExpression)selectorExpression, receiver, callOperationNode, context, initialDataFlowInfoForArguments);
        } else if (ktExpression != null) {
            ExpressionTypingServices expressionTypingServices = this.expressionTypingServices;
            if (expressionTypingServices == null) {
                Intrinsics.throwUninitializedPropertyAccessException("expressionTypingServices");
                expressionTypingServices = null;
            }
            expressionTypingServices.getTypeInfo(selectorExpression, context);
            context.trace.report(Errors.ILLEGAL_SELECTOR.on((KtExpression)((PsiElement)selectorExpression)));
            kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        } else {
            kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        }
        return kotlinTypeInfo;
    }

    private final KotlinTypeInfo getSafeOrUnsafeSelectorTypeInfo(Receiver receiver, CallExpressionElement element, ExpressionTypingContext context) {
        KotlinType selectorType;
        KotlinTypeInfo kotlinTypeInfo;
        DataFlowValue dataFlowValue;
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
        DataFlowInfo initialDataFlowInfoForArguments = dataFlowInfo;
        ReceiverValue receiverValue = receiver instanceof ReceiverValue ? (ReceiverValue)receiver : null;
        if (receiverValue != null) {
            ReceiverValue it = receiverValue;
            boolean bl = false;
            dataFlowValue = this.dataFlowValueFactory.createDataFlowValue(it, context);
        } else {
            dataFlowValue = null;
        }
        DataFlowValue receiverDataFlowValue = dataFlowValue;
        boolean receiverCanBeNull = receiverDataFlowValue != null && initialDataFlowInfoForArguments.getStableNullability(receiverDataFlowValue).canBeNull();
        boolean shouldNullifySafeCallType = receiverCanBeNull || context.languageVersionSettings.supportsFeature(LanguageFeature.SafeCallsAreAlwaysNullable);
        ASTNode callOperationNode = AstLoadingFilter.forceAllowTreeLoading(element.getQualified().getContainingFile(), () -> CallExpressionResolver.getSafeOrUnsafeSelectorTypeInfo$lambda$4(element));
        if (receiverDataFlowValue != null && element.getSafe()) {
            if (shouldNullifySafeCallType) {
                initialDataFlowInfoForArguments = initialDataFlowInfoForArguments.disequate(receiverDataFlowValue, DataFlowValue.Companion.nullValue(this.builtIns), this.languageVersionSettings);
            }
            if (!receiverCanBeNull) {
                BindingTrace bindingTrace = context.trace;
                Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
                KotlinType kotlinType = ((ReceiverValue)receiver).getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                KtQualifiedExpression ktQualifiedExpression = element.getQualified();
                Intrinsics.checkNotNull(callOperationNode);
                LanguageVersionSettings languageVersionSettings = context.languageVersionSettings;
                Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "languageVersionSettings");
                Companion.reportUnnecessarySafeCall(bindingTrace, kotlinType, ktQualifiedExpression, callOperationNode, receiver, languageVersionSettings);
            }
        }
        KtExpression selector = element.getSelector();
        KotlinTypeInfo $this$getSafeOrUnsafeSelectorTypeInfo_u24lambda_u245 = this.getUnsafeSelectorTypeInfo(receiver, callOperationNode, selector, context, initialDataFlowInfoForArguments);
        boolean bl = false;
        KotlinType kotlinType = $this$getSafeOrUnsafeSelectorTypeInfo_u24lambda_u245.getType();
        if (kotlinType == null) {
            kotlinTypeInfo = $this$getSafeOrUnsafeSelectorTypeInfo_u24lambda_u245;
        } else {
            KotlinType type2 = kotlinType;
            kotlinTypeInfo = $this$getSafeOrUnsafeSelectorTypeInfo_u24lambda_u245.replaceType(this.kotlinTypeRefiner.refineType(type2));
        }
        KotlinTypeInfo selectorTypeInfo = kotlinTypeInfo;
        if (receiver instanceof Qualifier) {
            this.resolveDeferredReceiverInQualifiedExpression((Qualifier)receiver, selector, context);
        }
        if ((selectorType = selectorTypeInfo.getType()) != null) {
            if (element.getSafe() && shouldNullifySafeCallType) {
                selectorTypeInfo = selectorTypeInfo.replaceType(TypeUtils.makeNullable(selectorType));
            }
            if (selector != null) {
                context.trace.recordType(selector, selectorTypeInfo.getType());
            }
        }
        return selectorTypeInfo;
    }

    private final KotlinTypeInfo checkSelectorTypeInfo(KtQualifiedExpression qualified, KotlinTypeInfo selectorTypeInfo, ExpressionTypingContext context) {
        KotlinTypeInfo kotlinTypeInfo;
        CallExpressionResolver.Companion.checkNestedClassAccess(qualified, context);
        KtExpression ktExpression = qualified;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        CompileTimeConstant<?> value2 = this.constantExpressionEvaluator.evaluateExpression(ktExpression, bindingTrace, context.expectedType);
        if (value2 != null && value2.isPure()) {
            KotlinTypeInfo kotlinTypeInfo2 = this.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value2, qualified, context);
            Intrinsics.checkNotNull(kotlinTypeInfo2);
            kotlinTypeInfo = kotlinTypeInfo2;
        } else {
            if (context.contextDependency == ContextDependency.INDEPENDENT) {
                this.dataFlowAnalyzer.checkType(selectorTypeInfo.getType(), (KtExpression)qualified, (ResolutionContext)context);
            }
            kotlinTypeInfo = selectorTypeInfo;
        }
        return kotlinTypeInfo;
    }

    private final void recordResultTypeInfo(KtQualifiedExpression qualified, KotlinTypeInfo resultTypeInfo, ExpressionTypingContext context) {
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        BindingTrace trace = bindingTrace;
        if (!Intrinsics.areEqual(trace.get(BindingContext.PROCESSED, qualified), true)) {
            trace.record(BindingContext.PROCESSED, qualified);
            trace.record(BindingContext.EXPRESSION_TYPE_INFO, qualified, resultTypeInfo);
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkNotNullExpressionValue(lexicalScope, "scope");
            BindingContextUtilsKt.recordScope(trace, lexicalScope, qualified);
            Object Context2 = context.replaceDataFlowInfo(resultTypeInfo.getDataFlowInfo());
            Intrinsics.checkNotNullExpressionValue(Context2, "replaceDataFlowInfo(...)");
            BindingContextUtilsKt.recordDataFlowInfo(Context2, qualified);
        }
    }

    @NotNull
    public final KotlinTypeInfo getQualifiedExpressionTypeInfo(@NotNull KtQualifiedExpression expression, @NotNull ExpressionTypingContext context) {
        KotlinTypeInfo receiverTypeInfo;
        KotlinTypeInfo kotlinTypeInfo;
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Object Context2 = ((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkNotNullExpressionValue(Context2, "replaceContextDependency(...)");
        ExpressionTypingContext currentContext = (ExpressionTypingContext)Context2;
        BindingTrace bindingTrace = currentContext.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        BindingTrace trace = bindingTrace;
        List<CallExpressionElement> elementChain = this.elementChain(expression, currentContext);
        KtExpression firstReceiver = CollectionsKt.first(elementChain).getReceiver();
        if ((Qualifier)trace.get(BindingContext.QUALIFIER, firstReceiver) == null) {
            ExpressionTypingServices expressionTypingServices = this.expressionTypingServices;
            if (expressionTypingServices == null) {
                Intrinsics.throwUninitializedPropertyAccessException("expressionTypingServices");
                expressionTypingServices = null;
            }
            kotlinTypeInfo = expressionTypingServices.getTypeInfo(firstReceiver, currentContext);
        } else {
            DataFlowInfo dataFlowInfo = currentContext.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
            kotlinTypeInfo = new KotlinTypeInfo(null, dataFlowInfo, false, null, 12, null);
        }
        KotlinTypeInfo kotlinTypeInfo2 = kotlinTypeInfo;
        Intrinsics.checkNotNull(kotlinTypeInfo2);
        KotlinTypeInfo resultTypeInfo = receiverTypeInfo = kotlinTypeInfo2;
        boolean allUnsafe = true;
        DataFlowInfo branchPointDataFlowInfo = receiverTypeInfo.getDataFlowInfo();
        for (CallExpressionElement element : elementChain) {
            Receiver receiver;
            KotlinType kotlinType = receiverTypeInfo.getType();
            if (kotlinType == null) {
                KtExpression receiver2 = element.getReceiver();
                String[] stringArray = new String[]{receiver2 instanceof KtNameReferenceExpression ? ((KtNameReferenceExpression)receiver2).getReferencedName() : receiver2.getText()};
                kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_RECEIVER_TYPE, stringArray);
            }
            KotlinType receiverType = kotlinType;
            Qualifier qualifier = (Qualifier)trace.get(BindingContext.QUALIFIER, element.getReceiver());
            if (qualifier != null) {
                receiver = qualifier;
            } else {
                KtExpression ktExpression = element.getReceiver();
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                receiver = ExpressionReceiver.Companion.create(ktExpression, receiverType, bindingContext);
            }
            Receiver receiver3 = receiver;
            KtQualifiedExpression qualifiedExpression = element.getQualified();
            boolean lastStage = qualifiedExpression == expression;
            Object Context3 = (lastStage ? context : currentContext).replaceDataFlowInfo(receiver3 instanceof ReceiverValue && TypeUtils.isNullableType(((ReceiverValue)receiver3).getType()) && !element.getSafe() ? branchPointDataFlowInfo : receiverTypeInfo.getDataFlowInfo());
            Intrinsics.checkNotNullExpressionValue(Context3, "replaceDataFlowInfo(...)");
            ExpressionTypingContext contextForSelector = (ExpressionTypingContext)Context3;
            KotlinTypeInfo selectorTypeInfo = this.getSafeOrUnsafeSelectorTypeInfo(receiver3, element, contextForSelector);
            boolean bl = allUnsafe = allUnsafe && !element.getSafe();
            if (allUnsafe) {
                branchPointDataFlowInfo = selectorTypeInfo.getDataFlowInfo();
            }
            resultTypeInfo = this.checkSelectorTypeInfo(qualifiedExpression, selectorTypeInfo, contextForSelector).replaceDataFlowInfo(branchPointDataFlowInfo);
            if (!lastStage) {
                this.recordResultTypeInfo(qualifiedExpression, resultTypeInfo, contextForSelector);
            }
            receiverTypeInfo = selectorTypeInfo;
        }
        return resultTypeInfo;
    }

    private final void resolveDeferredReceiverInQualifiedExpression(Qualifier qualifier, KtExpression selectorExpression, ExpressionTypingContext context) {
        DeclarationDescriptor declarationDescriptor;
        KtExpression calleeExpression = KtPsiUtil.deparenthesize(PsiUtilsKt.getCalleeExpressionIfAny(selectorExpression));
        KtReferenceExpression ktReferenceExpression = calleeExpression instanceof KtReferenceExpression ? (KtReferenceExpression)calleeExpression : null;
        if (ktReferenceExpression != null) {
            KtReferenceExpression it = ktReferenceExpression;
            boolean bl = false;
            declarationDescriptor = (DeclarationDescriptor)context.trace.get(BindingContext.REFERENCE_TARGET, it);
        } else {
            declarationDescriptor = null;
        }
        DeclarationDescriptor selectorDescriptor = declarationDescriptor;
        QualifiedExpressionResolveUtilKt.resolveQualifierAsReceiverInExpression(qualifier, selectorDescriptor, context);
    }

    private static final boolean elementChain$lambda$2(ExpressionTypingContext $context, CallExpressionResolver this$0, KtSimpleNameExpression nameExpression) {
        boolean bl;
        Intrinsics.checkNotNullParameter(nameExpression, "nameExpression");
        TemporaryTraceAndCache temporaryTraceAndCache = TemporaryTraceAndCache.create($context, "trace to resolve as local variable or property", nameExpression);
        Intrinsics.checkNotNull(temporaryTraceAndCache);
        OverloadResolutionResults<VariableDescriptor> resolutionResult = this$0.resolveSimpleName($context, nameExpression, temporaryTraceAndCache);
        if (resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject) {
            bl = false;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[resolutionResult.getResultCode().ordinal()]) {
                case 1: 
                case 2: {
                    bl = false;
                    break;
                }
                default: {
                    boolean success;
                    boolean newInferenceEnabled = $context.languageVersionSettings.supportsFeature(LanguageFeature.NewInference);
                    boolean bl2 = success = !newInferenceEnabled || resolutionResult.isSuccess();
                    if (newInferenceEnabled && success) {
                        temporaryTraceAndCache.commit();
                    }
                    bl = success;
                }
            }
        }
        return bl;
    }

    private static final ASTNode getSafeOrUnsafeSelectorTypeInfo$lambda$4(CallExpressionElement $element) {
        return $element.getNode();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ?\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "expression", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "", "canInstantiateAnnotationClass", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;)Z", "Lcom/intellij/psi/PsiElement;", "parent", "isUnderAnnotationClassDeclaration", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lcom/intellij/psi/PsiElement;)Z", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "callElement", "Lcom/intellij/lang/ASTNode;", "callOperationNode", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "explicitReceiver", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "", "reportUnnecessarySafeCall", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;Lcom/intellij/lang/ASTNode;Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "context", "checkNestedClassAccess", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)V"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canInstantiateAnnotationClass(@NotNull KtCallExpression expression, @NotNull BindingTrace trace) {
            Intrinsics.checkNotNullParameter(expression, "expression");
            Intrinsics.checkNotNullParameter(trace, "trace");
            Object object = new Class[]{KtValueArgument.class, KtParameter.class};
            Object parent2 = PsiTreeUtil.getParentOfType((PsiElement)expression, object);
            if (parent2 instanceof KtValueArgument) {
                Object $this$getParentOfType$iv;
                object = parent2;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtAnnotationEntry.class, strict$iv) != null) {
                    return true;
                }
                $this$getParentOfType$iv = parent2;
                strict$iv = true;
                $i$f$getParentOfType = false;
                parent2 = PsiTreeUtil.getParentOfType($this$getParentOfType$iv, KtParameter.class, strict$iv);
                if (parent2 != null) {
                    return this.isUnderAnnotationClassDeclaration(trace, (PsiElement)parent2);
                }
            } else if (parent2 instanceof KtParameter) {
                return this.isUnderAnnotationClassDeclaration(trace, (PsiElement)parent2);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isUnderAnnotationClassDeclaration(BindingTrace trace, PsiElement parent2) {
            boolean bl;
            void $this$getParentOfType$iv;
            PsiElement psiElement = parent2;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            KtClass ktClass = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClass.class, strict$iv);
            if (ktClass != null) {
                KtClass it = ktClass;
                boolean bl2 = false;
                bl = DescriptorUtils.isAnnotationClass(trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, it));
            } else {
                bl = false;
            }
            return bl;
        }

        public final void reportUnnecessarySafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2, @NotNull KtQualifiedExpression callElement, @NotNull ASTNode callOperationNode, @Nullable Receiver explicitReceiver, @NotNull LanguageVersionSettings languageVersionSettings) {
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(type2, "type");
            Intrinsics.checkNotNullParameter(callElement, "callElement");
            Intrinsics.checkNotNullParameter(callOperationNode, "callOperationNode");
            Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
            if (explicitReceiver instanceof ExpressionReceiver && ((ExpressionReceiver)explicitReceiver).getExpression() instanceof KtSuperExpression) {
                trace.report(Errors.UNEXPECTED_SAFE_CALL.on(callOperationNode.getPsi()));
            } else if (!KotlinTypeKt.isError(type2)) {
                trace.report(Errors.UNNECESSARY_SAFE_CALL.on(callOperationNode.getPsi(), type2));
                if (!languageVersionSettings.supportsFeature(LanguageFeature.SafeCallsAreAlwaysNullable)) {
                    trace.report(Errors.SAFE_CALL_WILL_CHANGE_NULLABILITY.on((KtQualifiedExpression)((PsiElement)callElement)));
                }
            }
        }

        private final void checkNestedClassAccess(KtQualifiedExpression expression, ExpressionTypingContext context) {
            KtExpression ktExpression = expression.getSelectorExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression selectorExpression = ktExpression;
            Qualifier expressionQualifier = (Qualifier)context.trace.get(BindingContext.QUALIFIER, expression);
            Qualifier receiverQualifier = (Qualifier)context.trace.get(BindingContext.QUALIFIER, expression.getReceiverExpression());
            if (receiverQualifier == null && expressionQualifier != null) {
                boolean bl = expressionQualifier instanceof ClassifierQualifier;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string2 = "Only class can (package cannot) be accessed by instance reference: " + expressionQualifier;
                    throw new AssertionError((Object)string2);
                }
                ClassifierDescriptorWithTypeParameters descriptor2 = ((ClassifierQualifier)expressionQualifier).getDescriptor();
                context.trace.report(Errors.NESTED_CLASS_ACCESSED_VIA_INSTANCE_REFERENCE.on((KtExpression)((PsiElement)selectorExpression), descriptor2));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OverloadResolutionResults.Code.values().length];
            try {
                nArray[OverloadResolutionResults.Code.NAME_NOT_FOUND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

