/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.DeprecatedCallChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ApiVersionCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "targetDescriptor", "element", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;Lcom/intellij/psi/PsiElement;)V"})
public final class ApiVersionCallChecker
implements CallChecker {
    @NotNull
    public static final ApiVersionCallChecker INSTANCE = new ApiVersionCallChecker();

    private ApiVersionCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, "getResultingDescriptor(...)");
        this.check((CallableDescriptor)obj, context, reportOn);
    }

    private final void check(CallableDescriptor targetDescriptor, CallCheckerContext context, PsiElement element) {
        block3: {
            if (targetDescriptor instanceof FakeCallableDescriptorForObject) {
                return;
            }
            SinceKotlinAccessibility accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility(targetDescriptor, context.getLanguageVersionSettings());
            if (accessibility instanceof SinceKotlinAccessibility.NotAccessible) {
                context.getTrace().report(Errors.API_NOT_AVAILABLE.on(element, ((SinceKotlinAccessibility.NotAccessible)accessibility).getVersion().getVersionString(), context.getLanguageVersionSettings().getApiVersion().getVersionString()));
            }
            if (!Intrinsics.areEqual(accessibility, SinceKotlinAccessibility.Accessible.INSTANCE) || !(targetDescriptor instanceof PropertyDescriptor) || !DeprecatedCallChecker.INSTANCE.shouldCheckPropertyGetter$frontend(element)) break block3;
            PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)targetDescriptor).getGetter();
            if (propertyGetterDescriptor != null) {
                PropertyGetterDescriptor it = propertyGetterDescriptor;
                boolean bl = false;
                INSTANCE.check(it, context, element);
            }
        }
    }
}

