/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ+\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J+\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00142\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J3\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00142\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0013\u0010\u001b\u001a\u00020\u001a*\u00020\rH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/AssigningNamedArgumentToVarargChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "argument", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameterDescriptor", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "checkAssignmentOfSingleElementToVararg", "(Lorg/jetbrains/kotlin/psi/ValueArgument;Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "argumentExpression", "checkAssignmentOfSingleElementInAnnotation", "(Lorg/jetbrains/kotlin/psi/ValueArgument;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;)V", "checkAssignmentOfSingleElementInFunction", "(Lorg/jetbrains/kotlin/psi/ValueArgument;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)V", "", "hasSpread", "(Lorg/jetbrains/kotlin/psi/ValueArgument;)Z"})
public final class AssigningNamedArgumentToVarargChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map2, "getValueArguments(...)");
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : map2.entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument resolvedArgument = entry.getValue();
            for (ValueArgument argument : resolvedArgument.getArguments()) {
                Intrinsics.checkNotNull(argument);
                Intrinsics.checkNotNull(parameterDescriptor);
                this.checkAssignmentOfSingleElementToVararg(argument, parameterDescriptor, context.getResolutionContext());
            }
        }
    }

    private final void checkAssignmentOfSingleElementToVararg(ValueArgument argument, ValueParameterDescriptor parameterDescriptor, ResolutionContext<?> context) {
        if (!context.languageVersionSettings.supportsFeature(LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations)) {
            return;
        }
        if (!argument.isNamed()) {
            return;
        }
        if (!ArgumentsUtilsKt.isVararg(parameterDescriptor)) {
            return;
        }
        KtExpression ktExpression = argument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        if (DescriptorUtilsKt.isParameterOfAnnotation(parameterDescriptor)) {
            this.checkAssignmentOfSingleElementInAnnotation(argument, argumentExpression, context);
        } else {
            this.checkAssignmentOfSingleElementInFunction(argument, argumentExpression, context, parameterDescriptor);
        }
    }

    private final void checkAssignmentOfSingleElementInAnnotation(ValueArgument argument, KtExpression argumentExpression, ResolutionContext<?> context) {
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        if (CallResolverUtilKt.isArrayOrArrayLiteral(argument, bindingTrace)) {
            if (this.hasSpread(argument)) {
                context.trace.report(Errors.REDUNDANT_SPREAD_OPERATOR_IN_NAMED_FORM_IN_ANNOTATION.on((KtExpression)((PsiElement)argumentExpression)));
            }
        } else {
            BindingTrace bindingTrace2 = context.trace;
            LanguageVersionSettings languageVersionSettings = context.languageVersionSettings;
            Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "languageVersionSettings");
            bindingTrace2.report(Errors.ASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_ANNOTATION.on(languageVersionSettings, (KtExpression)((PsiElement)argumentExpression)));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void checkAssignmentOfSingleElementInFunction(ValueArgument argument, KtExpression argumentExpression, ResolutionContext<?> context, ValueParameterDescriptor parameterDescriptor) {
        if (context.languageVersionSettings.supportsFeature(LanguageFeature.AllowAssigningArrayElementsToVarargsInNamedFormForFunctions)) {
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
            if (CallResolverUtilKt.isArrayOrArrayLiteral(argument, bindingTrace)) {
                if (!this.hasSpread(argument)) return;
                context.trace.report(Errors.REDUNDANT_SPREAD_OPERATOR_IN_NAMED_FORM_IN_FUNCTION.on((KtExpression)((PsiElement)argumentExpression)));
                return;
            }
        }
        if (this.hasSpread(argument)) return;
        BindingTrace bindingTrace = context.trace;
        LanguageVersionSettings languageVersionSettings = context.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "languageVersionSettings");
        bindingTrace.report(Errors.ASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_FUNCTION.on(languageVersionSettings, (KtExpression)((PsiElement)argumentExpression), parameterDescriptor.getType()));
    }

    private final boolean hasSpread(ValueArgument $this$hasSpread) {
        return $this$hasSpread.getSpreadElement() != null;
    }
}

