/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeChecker;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a-\u0010\b\u001a\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\t"}, d2={"Lorg/jetbrains/kotlin/types/KotlinType;", "leftType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "rightExpression", "rightType", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "isAssignmentCorrectWithDataFlowInfo", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)Z"})
public final class AssignmentCheckUtilsKt {
    public static final boolean isAssignmentCorrectWithDataFlowInfo(@NotNull KotlinType leftType, @NotNull KtExpression rightExpression, @NotNull KotlinType rightType, @NotNull CallCheckerContext context) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(leftType, "leftType");
            Intrinsics.checkNotNullParameter(rightExpression, "rightExpression");
            Intrinsics.checkNotNullParameter(rightType, "rightType");
            Intrinsics.checkNotNullParameter(context, "context");
            NewKotlinTypeChecker kotlinTypeChecker = context.getCallComponents().getKotlinTypeChecker();
            if (kotlinTypeChecker.isSubtypeOf(rightType, leftType)) {
                return true;
            }
            DataFlowInfo dfi = context.getDataFlowInfo();
            DataFlowValueFactory dfvFactory = context.getDataFlowValueFactory();
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            Set<KotlinType> stableTypesFromDataFlow = dfi.getStableTypes(dfvFactory.createDataFlowValue(rightExpression, rightType, bindingContext, context.getModuleDescriptor()), context.getLanguageVersionSettings());
            Iterable $this$any$iv = stableTypesFromDataFlow;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!kotlinTypeChecker.isSubtypeOf(it, leftType)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

