/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.MissingSupertypesResolver;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.checkers.CheckerContext;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B=\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0005\u001a\u00020\u00048\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0007\u001a\u00020\u00068\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\t\u001a\u00020\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u000b\u001a\u00020\n8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\r\u001a\u00020\f8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u001f\u001a\u0004\b \u0010!R\u0011\u0010%\u001a\u00020\"8G\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010)\u001a\u00020&8G\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010+\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u00100\u001a\u00020-8G\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0014\u00104\u001a\u0002018WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "resolutionContext", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "deprecationResolver", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleDescriptor", "Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;", "missingSupertypesResolver", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "callComponents", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "getResolutionContext", "()Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "getDeprecationResolver", "()Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;", "getMissingSupertypesResolver", "()Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "getCallComponents", "()Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "getScope", "()Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "scope", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getDataFlowInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "dataFlowInfo", "", "isAnnotationContext", "()Z", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "getDataFlowValueFactory", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings"})
public final class CallCheckerContext
implements CheckerContext {
    @NotNull
    private final ResolutionContext<?> resolutionContext;
    @NotNull
    private final DeprecationResolver deprecationResolver;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final MissingSupertypesResolver missingSupertypesResolver;
    @NotNull
    private final KotlinCallComponents callComponents;
    @NotNull
    private final BindingTrace trace;

    public CallCheckerContext(@NotNull ResolutionContext<?> resolutionContext, @NotNull DeprecationResolver deprecationResolver, @NotNull ModuleDescriptor moduleDescriptor, @NotNull MissingSupertypesResolver missingSupertypesResolver, @NotNull KotlinCallComponents callComponents, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(resolutionContext, "resolutionContext");
        Intrinsics.checkNotNullParameter(deprecationResolver, "deprecationResolver");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(missingSupertypesResolver, "missingSupertypesResolver");
        Intrinsics.checkNotNullParameter(callComponents, "callComponents");
        Intrinsics.checkNotNullParameter(trace, "trace");
        this.resolutionContext = resolutionContext;
        this.deprecationResolver = deprecationResolver;
        this.moduleDescriptor = moduleDescriptor;
        this.missingSupertypesResolver = missingSupertypesResolver;
        this.callComponents = callComponents;
        this.trace = trace;
    }

    public /* synthetic */ CallCheckerContext(ResolutionContext resolutionContext, DeprecationResolver deprecationResolver, ModuleDescriptor moduleDescriptor, MissingSupertypesResolver missingSupertypesResolver, KotlinCallComponents kotlinCallComponents, BindingTrace bindingTrace, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bindingTrace = resolutionContext.trace;
        }
        this(resolutionContext, deprecationResolver, moduleDescriptor, missingSupertypesResolver, kotlinCallComponents, bindingTrace);
    }

    @NotNull
    public final ResolutionContext<?> getResolutionContext() {
        return this.resolutionContext;
    }

    @Override
    @NotNull
    public DeprecationResolver getDeprecationResolver() {
        return this.deprecationResolver;
    }

    @Override
    @NotNull
    public ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @NotNull
    public final MissingSupertypesResolver getMissingSupertypesResolver() {
        return this.missingSupertypesResolver;
    }

    @NotNull
    public final KotlinCallComponents getCallComponents() {
        return this.callComponents;
    }

    @Override
    @NotNull
    public BindingTrace getTrace() {
        return this.trace;
    }

    @NotNull
    public final LexicalScope getScope() {
        LexicalScope lexicalScope = this.resolutionContext.scope;
        Intrinsics.checkNotNullExpressionValue(lexicalScope, "scope");
        return lexicalScope;
    }

    @NotNull
    public final DataFlowInfo getDataFlowInfo() {
        DataFlowInfo dataFlowInfo = this.resolutionContext.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
        return dataFlowInfo;
    }

    public final boolean isAnnotationContext() {
        return this.resolutionContext.isAnnotationContext;
    }

    @NotNull
    public final DataFlowValueFactory getDataFlowValueFactory() {
        DataFlowValueFactory dataFlowValueFactory = this.resolutionContext.dataFlowValueFactory;
        Intrinsics.checkNotNullExpressionValue(dataFlowValueFactory, "dataFlowValueFactory");
        return dataFlowValueFactory;
    }

    @Override
    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        LanguageVersionSettings languageVersionSettings = this.resolutionContext.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "languageVersionSettings");
        return languageVersionSettings;
    }

    public CallCheckerContext(@NotNull ResolutionContext<?> resolutionContext, @NotNull DeprecationResolver deprecationResolver, @NotNull ModuleDescriptor moduleDescriptor, @NotNull MissingSupertypesResolver missingSupertypesResolver, @NotNull KotlinCallComponents callComponents) {
        Intrinsics.checkNotNullParameter(resolutionContext, "resolutionContext");
        Intrinsics.checkNotNullParameter(deprecationResolver, "deprecationResolver");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(missingSupertypesResolver, "missingSupertypesResolver");
        Intrinsics.checkNotNullParameter(callComponents, "callComponents");
        this(resolutionContext, deprecationResolver, moduleDescriptor, missingSupertypesResolver, callComponents, null, 32, null);
    }
}

