/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.EnumEntryVsCompanionPriorityCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r*\u0006\u0012\u0002\b\u00030\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0012\u001a\u00020\r*\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0015\u001a\u00020\r*\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u0018\u001a\u00020\r*\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CustomEnumEntriesMigrationCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "", "isExtensionWithEnumClassQualifier", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;)Z", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "descriptor", "isCallViaCompanionOnEnumClassQualifier", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;)Z", "contextExpression", "isCallToExternalEntriesInsideEnum", "(Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;Lcom/intellij/psi/PsiElement;)Z", "expression", "isReferenceToMemberEntriesWithoutExpectedFunctionalType", "(Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)Z"})
public final class CustomEnumEntriesMigrationCallChecker
implements CallChecker {
    @NotNull
    public static final CustomEnumEntriesMigrationCallChecker INSTANCE = new CustomEnumEntriesMigrationCallChecker();

    private CustomEnumEntriesMigrationCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, "getResultingDescriptor(...)");
        Object descriptor2 = obj;
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return;
        }
        if (!Intrinsics.areEqual(((PropertyDescriptor)descriptor2).getName(), StandardNames.ENUM_ENTRIES)) {
            return;
        }
        if (this.isExtensionWithEnumClassQualifier(resolvedCall2) || this.isCallViaCompanionOnEnumClassQualifier(resolvedCall2, (PropertyDescriptor)descriptor2)) {
            context.getTrace().report(Errors.DEPRECATED_ACCESS_TO_ENUM_ENTRY_COMPANION_PROPERTY.on(reportOn));
        } else if (this.isCallToExternalEntriesInsideEnum((PropertyDescriptor)descriptor2, reportOn)) {
            boolean bl;
            block11: {
                Iterable $this$none$iv = context.getTrace().getBindingContext().getDiagnostics().forElement(reportOn);
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Diagnostic it = (Diagnostic)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getFactory(), Errors.DEPRECATED_ACCESS_TO_ENTRY_PROPERTY_FROM_ENUM)) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (bl) {
                context.getTrace().report(Errors.DEPRECATED_ACCESS_TO_ENTRY_PROPERTY_FROM_ENUM.on(reportOn));
            }
        } else if (this.isReferenceToMemberEntriesWithoutExpectedFunctionalType((PropertyDescriptor)descriptor2, reportOn, context)) {
            context.getTrace().report(Errors.DEPRECATED_ACCESS_TO_ENUM_ENTRY_PROPERTY_AS_REFERENCE.on(reportOn));
        }
    }

    private final boolean isExtensionWithEnumClassQualifier(ResolvedCall<?> $this$isExtensionWithEnumClassQualifier) {
        ReceiverValue receiverValue = $this$isExtensionWithEnumClassQualifier.getExtensionReceiver();
        if (receiverValue == null) {
            return false;
        }
        ReceiverValue receiver = receiverValue;
        return receiver instanceof ClassValueReceiver && DescriptorUtils.isEnumClass(((ClassValueReceiver)receiver).getClassQualifier().getDescriptor());
    }

    private final boolean isCallViaCompanionOnEnumClassQualifier(ResolvedCall<?> $this$isCallViaCompanionOnEnumClassQualifier, PropertyDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (!DescriptorUtilsKt.isCompanionObject(containingDeclaration)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = containingDeclaration.getContainingDeclaration();
        if (declarationDescriptor2 == null) {
            return false;
        }
        DeclarationDescriptor grandParent = declarationDescriptor2;
        if (!(grandParent instanceof ClassDescriptor) || !DescriptorUtils.isEnumClass(grandParent)) {
            return false;
        }
        return EnumEntryVsCompanionPriorityCallCheckerKt.isQualifierFor($this$isCallViaCompanionOnEnumClassQualifier.getDispatchReceiver(), (ClassDescriptor)grandParent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCallToExternalEntriesInsideEnum(PropertyDescriptor $this$isCallToExternalEntriesInsideEnum, PsiElement contextExpression) {
        boolean bl;
        PsiElement parent2 = contextExpression.getParent();
        if (DescriptorUtils.isEnumClass($this$isCallToExternalEntriesInsideEnum.getContainingDeclaration())) return false;
        if (parent2 instanceof KtDotQualifiedExpression) {
            if (((KtDotQualifiedExpression)parent2).getReceiverExpression() != contextExpression) return false;
        }
        Sequence<PsiElement> $this$any$iv = PsiUtilsKt.getParentsWithSelf(contextExpression);
        boolean $i$f$any = false;
        Iterator<PsiElement> iterator2 = $this$any$iv.iterator();
        do {
            PsiElement element$iv;
            if (!iterator2.hasNext()) return false;
            PsiElement it = element$iv = iterator2.next();
            boolean bl2 = false;
            if (it instanceof KtClass && ((KtClass)it).isEnum()) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean isReferenceToMemberEntriesWithoutExpectedFunctionalType(PropertyDescriptor $this$isReferenceToMemberEntriesWithoutExpectedFunctionalType, PsiElement expression, CallCheckerContext context) {
        KotlinType kotlinType = context.getResolutionContext().expectedType;
        Intrinsics.checkNotNullExpressionValue(kotlinType, "expectedType");
        KotlinType expectedType = kotlinType;
        return expression.getParent() instanceof KtCallableReferenceExpression && DescriptorUtils.isEnumClass($this$isReferenceToMemberEntriesWithoutExpectedFunctionalType.getContainingDeclaration()) && (TypeUtils.noExpectedType(expectedType) || !FunctionTypesKt.isFunctionType(expectedType));
    }
}

