/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationUtilKt;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.SuperCallReceiverValue;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ?\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0018J\u0017\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0019\u0010\u001f\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 "}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/DeprecatedCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "targetDescriptor", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "element", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "deprecationResolver", "", "isSuperCall", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;Z)V", "expression", "shouldCheckPropertyGetter$frontend", "(Lcom/intellij/psi/PsiElement;)Z", "shouldCheckPropertyGetter", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "PROPERTY_SET_OPERATIONS", "Lcom/intellij/psi/tree/TokenSet;"})
public final class DeprecatedCallChecker
implements CallChecker {
    @NotNull
    public static final DeprecatedCallChecker INSTANCE = new DeprecatedCallChecker();
    @NotNull
    private static final TokenSet PROPERTY_SET_OPERATIONS;

    private DeprecatedCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, "getResultingDescriptor(...)");
        this.check((CallableDescriptor)obj, context.getTrace(), reportOn, context.getLanguageVersionSettings(), context.getDeprecationResolver(), resolvedCall2.getDispatchReceiver() instanceof SuperCallReceiverValue);
    }

    private final void check(CallableDescriptor targetDescriptor, BindingTrace trace, PsiElement element, LanguageVersionSettings languageVersionSettings, DeprecationResolver deprecationResolver, boolean isSuperCall) {
        block5: {
            block4: {
                if (targetDescriptor instanceof FakeCallableDescriptorForObject) {
                    return;
                }
                List<DescriptorBasedDeprecationInfo> deprecations = CollectionsKt.toMutableList((Collection)deprecationResolver.getDeprecations(targetDescriptor));
                if (targetDescriptor instanceof PropertySetterDescriptor) {
                    Collection collection = deprecations;
                    PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)targetDescriptor).getCorrespondingProperty();
                    Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "getCorrespondingProperty(...)");
                    CollectionsKt.removeAll(collection, (Iterable)deprecationResolver.getDeprecations(propertyDescriptor));
                }
                if (!(!((Collection)deprecations).isEmpty())) break block4;
                for (DescriptorBasedDeprecationInfo deprecation : deprecations) {
                    FqName targetFqNameIfAny = DescriptorUtilsKt.fqNameOrNull(targetDescriptor);
                    trace.report(DeprecationUtilKt.createDeprecationDiagnostic(element, deprecation, languageVersionSettings, isSuperCall && CollectionsKt.contains((Iterable)DeprecationResolver.Companion.getKOTLIN_LIST_FIRST_LAST(), targetFqNameIfAny)));
                }
                break block5;
            }
            if (!(targetDescriptor instanceof PropertyDescriptor) || !this.shouldCheckPropertyGetter$frontend(element)) break block5;
            PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)targetDescriptor).getGetter();
            if (propertyGetterDescriptor != null) {
                PropertyGetterDescriptor it = propertyGetterDescriptor;
                boolean bl = false;
                INSTANCE.check(it, trace, element, languageVersionSettings, deprecationResolver, false);
            }
        }
    }

    public final boolean shouldCheckPropertyGetter$frontend(@NotNull PsiElement expression) {
        KtUnaryExpression unaryExpression;
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter(expression, "expression");
        KtBinaryExpression binaryExpression = PsiTreeUtil.getParentOfType(expression, KtBinaryExpression.class);
        if (binaryExpression != null) {
            KtExpression left = binaryExpression.getLeft();
            if (Intrinsics.areEqual(left, expression) && PROPERTY_SET_OPERATIONS.contains(binaryExpression.getOperationToken())) {
                return false;
            }
            KtReferenceExpression[] referenceExpressions = (KtReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)left, KtReferenceExpression.class);
            if (referenceExpressions != null) {
                Iterator<KtReferenceExpression> iterator2 = ArrayIteratorKt.iterator(referenceExpressions);
                while (iterator2.hasNext()) {
                    KtReferenceExpression expr = iterator2.next();
                    if (!Intrinsics.areEqual(expr, expression) || !PROPERTY_SET_OPERATIONS.contains(binaryExpression.getOperationToken())) continue;
                    return false;
                }
            }
        }
        if (PROPERTY_SET_OPERATIONS.contains((ktExpression = (unaryExpression = PsiTreeUtil.getParentOfType(expression, KtUnaryExpression.class))) != null && (ktExpression = ((KtUnaryExpression)ktExpression).getOperationReference()) != null ? ktExpression.getReferencedNameElementType() : null)) {
            return false;
        }
        KtCallableReferenceExpression callableExpression = PsiTreeUtil.getParentOfType(expression, KtCallableReferenceExpression.class);
        return callableExpression == null || !Intrinsics.areEqual(callableExpression.getCallableReference(), expression);
    }

    static {
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.addSpread(KtTokens.ALL_ASSIGNMENTS.getTypes());
        spreadBuilder.add(KtTokens.PLUSPLUS);
        spreadBuilder.add(KtTokens.MINUSMINUS);
        TokenSet tokenSet = TokenSet.create((IElementType[])spreadBuilder.toArray(new IElementType[spreadBuilder.size()]));
        Intrinsics.checkNotNullExpressionValue(tokenSet, "create(...)");
        PROPERTY_SET_OPERATIONS = tokenSet;
    }
}

