/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.EnumEntryVsCompanionPriorityCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u0011\u001a\u00020\u0010*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/EnumEntryVsCompanionPriorityCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/name/Name;", "name", "", "containsEntryWithName", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/name/Name;)Z"})
public final class EnumEntryVsCompanionPriorityCallChecker
implements CallChecker {
    @NotNull
    public static final EnumEntryVsCompanionPriorityCallChecker INSTANCE = new EnumEntryVsCompanionPriorityCallChecker();

    private EnumEntryVsCompanionPriorityCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        Object obj = resolvedCall2.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, "getCandidateDescriptor(...)");
        Object descriptor2 = obj;
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return;
        }
        Name name = ((PropertyDescriptor)descriptor2).getName();
        Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
        Name propertyName = name;
        DeclarationDescriptor declarationDescriptor = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        DeclarationDescriptor containingDescriptor = declarationDescriptor;
        if (!(containingDescriptor instanceof ClassDescriptor) || !((ClassDescriptor)containingDescriptor).isCompanionObject()) {
            return;
        }
        DeclarationDescriptor declarationDescriptor2 = ((ClassDescriptor)containingDescriptor).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor2, "getContainingDeclaration(...)");
        DeclarationDescriptor grandParent = declarationDescriptor2;
        if (grandParent instanceof ClassDescriptor && ((ClassDescriptor)grandParent).getKind() == ClassKind.ENUM_CLASS && this.containsEntryWithName((ClassDescriptor)grandParent, propertyName) && EnumEntryVsCompanionPriorityCallCheckerKt.isQualifierFor(resolvedCall2.getDispatchReceiver(), (ClassDescriptor)grandParent)) {
            context.getResolutionContext().trace.report(Errors.DEPRECATED_ACCESS_TO_ENUM_COMPANION_PROPERTY.on(reportOn, (PropertyDescriptor)descriptor2));
        }
    }

    private final boolean containsEntryWithName(ClassDescriptor $this$containsEntryWithName, Name name) {
        ClassifierDescriptor foundDescriptor = $this$containsEntryWithName.getUnsubstitutedMemberScope().getContributedClassifier(name, NoLookupLocation.FOR_ALREADY_TRACKED);
        return foundDescriptor instanceof ClassDescriptor && ((ClassDescriptor)foundDescriptor).getKind() == ClassKind.ENUM_ENTRY;
    }
}

