/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.google.common.collect.ImmutableSet;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceSession;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.types.EnumCompatibilityCheckerKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0010\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u000e\u001a\u00020\r2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J!\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J#\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u001f\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ#\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/EqualityCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "expression", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "checkEquality", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;)V", "checkIdentityEquality", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;)V", "checkIdentityOnPrimitiveOrInlineClassTypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "leftType", "rightType", "", "isIdentityComparedWithImplicitBoxing", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;)Z", "ensureNonemptyIntersectionOfOperandTypes"})
public final class EqualityCallChecker
implements CallChecker {
    @NotNull
    public static final EqualityCallChecker INSTANCE = new EqualityCallChecker();

    private EqualityCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        KtBinaryExpression ktBinaryExpression = ktElement instanceof KtBinaryExpression ? (KtBinaryExpression)ktElement : null;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression callExpression = ktBinaryExpression;
        IElementType operationType = callExpression.getOperationReference().getReferencedNameElementType();
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.EQUALS_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet, "EQUALS_OPERATIONS");
        if (CollectionsKt.contains((Iterable)immutableSet, operationType)) {
            this.checkEquality(resolvedCall2, callExpression, context.getResolutionContext());
        }
    }

    private final void checkEquality(ResolvedCall<?> resolvedCall2, KtBinaryExpression expression, ResolutionContext<?> context) {
        KotlinType kotlinType = resolvedCall2.getResultingDescriptor().getReturnType();
        if (kotlinType == null) {
            return;
        }
        KotlinType returnType = kotlinType;
        KotlinBuiltIns builtIns = TypeUtilsKt.getBuiltIns(returnType);
        if (!builtIns.isBooleanOrSubtype(returnType)) {
            context.trace.report(Errors.RESULT_TYPE_MISMATCH.on((KtExpression)((PsiElement)expression.getOperationReference()), "" + '\'' + OperatorNameConventions.EQUALS + '\'', builtIns.getBooleanType(), returnType));
            return;
        }
        this.ensureNonemptyIntersectionOfOperandTypes(expression, context);
    }

    public final void checkIdentityEquality(@NotNull KtBinaryExpression expression, @NotNull ResolutionContext<?> context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        this.ensureNonemptyIntersectionOfOperandTypes(expression, context);
        this.checkIdentityOnPrimitiveOrInlineClassTypes(expression, context);
    }

    private final void checkIdentityOnPrimitiveOrInlineClassTypes(KtBinaryExpression expression, ResolutionContext<?> context) {
        KtExpression ktExpression = expression.getLeft();
        if (ktExpression == null) {
            return;
        }
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = expression.getRight();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression right = ktExpression2;
        KotlinType kotlinType = context.trace.getType(left);
        if (kotlinType == null) {
            return;
        }
        KotlinType leftType = kotlinType;
        KotlinType kotlinType2 = context.trace.getType(right);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType rightType = kotlinType2;
        if (KotlinTypeChecker.DEFAULT.equalTypes(leftType, rightType)) {
            if (KotlinBuiltIns.isPrimitiveType(leftType)) {
                context.trace.report(Errors.DEPRECATED_IDENTITY_EQUALS.on((KtBinaryExpression)((PsiElement)expression), leftType, rightType));
            }
        } else if (this.isIdentityComparedWithImplicitBoxing(leftType, rightType) || this.isIdentityComparedWithImplicitBoxing(rightType, leftType)) {
            context.trace.report(Errors.IMPLICIT_BOXING_IN_IDENTITY_EQUALS.on((KtBinaryExpression)((PsiElement)expression), leftType, rightType));
        }
        if (InlineClassesUtilsKt.isInlineClassType(leftType) || InlineClassesUtilsKt.isInlineClassType(rightType)) {
            context.trace.report(Errors.FORBIDDEN_IDENTITY_EQUALS.on((KtBinaryExpression)((PsiElement)expression), leftType, rightType));
        }
    }

    private final boolean isIdentityComparedWithImplicitBoxing(KotlinType leftType, KotlinType rightType) {
        return KotlinBuiltIns.isPrimitiveType(leftType) && !KotlinBuiltIns.isPrimitiveType(rightType) && KotlinTypeChecker.DEFAULT.isSubtypeOf(leftType, rightType);
    }

    private final void ensureNonemptyIntersectionOfOperandTypes(KtBinaryExpression expression, ResolutionContext<?> context) {
        KtExpression ktExpression = expression.getLeft();
        if (ktExpression == null) {
            return;
        }
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = expression.getRight();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression right = ktExpression2;
        KotlinType kotlinType = context.trace.getType(left);
        if (kotlinType == null) {
            return;
        }
        KotlinType leftType = kotlinType;
        KotlinType kotlinType2 = context.trace.getType(right);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType rightType = kotlinType2;
        if (TypeIntersector.isIntersectionEmpty(leftType, rightType)) {
            boolean isProperEqualityChecksEnabled = context.languageVersionSettings.supportsFeature(LanguageFeature.ProperEqualityChecksInBuilderInferenceCalls);
            boolean shouldReportWarnings = !isProperEqualityChecksEnabled && context.inferenceSession instanceof BuilderInferenceSession && context.trace.get(BindingContext.MARKED_EQUALIY_CALL_PROPER_IN_BUILDER_INFERENCE, expression) != null;
            DiagnosticFactory3<KtBinaryExpression, KtSimpleNameExpression, KotlinType, KotlinType> diagnostic = shouldReportWarnings ? Errors.EQUALITY_NOT_APPLICABLE_WARNING : Errors.EQUALITY_NOT_APPLICABLE;
            context.trace.report(diagnostic.on((KtBinaryExpression)((PsiElement)expression), expression.getOperationReference(), leftType, rightType));
        } else {
            EnumCompatibilityCheckerKt.checkEnumsForCompatibility(context, expression, leftType, rightType);
        }
        SenselessComparisonChecker.checkSenselessComparisonWithNull(expression, left, right, context, (Function1<? super KtExpression, ? extends KotlinType>)new Function1<KtExpression, KotlinType>((Object)context.trace){

            public final KotlinType invoke(KtExpression p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((BindingTrace)this.receiver).getType(p0);
            }
        }, (Function1<? super DataFlowValue, ? extends Nullability>)new Function1<DataFlowValue, Nullability>((Object)context.dataFlowInfo){

            public final Nullability invoke(DataFlowValue p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((DataFlowInfo)this.receiver).getStableNullability(p0);
            }
        });
    }
}

