/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.InlineChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R*\u0010\u0014\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00010\u0012\u0018\u00010\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/InlineCheckerWrapper;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "descriptor", "getChecker", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "Ljava/lang/ref/WeakReference;", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkersCache", "Ljava/lang/ref/WeakReference;"})
public final class InlineCheckerWrapper
implements CallChecker {
    @Nullable
    private WeakReference<Map<DeclarationDescriptor, CallChecker>> checkersCache;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        if (context.isAnnotationContext()) {
            return;
        }
        for (DeclarationDescriptor parentDescriptor = context.getScope().getOwnerDescriptor(); parentDescriptor != null; parentDescriptor = parentDescriptor.getContainingDeclaration()) {
            if (!InlineUtil.isInline(parentDescriptor)) continue;
            CallChecker checker = this.getChecker((FunctionDescriptor)parentDescriptor);
            checker.check(resolvedCall2, reportOn, context);
        }
    }

    private final CallChecker getChecker(FunctionDescriptor descriptor2) {
        Object object;
        WeakReference<Object> weakReference;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> map2;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> weakReference2 = this.checkersCache;
        if (weakReference2 == null || (weakReference2 = (Map)weakReference2.get()) == null) {
            weakReference2 = map2 = (Map)new HashMap();
        }
        if ((weakReference = this.checkersCache) == null) {
            weakReference = new WeakReference<Object>(map2);
        }
        this.checkersCache = weakReference;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> $this$getOrPut$iv = map2;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            CallChecker answer$iv = new InlineChecker(descriptor2);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CallChecker)object;
    }
}

