/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.SuspendFunctionTypeUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u000f\u001a\u00020\u000e*\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0012\u001a\u0004\u0018\u00010\u0011*\u00020\rH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u000e*\u00020\rH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0010J\u0013\u0010\u0015\u001a\u00020\u000e*\u00020\rH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0010J\u0013\u0010\u0016\u001a\u00020\u000e*\u00020\rH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/LambdaWithSuspendModifierCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "Lorg/jetbrains/kotlin/psi/Call;", "", "hasFormOfSuspendModifierForLambdaOrFun", "(Lorg/jetbrains/kotlin/psi/Call;)Z", "", "referencedName", "(Lorg/jetbrains/kotlin/psi/Call;)Ljava/lang/String;", "hasNoArgumentListButDanglingLambdas", "isInfixWithRightLambda", "isInfixWithRightFun"})
public final class LambdaWithSuspendModifierCallChecker
implements CallChecker {
    @NotNull
    public static final LambdaWithSuspendModifierCallChecker INSTANCE = new LambdaWithSuspendModifierCallChecker();

    private LambdaWithSuspendModifierCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        String variableCalleeName;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        Object obj = resolvedCall2.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, "getCandidateDescriptor(...)");
        Object descriptor2 = obj;
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue(call2, "getCall(...)");
        Call call3 = call2;
        String calleeName = this.referencedName(call3);
        Object object = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? (VariableAsFunctionResolvedCall)((Object)resolvedCall2) : null;
        String string2 = object != null && (object = object.getVariableCall()) != null && (object = object.getCall()) != null ? this.referencedName((Call)object) : (variableCalleeName = null);
        if (!(Intrinsics.areEqual(calleeName, "suspend") || Intrinsics.areEqual(variableCalleeName, "suspend") || Intrinsics.areEqual(descriptor2.getName().asString(), "suspend"))) {
            return;
        }
        if (Intrinsics.areEqual(DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)descriptor2), SuspendFunctionTypeUtilKt.KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME)) {
            if (!Intrinsics.areEqual(calleeName, "suspend") || !this.hasFormOfSuspendModifierForLambdaOrFun(call3) || call3.getExplicitReceiver() != null) {
                context.getTrace().report(Errors.NON_MODIFIER_FORM_FOR_BUILT_IN_SUSPEND.on(reportOn));
            }
        } else if ((Intrinsics.areEqual(calleeName, "suspend") || Intrinsics.areEqual(variableCalleeName, "suspend")) && this.hasFormOfSuspendModifierForLambdaOrFun(call3)) {
            if (this.hasNoArgumentListButDanglingLambdas(call3) || this.isInfixWithRightLambda(call3)) {
                context.getTrace().report(Errors.MODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND.on(reportOn));
            } else {
                if (!this.isInfixWithRightFun(call3)) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                context.getTrace().report(Errors.MODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND_FUN.on(context.getLanguageVersionSettings(), reportOn));
            }
        }
    }

    private final boolean hasFormOfSuspendModifierForLambdaOrFun(Call $this$hasFormOfSuspendModifierForLambdaOrFun) {
        return !CallUtilKt.isCallableReference($this$hasFormOfSuspendModifierForLambdaOrFun) && $this$hasFormOfSuspendModifierForLambdaOrFun.getTypeArguments().isEmpty() && (this.hasNoArgumentListButDanglingLambdas($this$hasFormOfSuspendModifierForLambdaOrFun) || this.isInfixWithRightLambda($this$hasFormOfSuspendModifierForLambdaOrFun) || this.isInfixWithRightFun($this$hasFormOfSuspendModifierForLambdaOrFun));
    }

    private final String referencedName(Call $this$referencedName) {
        KtExpression ktExpression = $this$referencedName.getCalleeExpression();
        KtSimpleNameExpression ktSimpleNameExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
        return ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedName() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasNoArgumentListButDanglingLambdas(Call $this$hasNoArgumentListButDanglingLambdas) {
        KtValueArgumentList ktValueArgumentList = $this$hasNoArgumentListButDanglingLambdas.getValueArgumentList();
        if ((ktValueArgumentList != null ? ktValueArgumentList.getLeftParenthesis() : null) != null) return false;
        List<? extends LambdaArgument> list = $this$hasNoArgumentListButDanglingLambdas.getFunctionLiteralArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getFunctionLiteralArguments(...)");
        if (((Collection)list).isEmpty()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInfixWithRightLambda(Call $this$isInfixWithRightLambda) {
        if (!CallResolverUtilKt.isInfixCall($this$isInfixWithRightLambda)) return false;
        KtElement ktElement = $this$isInfixWithRightLambda.getCallElement();
        KtBinaryExpression ktBinaryExpression = ktElement instanceof KtBinaryExpression ? (KtBinaryExpression)ktElement : null;
        if (!((ktBinaryExpression != null ? ktBinaryExpression.getRight() : null) instanceof KtLambdaExpression)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInfixWithRightFun(Call $this$isInfixWithRightFun) {
        if (!CallResolverUtilKt.isInfixCall($this$isInfixWithRightFun)) return false;
        KtElement ktElement = $this$isInfixWithRightFun.getCallElement();
        KtBinaryExpression ktBinaryExpression = ktElement instanceof KtBinaryExpression ? (KtBinaryExpression)ktElement : null;
        if (!((ktBinaryExpression != null ? ktBinaryExpression.getRight() : null) instanceof KtNamedFunction)) return false;
        return true;
    }
}

