/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ-\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030\u0004H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/NewSchemeOfIntegerOperatorResolutionChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "Lorg/jetbrains/kotlin/types/KotlinType;", "expectedType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "argument", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleDescriptor", "checkArgument", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "", "needToCheck", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "Lorg/jetbrains/kotlin/types/SimpleType;", "argumentExpression", "checkArgumentImpl", "(Lorg/jetbrains/kotlin/types/SimpleType;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "isIntOperator", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;)Z", "", "Lorg/jetbrains/kotlin/name/FqName;", "literalOperatorsFqNames", "Ljava/util/Set;"})
public final class NewSchemeOfIntegerOperatorResolutionChecker
implements CallChecker {
    @NotNull
    public static final NewSchemeOfIntegerOperatorResolutionChecker INSTANCE;
    @NotNull
    private static final Set<FqName> literalOperatorsFqNames;

    private NewSchemeOfIntegerOperatorResolutionChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map2, "getValueArguments(...)");
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : map2.entrySet()) {
            SimpleType expectedType;
            KotlinType kotlinType;
            ValueParameterDescriptor valueParameter2 = entry.getKey();
            ResolvedValueArgument arguments2 = entry.getValue();
            Intrinsics.checkNotNull(valueParameter2);
            if (ArgumentsUtilsKt.isVararg(valueParameter2)) {
                kotlinType = valueParameter2.getVarargElementType();
                if (kotlinType == null) {
                    continue;
                }
            } else {
                kotlinType = valueParameter2.getType();
            }
            if (!this.needToCheck(expectedType = FlexibleTypesKt.lowerIfFlexible(kotlinType.unwrap()))) continue;
            for (ValueArgument argument : arguments2.getArguments()) {
                KtExpression expression;
                if (KtPsiUtil.deparenthesize(argument.getArgumentExpression()) == null) continue;
                this.checkArgumentImpl(expectedType, expression, context.getTrace(), context.getModuleDescriptor());
            }
        }
    }

    public static final void checkArgument(@NotNull KotlinType expectedType, @NotNull KtExpression argument, @NotNull BindingTrace trace, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        Intrinsics.checkNotNullParameter(argument, "argument");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        if (INSTANCE.needToCheck(expectedType)) {
            SimpleType simpleType2 = FlexibleTypesKt.lowerIfFlexible(expectedType);
            KtExpression ktExpression = KtPsiUtil.deparenthesize(argument);
            Intrinsics.checkNotNull(ktExpression);
            INSTANCE.checkArgumentImpl(simpleType2, ktExpression, trace, moduleDescriptor);
        }
    }

    public final boolean needToCheck(@NotNull KotlinType expectedType) {
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        if (TypeUtils.noExpectedType(expectedType)) {
            return false;
        }
        return TypeUtilsKt.isPrimitiveNumberOrNullableType(FlexibleTypesKt.lowerIfFlexible(expectedType));
    }

    private final void checkArgumentImpl(SimpleType expectedType, KtExpression argumentExpression, BindingTrace trace, ModuleDescriptor moduleDescriptor) {
        KotlinType kotlinType;
        IElementType token;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(argumentExpression, bindingContext2);
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> callForArgument = resolvedCall2;
        if (!this.isIntOperator(callForArgument)) {
            return;
        }
        KtElement ktElement = callForArgument.getCall().getCallElement();
        KtExpression ktExpression = ktElement instanceof KtExpression ? (KtExpression)ktElement : null;
        if (ktExpression == null) {
            return;
        }
        KtExpression callElement = ktExpression;
        KtExpression ktExpression2 = KtPsiUtil.deparenthesize(callElement);
        Intrinsics.checkNotNull(ktExpression2);
        KtExpression deparenthesizedElement = ktExpression2;
        if (deparenthesizedElement instanceof KtConstantExpression) {
            return;
        }
        if (deparenthesizedElement instanceof KtUnaryExpression && (Intrinsics.areEqual(token = ((KtUnaryExpression)deparenthesizedElement).getOperationToken(), KtTokens.PLUS) || Intrinsics.areEqual(token, KtTokens.MINUS))) {
            return;
        }
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)bindingContext2.get(BindingContext.COMPILE_TIME_VALUE, argumentExpression);
        if (compileTimeConstant == null) {
            return;
        }
        CompileTimeConstant compileTimeValue = compileTimeConstant;
        CompileTimeConstant compileTimeConstant2 = compileTimeValue;
        if (compileTimeConstant2 instanceof IntegerValueTypeConstant) {
            SimpleType currentExpressionType = ((IntegerValueTypeConstant)compileTimeValue).getUnknownIntegerType();
            TypeConstructor typeConstructor2 = currentExpressionType.getConstructor();
            IntegerLiteralTypeConstructor integerLiteralTypeConstructor = typeConstructor2 instanceof IntegerLiteralTypeConstructor ? (IntegerLiteralTypeConstructor)typeConstructor2 : null;
            if (integerLiteralTypeConstructor == null) {
                return;
            }
            IntegerLiteralTypeConstructor valueTypeConstructor = integerLiteralTypeConstructor;
            kotlinType = valueTypeConstructor.getApproximatedType();
        } else if (compileTimeConstant2 instanceof TypedCompileTimeConstant) {
            SimpleType typeFromCall;
            KotlinType kotlinType2 = callForArgument.getResultingDescriptor().getReturnType();
            SimpleType simpleType2 = typeFromCall = kotlinType2 != null ? FlexibleTypesKt.lowerIfFlexible(kotlinType2) : null;
            if (typeFromCall != null) {
                kotlinType = typeFromCall;
            } else {
                ConstantValue constantValue = ((TypedCompileTimeConstant)compileTimeValue).getConstantValue();
                if (constantValue instanceof ErrorValue) {
                    return;
                }
                Object t = constantValue.getValue();
                Long l = t instanceof Long ? (Long)t : null;
                if (l == null) {
                    return;
                }
                long value2 = l;
                kotlinType = new IntegerLiteralTypeConstructor(value2, moduleDescriptor, ((TypedCompileTimeConstant)compileTimeValue).getParameters()).getApproximatedType();
            }
        } else {
            return;
        }
        KotlinType newExpressionType = kotlinType;
        if (!Intrinsics.areEqual(newExpressionType.getConstructor(), expectedType.getConstructor())) {
            boolean willBeConversion;
            boolean bl = willBeConversion = TypeUtilsKt.isInt(newExpressionType) && TypeUtilsKt.isLong(TypeUtilsKt.makeNotNullable(expectedType));
            if (!willBeConversion) {
                trace.report(Errors.INTEGER_OPERATOR_RESOLVE_WILL_CHANGE.on((KtExpression)((PsiElement)argumentExpression), newExpressionType));
            }
        }
    }

    private final boolean isIntOperator(ResolvedCall<?> $this$isIntOperator) {
        Object obj = $this$isIntOperator.getResultingDescriptor();
        SimpleFunctionDescriptor simpleFunctionDescriptor = obj instanceof SimpleFunctionDescriptor ? (SimpleFunctionDescriptor)obj : null;
        if (simpleFunctionDescriptor == null) {
            return false;
        }
        SimpleFunctionDescriptor descriptor2 = simpleFunctionDescriptor;
        return literalOperatorsFqNames.contains(DescriptorUtilsKt.getFqNameSafe(descriptor2));
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        void $this$mapTo$iv;
        INSTANCE = new NewSchemeOfIntegerOperatorResolutionChecker();
        Object object = new String[]{"plus", "minus", "times", "div", "rem", "plus", "minus", "times", "div", "rem", "shl", "shr", "ushr", "and", "or", "xor", "unaryPlus", "unaryMinus", "inv"};
        object = CollectionsKt.listOf(object);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string2 = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"kotlin", "Int", it};
            collection.add(FqName.Companion.fromSegments(CollectionsKt.listOf(stringArray)));
        }
        literalOperatorsFqNames = (Set)var1_1;
    }
}

