/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/OperatorCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "Companion"})
public final class OperatorCallChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        boolean isConventionOperator;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        Object object = resolvedCall2.getResultingDescriptor();
        FunctionDescriptor functionDescriptor = object instanceof FunctionDescriptor ? (FunctionDescriptor)object : null;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (!OperatorCallChecker.Companion.checkNotErrorOrDynamic(functionDescriptor2)) {
            return;
        }
        KtExpression ktExpression = resolvedCall2.getCall().getCalleeExpression();
        object = ktExpression != null ? (KtElement)ktExpression : resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNull(object);
        Object element = object;
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue(call2, "getCall(...)");
        Call call3 = call2;
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall && call3 instanceof CallTransformer.CallForImplicitInvoke && ((CallTransformer.CallForImplicitInvoke)call3).itIsVariableAsFunctionCall) {
            Call call4 = ((CallTransformer.CallForImplicitInvoke)call3).getOuterCall();
            Intrinsics.checkNotNullExpressionValue(call4, "getOuterCall(...)");
            Call outerCall = call4;
            if (CallResolverUtilKt.isConventionCall(outerCall)) {
                DeclarationDescriptor declarationDescriptor = functionDescriptor2.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
                String containingDeclarationName = DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor).asString();
                context.getTrace().report(Errors.PROPERTY_AS_OPERATOR.on(reportOn, functionDescriptor2, containingDeclarationName));
            } else if (OperatorCallChecker.Companion.isWrongCallWithExplicitTypeArguments((VariableAsFunctionResolvedCall)((Object)resolvedCall2), outerCall)) {
                context.getTrace().report(Errors.TYPE_ARGUMENTS_NOT_ALLOWED.on((KtElement)((PsiElement)((KtElement)reportOn)), "on implicit invoke call"));
            }
        }
        if (call3.getCallElement() instanceof KtDestructuringDeclarationEntry || call3 instanceof CallTransformer.CallForImplicitInvoke) {
            if (!functionDescriptor2.isOperator()) {
                Companion.report(reportOn, functionDescriptor2, context.getTrace());
            }
            return;
        }
        boolean bl = isConventionOperator = element instanceof KtOperationReferenceExpression && ((KtOperationReferenceExpression)element).isConventionOperator();
        if ((isConventionOperator || element instanceof KtArrayAccessExpression) && !functionDescriptor2.isOperator()) {
            Companion.report(reportOn, functionDescriptor2, context.getTrace());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/OperatorCallChecker$Companion;", "", "<init>", "()V", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "sink", "", "report", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;)V", "functionDescriptor", "", "checkNotErrorOrDynamic", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "Lorg/jetbrains/kotlin/resolve/calls/model/VariableAsFunctionResolvedCall;", "resolvedCall", "Lorg/jetbrains/kotlin/psi/Call;", "outerCall", "isWrongCallWithExplicitTypeArguments", "(Lorg/jetbrains/kotlin/resolve/calls/model/VariableAsFunctionResolvedCall;Lorg/jetbrains/kotlin/psi/Call;)Z"})
    public static final class Companion {
        private Companion() {
        }

        public final void report(@NotNull PsiElement reportOn, @NotNull FunctionDescriptor descriptor2, @NotNull DiagnosticSink sink) {
            Intrinsics.checkNotNullParameter(reportOn, "reportOn");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(sink, "sink");
            if (!this.checkNotErrorOrDynamic(descriptor2)) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
            DeclarationDescriptor containingDeclaration = declarationDescriptor;
            String containingDeclarationName = DescriptorUtilsKt.getFqNameUnsafe(containingDeclaration).asString();
            sink.report(Errors.OPERATOR_MODIFIER_REQUIRED.on(reportOn, descriptor2, containingDeclarationName));
        }

        private final boolean checkNotErrorOrDynamic(FunctionDescriptor functionDescriptor) {
            return !DynamicCallsKt.isDynamic(functionDescriptor) && !ErrorUtils.isError(functionDescriptor);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isWrongCallWithExplicitTypeArguments(VariableAsFunctionResolvedCall resolvedCall2, Call outerCall) {
            List<KtTypeProjection> list = outerCall.getTypeArguments();
            Intrinsics.checkNotNullExpressionValue(list, "getTypeArguments(...)");
            if (((Collection)list).isEmpty()) return false;
            boolean bl = true;
            if (!bl) return false;
            List<TypeParameterDescriptor> list2 = resolvedCall2.getFunctionCall().getCandidateDescriptor().getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "getTypeParameters(...)");
            if (((Collection)list2).isEmpty()) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            boolean bl3 = true;
            boolean passedTypeArgumentsToInvoke = bl3;
            if (!passedTypeArgumentsToInvoke) return false;
            List<TypeParameterDescriptor> list3 = resolvedCall2.getVariableCall().getCandidateDescriptor().getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list3, "getTypeParameters(...)");
            if (((Collection)list3).isEmpty()) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

