/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ResolutionToPrivateConstructorOfSealedClassChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V"})
public final class ResolutionToPrivateConstructorOfSealedClassChecker
implements CallChecker {
    @NotNull
    public static final ResolutionToPrivateConstructorOfSealedClassChecker INSTANCE = new ResolutionToPrivateConstructorOfSealedClassChecker();

    private ResolutionToPrivateConstructorOfSealedClassChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        ReceiverValue receiver;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowSealedInheritorsInDifferentFilesOfSamePackage)) {
            return;
        }
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.UseConsistentRulesForPrivateConstructorsOfSealedClasses)) {
            return;
        }
        Object obj = resolvedCall2.getResultingDescriptor();
        ConstructorDescriptor constructorDescriptor = obj instanceof ConstructorDescriptor ? (ConstructorDescriptor)obj : null;
        if (constructorDescriptor == null) {
            return;
        }
        ConstructorDescriptor descriptor2 = constructorDescriptor;
        if (!Intrinsics.areEqual(descriptor2.getVisibility(), DescriptorVisibilities.PRIVATE)) {
            return;
        }
        ClassDescriptor classDescriptor = descriptor2.getConstructedClass();
        Intrinsics.checkNotNullExpressionValue(classDescriptor, "getConstructedClass(...)");
        if (!DescriptorUtilKt.isSealed(classDescriptor)) {
            return;
        }
        DeclarationDescriptor containingDescriptor = context.getScope().getOwnerDescriptor();
        ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
        if (receiverValue == null) {
            receiverValue = DescriptorVisibilities.ALWAYS_SUITABLE_RECEIVER;
        }
        if (DescriptorVisibilities.findInvisibleMember(receiver = receiverValue, descriptor2, containingDescriptor, false) != null) {
            context.getTrace().report(Errors.RESOLUTION_TO_PRIVATE_CONSTRUCTOR_OF_SEALED_CLASS.on(reportOn));
        }
    }
}

