/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/SelfCallInNestedObjectConstructorChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "Visitor"})
public final class SelfCallInNestedObjectConstructorChecker
implements CallChecker {
    @NotNull
    public static final SelfCallInNestedObjectConstructorChecker INSTANCE = new SelfCallInNestedObjectConstructorChecker();

    private SelfCallInNestedObjectConstructorChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        block5: {
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(reportOn, "reportOn");
            Intrinsics.checkNotNullParameter(context, "context");
            Object obj = resolvedCall2.getCandidateDescriptor();
            Intrinsics.checkNotNullExpressionValue(obj, "getCandidateDescriptor(...)");
            Object candidateDescriptor = obj;
            Call call2 = resolvedCall2.getCall();
            Intrinsics.checkNotNullExpressionValue(call2, "getCall(...)");
            Call call3 = call2;
            if (!(candidateDescriptor instanceof ConstructorDescriptor) || !CallResolverUtilKt.isSuperOrDelegatingConstructorCall(call3)) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = context.getResolutionContext().scope.getOwnerDescriptor().getContainingDeclaration();
            ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor constructedObject = classDescriptor;
            if (constructedObject.getKind() != ClassKind.OBJECT) {
                return;
            }
            DeclarationDescriptor declarationDescriptor2 = constructedObject.getContainingDeclaration();
            ClassDescriptor classDescriptor2 = declarationDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor2 : null;
            if (classDescriptor2 == null) {
                return;
            }
            ClassDescriptor containingClass = classDescriptor2;
            if (!Intrinsics.areEqual(((ConstructorDescriptor)candidateDescriptor).getConstructedClass(), containingClass)) break block5;
            Visitor visitor2 = new Visitor(containingClass, context.getTrace(), context.getLanguageVersionSettings());
            KtValueArgumentList ktValueArgumentList = resolvedCall2.getCall().getValueArgumentList();
            if (ktValueArgumentList != null) {
                ktValueArgumentList.accept(visitor2);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0012J!\u0010\u0018\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010 \u001a\u0004\b!\u0010\""}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/SelfCallInNestedObjectConstructorChecker$Visitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "containingClass", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "", "visitKtElement", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "visitExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;)V", "argumentExpression", "checkArgument", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "receiver", "argument", "checkReceiver", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getContainingClass", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;"})
    private static final class Visitor
    extends KtVisitorVoid {
        @NotNull
        private final ClassDescriptor containingClass;
        @NotNull
        private final BindingTrace trace;
        @NotNull
        private final LanguageVersionSettings languageVersionSettings;

        public Visitor(@NotNull ClassDescriptor containingClass, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings) {
            Intrinsics.checkNotNullParameter(containingClass, "containingClass");
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
            this.containingClass = containingClass;
            this.trace = trace;
            this.languageVersionSettings = languageVersionSettings;
        }

        @NotNull
        public final ClassDescriptor getContainingClass() {
            return this.containingClass;
        }

        @NotNull
        public final BindingTrace getTrace() {
            return this.trace;
        }

        @NotNull
        public final LanguageVersionSettings getLanguageVersionSettings() {
            return this.languageVersionSettings;
        }

        @Override
        public void visitKtElement(@NotNull KtElement element) {
            Intrinsics.checkNotNullParameter(element, "element");
            element.acceptChildren(this, null);
        }

        @Override
        public void visitExpression(@NotNull KtExpression expression) {
            Intrinsics.checkNotNullParameter(expression, "expression");
            this.checkArgument(expression);
            expression.acceptChildren(this, null);
        }

        private final void checkArgument(KtExpression argumentExpression) {
            KtElement ktElement = argumentExpression;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            Call call2 = CallUtilKt.getCall(ktElement, bindingContext);
            if (call2 == null) {
                return;
            }
            Call call3 = call2;
            BindingContext bindingContext2 = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext2, "getBindingContext(...)");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(call3, bindingContext2);
            if (resolvedCall2 == null) {
                return;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            this.checkReceiver(resolvedCall3.getDispatchReceiver(), argumentExpression);
        }

        private final void checkReceiver(ReceiverValue receiver, KtExpression argument) {
            Object object = receiver;
            if (object == null || (object = object.getType()) == null) {
                return;
            }
            Object receiverType = object;
            ClassifierDescriptor classifierDescriptor = ((KotlinType)receiverType).getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor receiverClass = classDescriptor;
            if (DescriptorUtils.isSubclass(receiverClass, this.containingClass)) {
                this.trace.report(Errors.SELF_CALL_IN_NESTED_OBJECT_CONSTRUCTOR.on(this.languageVersionSettings, (KtExpression)((PsiElement)argument)));
            }
        }
    }
}

