/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J%\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0019J\u0013\u0010\u001c\u001a\u00020\u001b*\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/UnderscoreUsageChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "Lorg/jetbrains/kotlin/psi/KtElement;", "ktElement", "checkCallElement", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "ktName", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "checkSimpleNameUsage", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "", "", "isUnderscoreOnlyName", "(Ljava/lang/String;)Z"})
public final class UnderscoreUsageChecker
implements CallChecker {
    @NotNull
    public static final UnderscoreUsageChecker INSTANCE = new UnderscoreUsageChecker();

    private UnderscoreUsageChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            return;
        }
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, "getResultingDescriptor(...)");
        Object descriptor2 = obj;
        Substitutable<CallableDescriptor> substitutable = descriptor2 instanceof ConstructorDescriptor ? (ConstructorDescriptor)descriptor2 : null;
        DeclarationDescriptor namedDescriptor = substitutable != null && (substitutable = substitutable.getContainingDeclaration()) != null ? (DeclarationDescriptor)((Object)substitutable) : (DeclarationDescriptor)descriptor2;
        String string2 = namedDescriptor.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        if (!this.isUnderscoreOnlyName(string2)) {
            return;
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue(ktElement, "getCallElement(...)");
        this.checkCallElement(ktElement, context);
    }

    private final void checkCallElement(KtElement ktElement, CallCheckerContext context) {
        block2: {
            KtElement ktElement2;
            block1: {
                ktElement2 = ktElement;
                if (!(ktElement2 instanceof KtSimpleNameExpression)) break block1;
                this.checkSimpleNameUsage((KtSimpleNameExpression)ktElement, context.getTrace());
                break block2;
            }
            if (!(ktElement2 instanceof KtCallExpression)) break block2;
            KtExpression ktExpression = ((KtCallExpression)ktElement).getCalleeExpression();
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                INSTANCE.checkCallElement(it, context);
            }
        }
    }

    private final void checkSimpleNameUsage(KtSimpleNameExpression ktName, BindingTrace trace) {
        String string2 = ktName.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        if (this.isUnderscoreOnlyName(string2)) {
            trace.report(Errors.UNDERSCORE_USAGE_WITHOUT_BACKTICKS.on(ktName));
        }
    }

    public final void checkSimpleNameUsage(@NotNull DeclarationDescriptor descriptor2, @NotNull KtSimpleNameExpression ktName, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(ktName, "ktName");
        Intrinsics.checkNotNullParameter(trace, "trace");
        String string2 = descriptor2.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        if (this.isUnderscoreOnlyName(string2)) {
            this.checkSimpleNameUsage(ktName, trace);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnderscoreOnlyName(String $this$isUnderscoreOnlyName) {
        if (((CharSequence)$this$isUnderscoreOnlyName).length() <= 0) return false;
        boolean bl = true;
        if (!bl) return false;
        CharSequence $this$all$iv = $this$isUnderscoreOnlyName;
        boolean $i$f$all = false;
        int n = 0;
        while (n < $this$all$iv.length()) {
            char element$iv;
            char it = element$iv = $this$all$iv.charAt(n);
            boolean bl2 = false;
            if (it != '_') return false;
            boolean bl3 = true;
            if (!bl3) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

