/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/UnsupportedUntilOperatorChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V"})
public final class UnsupportedUntilOperatorChecker
implements CallChecker {
    @NotNull
    public static final UnsupportedUntilOperatorChecker INSTANCE = new UnsupportedUntilOperatorChecker();

    private UnsupportedUntilOperatorChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        KtExpression ktExpression = resolvedCall2.getCall().getCalleeExpression();
        KtOperationReferenceExpression ktOperationReferenceExpression = ktExpression instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)ktExpression : null;
        if (ktOperationReferenceExpression == null) {
            return;
        }
        KtOperationReferenceExpression calleeExpression = ktOperationReferenceExpression;
        boolean isRangeUntilOperatorSupported = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.RangeUntilOperator);
        if (Intrinsics.areEqual(calleeExpression.getOperationSignTokenType(), KtTokens.RANGE_UNTIL) && !isRangeUntilOperatorSupported) {
            context.getTrace().report(Errors.UNSUPPORTED_FEATURE.on(reportOn, TuplesKt.to(LanguageFeature.RangeUntilOperator, context.getLanguageVersionSettings())));
        }
    }
}

