/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/UselessElvisCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V"})
public final class UselessElvisCallChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!Intrinsics.areEqual(((Named)resolvedCall2.getResultingDescriptor()).getName(), ControlStructureTypingUtils.ResolveConstruct.ELVIS.getSpecialFunctionName())) {
            return;
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        KtBinaryExpression ktBinaryExpression = ktElement instanceof KtBinaryExpression ? (KtBinaryExpression)ktElement : null;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression elvisBinaryExpression = ktBinaryExpression;
        KtExpression ktExpression = elvisBinaryExpression.getLeft();
        if (ktExpression == null) {
            return;
        }
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = elvisBinaryExpression.getRight();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression right = ktExpression2;
        KotlinType kotlinType = context.getTrace().getType(left);
        if (kotlinType == null) {
            return;
        }
        KotlinType leftType = kotlinType;
        if (KotlinTypeKt.isError(leftType) || TypeUtilsKt.contains(leftType, UselessElvisCallChecker::check$lambda$0)) {
            return;
        }
        if (!TypeUtils.isNullableType(leftType)) {
            BindingTrace bindingTrace = context.getTrace();
            ParametrizedDiagnostic<KtBinaryExpression> parametrizedDiagnostic = Errors.USELESS_ELVIS.on((KtBinaryExpression)((PsiElement)elvisBinaryExpression), leftType);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
            return;
        }
        DataFlowValue dataFlowValue = context.getDataFlowValueFactory().createDataFlowValue(left, leftType, context.getResolutionContext());
        if (context.getDataFlowInfo().getStableNullability(dataFlowValue) == Nullability.NOT_NULL) {
            BindingTrace bindingTrace = context.getTrace();
            ParametrizedDiagnostic<KtBinaryExpression> parametrizedDiagnostic = Errors.USELESS_ELVIS.on((KtBinaryExpression)((PsiElement)elvisBinaryExpression), leftType);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
            return;
        }
        if (KtPsiUtil.isNullConstant(right) && !FlexibleTypesKt.isNullabilityFlexible(leftType)) {
            BindingTrace bindingTrace = context.getTrace();
            SimpleDiagnostic<KtBinaryExpression> simpleDiagnostic = Errors.USELESS_ELVIS_RIGHT_IS_NULL.on((KtBinaryExpression)((PsiElement)elvisBinaryExpression));
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, "on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
        }
    }

    private static final boolean check$lambda$0(UnwrappedType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getConstructor() instanceof TypeVariableTypeConstructor;
    }
}

