/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.resolve.calls.model.CollectionLiteralKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolverKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.IntersectionTypeKt;
import org.jetbrains.kotlin.types.checker.NewCapturedTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a#\u0010\n\u001a\u00020\t*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0001\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u0011\u0010\u000e\u001a\u00020\r*\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a'\u0010\u0012\u001a\u00020\r*\u00020\f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a#\u0010\u0014\u001a\u00020\r*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a#\u0010\u0016\u001a\u00020\r*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0015\u001a\u0011\u0010\u0017\u001a\u00020\r*\u00020\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018\"\u001a\u0010\u001c\u001a\u0004\u0018\u00010\t*\u00020\u00198AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\"\u0015\u0010\u001e\u001a\u00020\t*\u00020\u00198G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001b\"\u0015\u0010\u001f\u001a\u00020\r*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000f\"\u0015\u0010\u001f\u001a\u00020\r*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u0015\u0010!\u001a\u00020\r*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000f\"\u0015\u0010\"\u001a\u00020\r*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "argument", "", "unexpectedArgument", "(Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;)Ljava/lang/Void;", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "parameter", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "getExpectedType", "(Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)Lorg/jetbrains/kotlin/types/UnwrappedType;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "", "hasDefaultValue", "(Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)Z", "Lkotlin/Function1;", "checker", "checkExpectedParameter", "(Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;Lkotlin/jvm/functions/Function1;)Z", "isArrayAssignedAsNamedArgumentInAnnotation", "(Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)Z", "isArrayAssignedAsNamedArgumentInFunction", "isArrayOrArrayLiteral", "(Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;)Z", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "getUnstableType", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;)Lorg/jetbrains/kotlin/types/UnwrappedType;", "unstableType", "getStableType", "stableType", "isVararg", "(Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;)Z", "isActualParameterWithAnyExpectedDefault", "isActualParameterWithCorrespondingExpectedDefault"})
public final class ArgumentsUtilsKt {
    @NotNull
    public static final Void unexpectedArgument(@NotNull KotlinCallArgument argument) {
        Intrinsics.checkNotNullParameter(argument, "argument");
        throw new IllegalStateException(("Unexpected argument type: " + argument + ", " + argument.getClass().getCanonicalName() + '.').toString());
    }

    @Nullable
    public static final UnwrappedType getUnstableType(@NotNull ReceiverValueWithSmartCastInfo $this$unstableType) {
        Intrinsics.checkNotNullParameter($this$unstableType, "<this>");
        if ($this$unstableType.isStable() || !$this$unstableType.hasTypesFromSmartCasts()) {
            return $this$unstableType.isStable() ? null : $this$unstableType.getReceiverValue().getType().unwrap();
        }
        UnwrappedType intersectionType = IntersectionTypeKt.intersectWrappedTypes((Collection<? extends KotlinType>)$this$unstableType.getAllOriginalTypes());
        UnwrappedType unwrappedType = NewCapturedTypeKt.prepareArgumentTypeRegardingCaptureTypes(intersectionType);
        if (unwrappedType == null) {
            unwrappedType = intersectionType;
        }
        return unwrappedType;
    }

    @NotNull
    public static final UnwrappedType getStableType(@NotNull ReceiverValueWithSmartCastInfo $this$stableType) {
        Intrinsics.checkNotNullParameter($this$stableType, "<this>");
        if (!$this$stableType.isStable() || !$this$stableType.hasTypesFromSmartCasts()) {
            return $this$stableType.getReceiverValue().getType().unwrap();
        }
        UnwrappedType intersectionType = IntersectionTypeKt.intersectWrappedTypes((Collection<? extends KotlinType>)$this$stableType.getAllOriginalTypes());
        if (TypeUtilsKt.isNullableNothing(intersectionType) && !intersectionType.isMarkedNullable()) {
            return TypeUtilsKt.makeNullable(intersectionType).unwrap();
        }
        UnwrappedType unwrappedType = NewCapturedTypeKt.prepareArgumentTypeRegardingCaptureTypes(intersectionType);
        if (unwrappedType == null) {
            unwrappedType = intersectionType;
        }
        return unwrappedType;
    }

    @NotNull
    public static final UnwrappedType getExpectedType(@NotNull KotlinCallArgument $this$getExpectedType, @NotNull ParameterDescriptor parameter, @NotNull LanguageVersionSettings languageVersionSettings) {
        Annotated annotated;
        Intrinsics.checkNotNullParameter($this$getExpectedType, "<this>");
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        if ($this$getExpectedType.isSpread() || ArgumentsUtilsKt.isArrayAssignedAsNamedArgumentInAnnotation($this$getExpectedType, parameter, languageVersionSettings) || ArgumentsUtilsKt.isArrayAssignedAsNamedArgumentInFunction($this$getExpectedType, parameter, languageVersionSettings)) {
            annotated = parameter.getType().unwrap();
        } else {
            annotated = parameter instanceof ValueParameterDescriptor ? (ValueParameterDescriptor)parameter : null;
            if (annotated == null || (annotated = annotated.getVarargElementType()) == null || (annotated = ((KotlinType)annotated).unwrap()) == null) {
                annotated = parameter.getType().unwrap();
            }
        }
        return annotated;
    }

    public static final boolean isVararg(@NotNull ValueParameterDescriptor $this$isVararg) {
        Intrinsics.checkNotNullParameter($this$isVararg, "<this>");
        return $this$isVararg.getVarargElementType() != null;
    }

    public static final boolean isVararg(@NotNull ParameterDescriptor $this$isVararg) {
        Intrinsics.checkNotNullParameter($this$isVararg, "<this>");
        ValueParameterDescriptor valueParameterDescriptor = $this$isVararg instanceof ValueParameterDescriptor ? (ValueParameterDescriptor)$this$isVararg : null;
        return valueParameterDescriptor != null ? ArgumentsUtilsKt.isVararg(valueParameterDescriptor) : false;
    }

    public static final boolean hasDefaultValue(@NotNull ValueParameterDescriptor $this$hasDefaultValue) {
        Intrinsics.checkNotNullParameter($this$hasDefaultValue, "<this>");
        Boolean bl = DFS.ifAny((Collection)CollectionsKt.listOf($this$hasDefaultValue), ArgumentsUtilsKt::hasDefaultValue$lambda$0, ArgumentsUtilsKt::hasDefaultValue$lambda$1);
        Intrinsics.checkNotNullExpressionValue(bl, "ifAny(...)");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkExpectedParameter(ValueParameterDescriptor $this$checkExpectedParameter, Function1<? super ValueParameterDescriptor, Boolean> checker) {
        CallableDescriptor function2 = $this$checkExpectedParameter.getContainingDeclaration();
        if (!(function2 instanceof FunctionDescriptor)) return false;
        if (!((FunctionDescriptor)function2).isActual()) return false;
        MemberDescriptor expected = (MemberDescriptor)CollectionsKt.firstOrNull(ExpectedActualResolverKt.findCompatibleExpectsForActual$default((MemberDescriptor)((Object)function2), null, 1, null));
        if (!(expected instanceof FunctionDescriptor)) return false;
        ValueParameterDescriptor valueParameterDescriptor = ((FunctionDescriptor)expected).getValueParameters().get($this$checkExpectedParameter.getIndex());
        Intrinsics.checkNotNullExpressionValue(valueParameterDescriptor, "get(...)");
        if (checker.invoke(valueParameterDescriptor) == false) return false;
        return true;
    }

    public static final boolean isActualParameterWithAnyExpectedDefault(@NotNull ValueParameterDescriptor $this$isActualParameterWithAnyExpectedDefault) {
        Intrinsics.checkNotNullParameter($this$isActualParameterWithAnyExpectedDefault, "<this>");
        return ArgumentsUtilsKt.checkExpectedParameter($this$isActualParameterWithAnyExpectedDefault, ArgumentsUtilsKt::_get_isActualParameterWithAnyExpectedDefault_$lambda$2);
    }

    public static final boolean isActualParameterWithCorrespondingExpectedDefault(@NotNull ValueParameterDescriptor $this$isActualParameterWithCorrespondingExpectedDefault) {
        Intrinsics.checkNotNullParameter($this$isActualParameterWithCorrespondingExpectedDefault, "<this>");
        return ArgumentsUtilsKt.checkExpectedParameter($this$isActualParameterWithCorrespondingExpectedDefault, ArgumentsUtilsKt::_get_isActualParameterWithCorrespondingExpectedDefault_$lambda$3);
    }

    private static final boolean isArrayAssignedAsNamedArgumentInAnnotation(KotlinCallArgument $this$isArrayAssignedAsNamedArgumentInAnnotation, ParameterDescriptor parameter, LanguageVersionSettings languageVersionSettings) {
        boolean isAllowedAssigningSingleElementsToVarargsInNamedForm;
        if (!languageVersionSettings.supportsFeature(LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations)) {
            return false;
        }
        boolean bl = isAllowedAssigningSingleElementsToVarargsInNamedForm = !languageVersionSettings.supportsFeature(LanguageFeature.ProhibitAssigningSingleElementsToVarargsInNamedForm);
        if (isAllowedAssigningSingleElementsToVarargsInNamedForm && !ArgumentsUtilsKt.isArrayOrArrayLiteral($this$isArrayAssignedAsNamedArgumentInAnnotation)) {
            return false;
        }
        return $this$isArrayAssignedAsNamedArgumentInAnnotation.getArgumentName() != null && ArgumentsUtilsKt.isVararg(parameter) && DescriptorUtilsKt.isParameterOfAnnotation(parameter);
    }

    private static final boolean isArrayAssignedAsNamedArgumentInFunction(KotlinCallArgument $this$isArrayAssignedAsNamedArgumentInFunction, ParameterDescriptor parameter, LanguageVersionSettings languageVersionSettings) {
        boolean isAllowedAssigningSingleElementsToVarargsInNamedForm;
        if (!languageVersionSettings.supportsFeature(LanguageFeature.AllowAssigningArrayElementsToVarargsInNamedFormForFunctions)) {
            return false;
        }
        boolean bl = isAllowedAssigningSingleElementsToVarargsInNamedForm = !languageVersionSettings.supportsFeature(LanguageFeature.ProhibitAssigningSingleElementsToVarargsInNamedForm);
        if (isAllowedAssigningSingleElementsToVarargsInNamedForm && !ArgumentsUtilsKt.isArrayOrArrayLiteral($this$isArrayAssignedAsNamedArgumentInFunction)) {
            return false;
        }
        return $this$isArrayAssignedAsNamedArgumentInFunction.getArgumentName() != null && ArgumentsUtilsKt.isVararg(parameter);
    }

    public static final boolean isArrayOrArrayLiteral(@NotNull KotlinCallArgument $this$isArrayOrArrayLiteral) {
        Intrinsics.checkNotNullParameter($this$isArrayOrArrayLiteral, "<this>");
        if ($this$isArrayOrArrayLiteral instanceof CollectionLiteralKotlinCallArgument) {
            return true;
        }
        if (!($this$isArrayOrArrayLiteral instanceof SimpleKotlinCallArgument)) {
            return false;
        }
        KotlinType kotlinType = ((SimpleKotlinCallArgument)$this$isArrayOrArrayLiteral).getReceiver().getReceiverValue().getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        KotlinType type2 = kotlinType;
        return KotlinBuiltIns.isArrayOrPrimitiveArray(type2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable hasDefaultValue$lambda$0(ValueParameterDescriptor current) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = current.getOverriddenDescriptors();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getOriginal());
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Boolean hasDefaultValue$lambda$1(ValueParameterDescriptor it) {
        boolean bl;
        if (!it.declaresDefaultValue()) {
            Intrinsics.checkNotNull(it);
            if (!ArgumentsUtilsKt.isActualParameterWithCorrespondingExpectedDefault(it)) {
                bl = false;
                return bl;
            }
        }
        bl = true;
        return bl;
    }

    private static final boolean _get_isActualParameterWithAnyExpectedDefault_$lambda$2(ValueParameterDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ArgumentsUtilsKt.hasDefaultValue(it);
    }

    private static final boolean _get_isActualParameterWithCorrespondingExpectedDefault_$lambda$3(ValueParameterDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.declaresDefaultValue();
    }
}

